/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.attr.prop;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableListIterator;
import com.kamesuta.mc.bnnwidget.ShortestFloatFormatter;
import com.kamesuta.mc.bnnwidget.render.OpenGL;
import com.kamesuta.mc.signpic.attr.IPropBuilder;
import com.kamesuta.mc.signpic.attr.IPropComposable;
import com.kamesuta.mc.signpic.attr.IPropInterpolatable;
import com.kamesuta.mc.signpic.attr.prop.PropSyntax;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Quat4f;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class RotationData {
    public static final float defaultOffset = 4.0f;
    public static final float defaultAngle = 0.0f;
    public static final float defaultAxis = 1.0f;

    @Nonnull
    public Quat4f getRotate() {
        return this.getRotate(1.0f);
    }

    @Nonnull
    public abstract Quat4f getRotate(float var1);

    public static class RotationBuilder
    implements IPropBuilder<DiffRotation, KeyRotation> {
        @Nonnull
        public final List<ImageRotate> rotates = Lists.newLinkedList();
        public float x = 0.0f;
        public float y = 0.0f;
        public float z = 0.0f;
        public float angle = 0.0f;
        @Nullable
        public KeyRotation base;

        @Override
        @Nonnull
        public DiffRotation diff(@Nullable KeyRotation base) {
            if (base == null) {
                base = new BaseRotation();
            }
            AxisAngle4f axis = new AxisAngle4f(this.x, this.y, this.z, this.angle);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ImageRotate rotate : this.rotates) {
                builder.add((Object)rotate.build());
            }
            return new DiffRotation(base, axis, (ImmutableList<Rotate>)builder.build());
        }

        @Override
        public boolean parse(@Nonnull String src, @Nonnull String key, @Nonnull String value) {
            if (StringUtils.equals((CharSequence)key, (CharSequence)RotateType.X.name())) {
                this.rotates.add(new ImageRotate(RotateType.X, NumberUtils.toFloat((String)value, (float)4.0f)));
            } else if (StringUtils.equals((CharSequence)key, (CharSequence)RotateType.Y.name())) {
                this.rotates.add(new ImageRotate(RotateType.Y, NumberUtils.toFloat((String)value, (float)4.0f)));
            } else if (StringUtils.equals((CharSequence)key, (CharSequence)PropSyntax.ROTATION_Z.id)) {
                this.rotates.add(new ImageRotate(RotateType.Z, NumberUtils.toFloat((String)value, (float)4.0f)));
            } else if (StringUtils.equals((CharSequence)key, (CharSequence)PropSyntax.ROTATION_ANGLE.id)) {
                this.angle += RotationMath.toRadians(NumberUtils.toFloat((String)value, (float)0.0f) * 360.0f / 8.0f);
            } else if (StringUtils.equals((CharSequence)key, (CharSequence)PropSyntax.ROTATION_AXIS_X.id)) {
                this.x = StringUtils.isEmpty((CharSequence)value) ? (this.x += 1.0f) : (this.x += NumberUtils.toFloat((String)value, (float)1.0f));
            } else if (StringUtils.equals((CharSequence)key, (CharSequence)PropSyntax.ROTATION_AXIS_Y.id)) {
                this.y = StringUtils.isEmpty((CharSequence)value) ? (this.y += 1.0f) : (this.y += NumberUtils.toFloat((String)value, (float)1.0f));
            } else if (StringUtils.equals((CharSequence)key, (CharSequence)PropSyntax.ROTATION_AXIS_Z.id)) {
                this.z = StringUtils.isEmpty((CharSequence)value) ? (this.z += 1.0f) : (this.z += NumberUtils.toFloat((String)value, (float)1.0f));
            } else {
                return false;
            }
            return true;
        }

        @Override
        @Nonnull
        public String compose() {
            return this.diff(null).compose();
        }

        @Nonnull
        public String toString() {
            return this.compose();
        }

        public static class ImageRotate {
            @Nonnull
            public RotateType type;
            public float rotate;

            public ImageRotate(@Nonnull RotateType type, float rotate) {
                this.type = type;
                this.rotate = rotate;
            }

            @Nonnull
            public Rotate build() {
                return new Rotate(this.type, this.rotate);
            }
        }
    }

    public static class RotationGL {
        public static void glRotate(@Nonnull AxisAngle4f axis) {
            OpenGL.glRotatef(RotationMath.toDegrees(axis.angle), axis.x, axis.y, axis.z);
        }

        public static void glRotate(@Nonnull Quat4f quat) {
            RotationGL.glRotate(RotationMath.toAxis(quat));
        }
    }

    public static class RotationMath {
        public static final float PI = (float)Math.PI;

        @Nonnull
        public static Quat4f newQuat() {
            return new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        }

        public static float toRadians(float angdeg) {
            return angdeg / 180.0f * (float)Math.PI;
        }

        public static float toDegrees(float angrad) {
            return angrad * 180.0f / (float)Math.PI;
        }

        @Nonnull
        public static Quat4f toQuat(@Nonnull AxisAngle4f axis) {
            if (axis.angle == 0.0f) {
                return RotationMath.newQuat();
            }
            Quat4f q = new Quat4f();
            q.set(axis);
            return q;
        }

        @Nonnull
        public static AxisAngle4f toAxis(@Nonnull Quat4f quat) {
            AxisAngle4f q = new AxisAngle4f();
            q.set(quat);
            return q;
        }

        @Nonnull
        public static AxisAngle4f axisRad(float angle, float x, float y, float z) {
            return new AxisAngle4f(x, y, z, angle);
        }

        @Nonnull
        public static AxisAngle4f axisDeg(float angle, float x, float y, float z) {
            return new AxisAngle4f(x, y, z, RotationMath.toRadians(angle));
        }

        @Nonnull
        public static Quat4f quatRad(float angle, float x, float y, float z) {
            return RotationMath.toQuat(RotationMath.axisRad(angle, x, y, z));
        }

        @Nonnull
        public static Quat4f quatDeg(float angle, float x, float y, float z) {
            return RotationMath.toQuat(RotationMath.axisDeg(angle, x, y, z));
        }
    }

    public static enum RotateType {
        X(PropSyntax.ROTATION_X.id){

            @Override
            @Nonnull
            public Quat4f getRotate(float f) {
                return RotationMath.quatDeg(f * 360.0f / 8.0f, 1.0f, 0.0f, 0.0f);
            }
        }
        ,
        Y(PropSyntax.ROTATION_Y.id){

            @Override
            @Nonnull
            public Quat4f getRotate(float f) {
                return RotationMath.quatDeg(f * 360.0f / 8.0f, 0.0f, 1.0f, 0.0f);
            }
        }
        ,
        Z(PropSyntax.ROTATION_Z.id){

            @Override
            @Nonnull
            public Quat4f getRotate(float f) {
                return RotationMath.quatDeg(f * 360.0f / 8.0f, 0.0f, 0.0f, 1.0f);
            }
        };

        @Nonnull
        public final String id;

        private RotateType(String id) {
            this.id = id;
        }

        @Nonnull
        public abstract Quat4f getRotate(float var1);
    }

    public static class Rotate {
        @Nonnull
        public RotateType type;
        public float rotate;

        public Rotate(@Nonnull RotateType type, float rotate) {
            this.type = type;
            this.rotate = rotate;
        }

        @Nonnull
        public Quat4f getRotate(float scale) {
            return this.type.getRotate(this.rotate * scale);
        }

        @Nonnull
        public Quat4f getRotate() {
            return this.getRotate(1.0f);
        }

        @Nonnull
        public String compose() {
            float rotate = this.rotate;
            if (rotate == 0.0f) {
                return "";
            }
            if (rotate == 4.0f) {
                return this.type.id;
            }
            return this.type.id + ShortestFloatFormatter.format(rotate);
        }

        @Nonnull
        public String toString() {
            return "Rotate [type=" + (Object)((Object)this.type) + ", rotate=" + this.rotate + "]";
        }
    }

    public static class DiffRotation
    extends KeyRotation {
        @Nonnull
        private final KeyRotation base;
        @Nonnull
        private final AxisAngle4f diffangleaxis;
        @Nonnull
        private final ImmutableList<Rotate> diffglobalaxis;

        public DiffRotation(@Nonnull KeyRotation base, @Nonnull AxisAngle4f diffangleaxis, @Nonnull ImmutableList<Rotate> diffglobalaxis) {
            this.base = base;
            this.diffangleaxis = diffangleaxis;
            this.diffglobalaxis = diffglobalaxis;
        }

        @Override
        @Nonnull
        public Quat4f getRotate(float scale) {
            Quat4f quat = new Quat4f(this.base.getRotate(1.0f));
            quat.mul(this.getDiffAngleQuat(scale));
            quat.mul(this.getDiffGlobalQuat(scale));
            return quat;
        }

        @Nonnull
        private Quat4f getDiffGlobalQuat(float scale) {
            Quat4f quat = RotationMath.newQuat();
            UnmodifiableListIterator it = this.diffglobalaxis.listIterator(this.diffglobalaxis.size());
            while (it.hasPrevious()) {
                quat.mul(((Rotate)it.previous()).getRotate(scale));
            }
            return quat;
        }

        @Nonnull
        private Quat4f getDiffAngleQuat(float scale) {
            return RotationMath.toQuat(new AxisAngle4f(this.diffangleaxis.x, this.diffangleaxis.y, this.diffangleaxis.z, this.diffangleaxis.angle * scale));
        }

        @Override
        @Nonnull
        public RotationData per(float per, @Nullable RotationData before) {
            return new PerRotation(this.getRotate(per));
        }

        @Override
        @Nonnull
        public String compose() {
            StringBuilder stb = new StringBuilder(this.base.compose());
            if (this.diffangleaxis.angle != 0.0f) {
                stb.append(PropSyntax.ROTATION_ANGLE.id).append(ShortestFloatFormatter.format(RotationMath.toDegrees(this.diffangleaxis.angle) * 8.0f / 360.0f));
            }
            if (this.diffangleaxis.x != 0.0f) {
                if (this.diffangleaxis.x == 1.0f) {
                    stb.append(PropSyntax.ROTATION_AXIS_X.id);
                } else {
                    stb.append(PropSyntax.ROTATION_AXIS_X.id).append(ShortestFloatFormatter.format(this.diffangleaxis.x));
                }
            }
            if (this.diffangleaxis.y != 0.0f) {
                if (this.diffangleaxis.y == 1.0f) {
                    stb.append(PropSyntax.ROTATION_AXIS_Y.id);
                } else {
                    stb.append(PropSyntax.ROTATION_AXIS_Y.id).append(ShortestFloatFormatter.format(this.diffangleaxis.y));
                }
            }
            if (this.diffangleaxis.z != 0.0f) {
                if (this.diffangleaxis.z == 1.0f) {
                    stb.append(PropSyntax.ROTATION_AXIS_Z.id);
                } else {
                    stb.append(PropSyntax.ROTATION_AXIS_Z.id).append(ShortestFloatFormatter.format(this.diffangleaxis.z));
                }
            }
            for (Rotate rotate : this.diffglobalaxis) {
                stb.append(rotate.compose());
            }
            return stb.toString();
        }

        @Nonnull
        public String toString() {
            return "DiffRotation [base=" + this.base + ", diffAxisAngle=" + this.diffangleaxis + ", diffGlobal=" + this.diffglobalaxis + "]";
        }
    }

    public static final class BaseRotation
    extends KeyRotation {
        @Nonnull
        protected final Quat4f diff = RotationMath.newQuat();

        private BaseRotation() {
        }

        @Override
        @Nonnull
        public final Quat4f getRotate(float scale) {
            return this.diff;
        }

        @Override
        @Nonnull
        public final String compose() {
            return "";
        }

        @Override
        @Nonnull
        public final RotationData per(float per, @Nullable RotationData before) {
            return this;
        }

        @Nonnull
        public final String toString() {
            return "BaseRotationData []";
        }
    }

    public static abstract class KeyRotation
    extends RotationData
    implements IPropInterpolatable<RotationData>,
    IPropComposable {
        @Override
        @Nonnull
        public RotationData per() {
            return this;
        }
    }

    public static class PerRotation
    extends RotationData {
        @Nonnull
        private final Quat4f rotate;

        public PerRotation(@Nonnull Quat4f rotate) {
            this.rotate = rotate;
        }

        @Override
        @Nonnull
        public Quat4f getRotate(float scale) {
            return this.rotate;
        }

        @Nonnull
        public String toString() {
            return "PerDiffRotation [rotate=" + this.rotate + "]";
        }
    }
}

