/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.attr.prop;

import com.kamesuta.mc.bnnwidget.ShortestFloatFormatter;
import com.kamesuta.mc.bnnwidget.position.Area;
import com.kamesuta.mc.signpic.attr.IPropBuilder;
import com.kamesuta.mc.signpic.attr.IPropComposable;
import com.kamesuta.mc.signpic.attr.IPropInterpolatable;
import com.kamesuta.mc.signpic.attr.prop.PropSyntax;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class SizeData
implements IPropInterpolatable<SizeData>,
IPropComposable {
    public static final float Default = 1.0f;
    public static final float Unknown = Float.NaN;
    @Nonnull
    public static final SizeData DefaultSize = new AbsSizeData(1.0f, 1.0f);
    @Nonnull
    public static final SizeData UnknownSize = new AbsSizeData(Float.NaN, Float.NaN);

    public abstract float getWidth();

    public abstract float getHeight();

    public abstract boolean vaildWidth();

    public abstract boolean vaildHeight();

    public float max() {
        return Math.max(this.getWidth(), this.getHeight());
    }

    public float min() {
        return Math.min(this.getWidth(), this.getHeight());
    }

    @Nonnull
    public SizeData scale(float scale) {
        return new AbsSizeData(this.getWidth() * scale, this.getHeight() * scale);
    }

    @Override
    @Nonnull
    public SizeData per() {
        return this;
    }

    @Override
    @Nonnull
    public SizeData per(float per, @Nullable SizeData before) {
        if (before != null) {
            return new PerSizeData(this, before, per);
        }
        return this;
    }

    @Override
    @Nonnull
    public String compose() {
        return (this.vaildWidth() ? PropSyntax.SIZE_W.id + ShortestFloatFormatter.format(this.getWidth()) : "") + (this.vaildHeight() ? PropSyntax.SIZE_H.id + ShortestFloatFormatter.format(this.getHeight()) : "");
    }

    @Nonnull
    public abstract SizeData aspectSize(@Nullable SizeData var1);

    @Nonnull
    public static SizeData create(float width, float height) {
        return new AbsSizeData(width, height);
    }

    @Nonnull
    public static SizeData create(@Nullable SizeData base, @Nonnull SizeData diff) {
        if (base == null) {
            return diff;
        }
        return new DiffSizeData(base, diff);
    }

    @Nonnull
    public static SizeData create(@Nonnull Area area) {
        return SizeData.create(area.w(), area.h());
    }

    public static class SizeBuilder
    implements IPropBuilder<SizeData, SizeData>,
    Cloneable {
        public float width = Float.NaN;
        public float height = Float.NaN;

        @Override
        @Nonnull
        public SizeData diff(@Nullable SizeData base) {
            return SizeData.create(base, SizeData.create(this.width, this.height));
        }

        @Nonnull
        public SizeBuilder setSize(float width, float height) {
            this.width = width;
            this.height = height;
            return this;
        }

        @Nonnull
        public SizeBuilder setWidth(float width) {
            this.width = width;
            return this;
        }

        @Nonnull
        public SizeBuilder setHeight(float height) {
            this.height = height;
            return this;
        }

        @Nonnull
        public SizeBuilder setWidth(@Nullable String width) {
            this.width = NumberUtils.toFloat((String)width, (float)Float.NaN);
            return this;
        }

        @Nonnull
        public SizeBuilder setHeight(@Nullable String height) {
            this.height = NumberUtils.toFloat((String)height, (float)Float.NaN);
            return this;
        }

        @Nonnull
        public SizeBuilder setSize(@Nullable String width, @Nullable String height) {
            return this.setWidth(width).setHeight(height);
        }

        @Nonnull
        public SizeBuilder setSize(@Nonnull Area a) {
            return this.setSize(a.w(), a.h());
        }

        @Nonnull
        public SizeBuilder setSize(@Nonnull SizeData size) {
            return this.setSize(size.getWidth(), size.getHeight());
        }

        @Nonnull
        public SizeBuilder setSize(@Nonnull SizeBuilder size) {
            return this.setSize(size.width, size.height);
        }

        @Override
        public boolean parse(@Nonnull String src, @Nonnull String key, @Nonnull String value) {
            if (StringUtils.equals((CharSequence)key, (CharSequence)PropSyntax.SIZE_W.id)) {
                this.width = NumberUtils.toFloat((String)value, (float)Float.NaN);
            } else if (StringUtils.equals((CharSequence)key, (CharSequence)PropSyntax.SIZE_H.id)) {
                this.height = NumberUtils.toFloat((String)value, (float)Float.NaN);
            } else {
                return false;
            }
            return true;
        }

        @Override
        @Nonnull
        public String compose() {
            return this.diff(null).compose();
        }

        public String toString() {
            return String.format("SizeBuilder [width=%s, height=%s]", Float.valueOf(this.width), Float.valueOf(this.height));
        }

        @Nonnull
        public SizeBuilder clone() {
            try {
                return (SizeBuilder)super.clone();
            }
            catch (Exception e) {
                return new SizeBuilder().setSize(this);
            }
        }
    }

    public static enum ImageSizes {
        RAW{

            @Override
            @Nonnull
            public SizeData size(float w, float h, float maxw, float maxh) {
                return new AbsSizeData(w, h);
            }
        }
        ,
        MAX{

            @Override
            @Nonnull
            public SizeData size(float w, float h, float maxw, float maxh) {
                return new AbsSizeData(maxw, maxh);
            }
        }
        ,
        WIDTH{

            @Override
            @Nonnull
            public SizeData size(float w, float h, float maxw, float maxh) {
                return new AbsSizeData(maxw, h * maxw / w);
            }
        }
        ,
        HEIGHT{

            @Override
            @Nonnull
            public SizeData size(float w, float h, float maxw, float maxh) {
                return new AbsSizeData(w * maxh / h, maxh);
            }
        }
        ,
        INNER{

            @Override
            @Nonnull
            public SizeData size(float w, float h, float maxw, float maxh) {
                if (w < 0.0f) {
                    maxw *= -1.0f;
                }
                if (h < 0.0f) {
                    maxh *= -1.0f;
                }
                boolean b = w / maxw > h / maxh;
                return new AbsSizeData(b ? maxw : w * maxh / h, b ? h * maxw / w : maxh);
            }
        }
        ,
        OUTER{

            @Override
            @Nonnull
            public SizeData size(float w, float h, float maxw, float maxh) {
                if (w < 0.0f) {
                    maxw *= -1.0f;
                }
                if (h < 0.0f) {
                    maxh *= -1.0f;
                }
                boolean b = w / maxw < h / maxh;
                return new AbsSizeData(b ? maxw : w * maxh / h, b ? h * maxw / w : maxh);
            }
        }
        ,
        WIDTH_LIMIT{

            @Override
            @Nonnull
            public SizeData size(float w, float h, float maxw, float maxh) {
                if (w < maxw) {
                    return new AbsSizeData(w, h);
                }
                return new AbsSizeData(maxw, maxw * h / w);
            }
        }
        ,
        HEIGHT_LIMIT{

            @Override
            @Nonnull
            public SizeData size(float w, float h, float maxw, float maxh) {
                if (h < maxh) {
                    return new AbsSizeData(w, h);
                }
                return new AbsSizeData(maxh * w / h, maxh);
            }
        }
        ,
        LIMIT{

            @Override
            @Nonnull
            public SizeData size(float w, float h, float maxw, float maxh) {
                if (w > h) {
                    if (w < maxw) {
                        return new AbsSizeData(w, h);
                    }
                    return new AbsSizeData(maxw, maxw * h / w);
                }
                if (h < maxh) {
                    return new AbsSizeData(w, h);
                }
                return new AbsSizeData(maxh * w / h, maxh);
            }
        };


        @Nonnull
        public abstract SizeData size(float var1, float var2, float var3, float var4);

        @Nonnull
        public SizeData defineSize(float rawWidth, float rawHeight, float maxWidth, float maxHeight) {
            if (Float.isNaN(rawWidth) && Float.isNaN(maxWidth) || Float.isNaN(rawHeight) && Float.isNaN(maxHeight)) {
                throw new IllegalArgumentException("No Size Defined");
            }
            if (Float.isNaN(rawWidth)) {
                rawWidth = maxWidth;
            }
            if (Float.isNaN(rawHeight)) {
                rawHeight = maxHeight;
            }
            if (Float.isNaN(maxWidth)) {
                maxWidth = rawWidth;
            }
            if (Float.isNaN(maxHeight)) {
                maxHeight = rawHeight;
            }
            return this.size(rawWidth, rawHeight, maxWidth, maxHeight);
        }

        @Nonnull
        public SizeData defineSize(@Nullable SizeData raw, float maxWidth, float maxHeight) {
            if (raw == null) {
                return new AbsSizeData(maxWidth, maxHeight);
            }
            return this.defineSize(raw.getWidth(), raw.getHeight(), maxWidth, maxHeight);
        }

        @Nonnull
        public SizeData defineSize(float rawWidth, float rawHeight, @Nullable SizeData max) {
            if (max != null) {
                return this.defineSize(rawWidth, rawHeight, max.getWidth(), max.getHeight());
            }
            return new AbsSizeData(rawWidth, rawHeight);
        }

        @Nonnull
        public SizeData defineSize(@Nullable SizeData raw, @Nullable SizeData max) {
            if (raw != null && max != null) {
                return this.defineSize(raw.getWidth(), raw.getHeight(), max.getWidth(), max.getHeight());
            }
            if (raw == null && max != null) {
                return max;
            }
            if (max == null && raw != null) {
                return raw;
            }
            throw new IllegalArgumentException("No Size Defined");
        }
    }

    public static class DiffSizeData
    extends SizeData {
        @Nonnull
        private final SizeData base;
        @Nonnull
        private final SizeData diff;

        public DiffSizeData(@Nonnull SizeData base, @Nonnull SizeData diff) {
            this.base = base;
            this.diff = diff;
        }

        @Override
        public float getWidth() {
            return this.base.getWidth() + this.diff.getWidth();
        }

        @Override
        public float getHeight() {
            return this.base.getHeight() + this.diff.getHeight();
        }

        @Override
        public boolean vaildWidth() {
            return this.base.vaildWidth();
        }

        @Override
        public boolean vaildHeight() {
            return this.base.vaildHeight();
        }

        @Override
        @Nonnull
        public SizeData aspectSize(@Nullable SizeData availableaspect) {
            return this.diff.aspectSize(this.base.aspectSize(availableaspect));
        }

        @Nonnull
        public String toString() {
            return "PerSizeData [base=" + this.base + ", diff=" + this.diff + ", (width=" + this.getWidth() + ", height=" + this.getHeight() + ")]";
        }
    }

    public static class PerSizeData
    extends SizeData {
        @Nonnull
        private final SizeData after;
        @Nonnull
        private final SizeData before;
        private final float per;

        public PerSizeData(@Nonnull SizeData after, @Nonnull SizeData before, float per) {
            this.after = after;
            this.before = before;
            this.per = per;
        }

        @Override
        public float getWidth() {
            return this.after.getWidth() * this.per + this.before.getWidth() * (1.0f - this.per);
        }

        @Override
        public float getHeight() {
            return this.after.getHeight() * this.per + this.before.getHeight() * (1.0f - this.per);
        }

        @Override
        public boolean vaildWidth() {
            return !(!this.after.vaildWidth() && !this.before.vaildWidth() || !this.after.vaildHeight() && !this.before.vaildHeight());
        }

        @Override
        public boolean vaildHeight() {
            return !(!this.after.vaildWidth() && !this.before.vaildWidth() || !this.after.vaildHeight() && !this.before.vaildHeight());
        }

        @Override
        @Nonnull
        public SizeData aspectSize(@Nullable SizeData availableaspect) {
            return new PerSizeData(this.after.aspectSize(availableaspect), this.before.aspectSize(availableaspect), this.per);
        }

        @Nonnull
        public String toString() {
            return "PerSizeData [after=" + this.after + ", before=" + this.before + ", per=" + this.per + ", (width=" + this.getWidth() + ", height=" + this.getHeight() + ")]";
        }
    }

    public static class AbsSizeData
    extends SizeData {
        private final float width;
        private final float height;

        public AbsSizeData(float width, float height) {
            this.width = width;
            this.height = height;
        }

        @Override
        public float getWidth() {
            return this.width;
        }

        @Override
        public float getHeight() {
            return this.height;
        }

        @Override
        public boolean vaildWidth() {
            return !Float.isNaN(this.getWidth());
        }

        @Override
        public boolean vaildHeight() {
            return !Float.isNaN(this.getHeight());
        }

        @Override
        @Nonnull
        public SizeData aspectSize(@Nullable SizeData availableaspect) {
            if (availableaspect == null) {
                return this;
            }
            if (this.vaildWidth() && this.vaildHeight()) {
                return this;
            }
            if (this.vaildWidth()) {
                return ImageSizes.WIDTH.defineSize(availableaspect, this.getWidth(), Float.NaN);
            }
            if (this.vaildHeight()) {
                return ImageSizes.HEIGHT.defineSize(availableaspect, Float.NaN, this.getHeight());
            }
            return ImageSizes.HEIGHT.defineSize(availableaspect, Float.NaN, 1.0f);
        }

        public String toString() {
            return String.format("AbsSizeData [width=%s, height=%s]", Float.valueOf(this.getWidth()), Float.valueOf(this.getHeight()));
        }
    }
}

