/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.attr.prop;

import com.kamesuta.mc.bnnwidget.ShortestFloatFormatter;
import com.kamesuta.mc.bnnwidget.render.WRenderer;
import com.kamesuta.mc.signpic.attr.IPropBuilder;
import com.kamesuta.mc.signpic.attr.IPropInterpolatable;
import com.kamesuta.mc.signpic.attr.prop.PropSyntax;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;

public interface TextureData {

    public static class TextureBlend
    implements IPropInterpolatable<TextureBlend> {
        @Nullable
        public static final WRenderer.BlendType defaultBlend = null;
        @Nonnull
        public final TextureBlendType type;
        @Nullable
        public final WRenderer.BlendType data;

        public TextureBlend(@Nonnull TextureBlendType type, @Nullable WRenderer.BlendType data) {
            this.type = type;
            this.data = data;
        }

        @Override
        @Nonnull
        public TextureBlend per() {
            return this;
        }

        @Override
        @Nonnull
        public TextureBlend per(float per, @Nullable TextureBlend before) {
            return this;
        }

        public String toString() {
            return String.format("TextureBlend [type=%s, data=%s]", new Object[]{this.type, this.data});
        }

        public static class TextureBlendBuilder
        implements IPropBuilder<TextureBlend, TextureBlend> {
            @Nonnull
            private final TextureBlendType type;
            @Nullable
            private WRenderer.BlendType data;

            public TextureBlendBuilder(@Nonnull TextureBlendType type) {
                this.type = type;
                this.data = type.defaultValue;
            }

            @Override
            @Nonnull
            public TextureBlend diff(@Nullable TextureBlend base) {
                return new TextureBlend(this.type, this.data);
            }

            @Override
            public boolean parse(@Nonnull String src, @Nonnull String key, @Nonnull String value) {
                if (StringUtils.equals((CharSequence)key, (CharSequence)this.type.identifier)) {
                    if (NumberUtils.isCreatable((String)value)) {
                        this.data = WRenderer.BlendType.fromId(NumberUtils.toInt((String)value));
                    }
                    return true;
                }
                return false;
            }

            @Override
            @Nonnull
            public String compose() {
                WRenderer.BlendType data = this.data;
                if (data != null && data != this.type.defaultValue) {
                    return this.type.identifier + data.id;
                }
                return "";
            }

            public String toString() {
                return String.format("TextureBlendBuilder [type=%s, data=%s]", new Object[]{this.type, this.data});
            }
        }

        public static enum TextureBlendType {
            B(PropSyntax.TEXTURE_BLEND_SRC.id, defaultBlend),
            D(PropSyntax.TEXTURE_BLEND_DST.id, defaultBlend);

            @Nonnull
            public final String identifier;
            @Nullable
            public final WRenderer.BlendType defaultValue;

            private TextureBlendType(String identifier, WRenderer.BlendType defaultValue) {
                this.identifier = identifier;
                this.defaultValue = defaultValue;
            }
        }
    }

    public static class TextureBoolean
    implements IPropInterpolatable<TextureBoolean> {
        public static final boolean defaultRepeat = true;
        public static final boolean defaultMipMap = true;
        public static final boolean defaultLighting = false;
        @Nonnull
        public final TextureBooleanType type;
        public final boolean data;

        public TextureBoolean(@Nonnull TextureBooleanType type, boolean data) {
            this.type = type;
            this.data = data;
        }

        @Override
        @Nonnull
        public TextureBoolean per() {
            return this;
        }

        @Override
        @Nonnull
        public TextureBoolean per(float per, @Nullable TextureBoolean before) {
            return this;
        }

        public String toString() {
            return String.format("TextureBoolean [type=%s, data=%s]", new Object[]{this.type, this.data});
        }

        public static class TextureBooleanBuilder
        implements IPropBuilder<TextureBoolean, TextureBoolean> {
            @Nonnull
            private final TextureBooleanType type;
            private boolean data;

            public TextureBooleanBuilder(@Nonnull TextureBooleanType type) {
                this.type = type;
                this.data = type.defaultValue;
            }

            @Override
            @Nonnull
            public TextureBoolean diff(@Nullable TextureBoolean base) {
                return new TextureBoolean(this.type, this.data);
            }

            @Override
            public boolean parse(@Nonnull String src, @Nonnull String key, @Nonnull String value) {
                if (StringUtils.equals((CharSequence)key, (CharSequence)this.type.identifier)) {
                    this.data = !this.type.defaultValue;
                    return true;
                }
                return false;
            }

            @Override
            @Nonnull
            public String compose() {
                if (this.data != this.type.defaultValue) {
                    return this.type.identifier;
                }
                return "";
            }

            public String toString() {
                return String.format("TextureBooleanBuilder [type=%s, data=%s]", new Object[]{this.type, this.data});
            }
        }

        public static enum TextureBooleanType {
            R(PropSyntax.TEXTURE_REPEAT.id, true),
            M(PropSyntax.TEXTURE_MIPMAP.id, true),
            L(PropSyntax.TEXTURE_LIGHTING.id, false);

            @Nonnull
            public final String identifier;
            public final boolean defaultValue;

            private TextureBooleanType(String identifier, boolean defaultValue) {
                this.identifier = identifier;
                this.defaultValue = defaultValue;
            }
        }
    }

    public static class TextureFloat
    implements IPropInterpolatable<TextureFloat> {
        public static final float defaultUV = 0.0f;
        public static final float defaultWH = 1.0f;
        public static final float defaultCS = 1.0f;
        public static final float defaultOpacity = 10.0f;
        public static final float defaultLight = -1.0f;
        public static final float failedLight = -3.0f;
        @Nonnull
        public final TextureFloatType type;
        public final float data;

        public TextureFloat(@Nonnull TextureFloatType type, float data) {
            this.type = type;
            this.data = data;
        }

        @Override
        @Nonnull
        public TextureFloat per() {
            return this;
        }

        @Override
        @Nonnull
        public TextureFloat per(float per, @Nullable TextureFloat before) {
            if (before == null) {
                return this;
            }
            return new TextureFloat(this.type, this.data * per + before.data * (1.0f - per));
        }

        public String toString() {
            return String.format("TextureFloat [type=%s, data=%s]", new Object[]{this.type, Float.valueOf(this.data)});
        }

        public static class TextureFloatBuilder
        implements IPropBuilder<TextureFloat, TextureFloat> {
            @Nonnull
            private final TextureFloatType type;
            private float data;

            public TextureFloatBuilder(@Nonnull TextureFloatType type) {
                Validate.notNull((Object)((Object)type));
                this.type = type;
                this.data = type.defaultValue;
            }

            @Override
            @Nonnull
            public TextureFloat diff(@Nullable TextureFloat base) {
                if (base == null || this.type.overwrite) {
                    return new TextureFloat(this.type, this.data);
                }
                return new TextureFloat(this.type, base.data + this.data);
            }

            @Override
            public boolean parse(@Nonnull String src, @Nonnull String key, @Nonnull String value) {
                if (StringUtils.equals((CharSequence)key, (CharSequence)this.type.identifier)) {
                    this.data = NumberUtils.toFloat((String)value, (float)this.type.failedValue);
                    return true;
                }
                return false;
            }

            @Override
            @Nonnull
            public String compose() {
                if (this.data == this.type.defaultValue) {
                    return "";
                }
                if (this.data == this.type.failedValue) {
                    return this.type.identifier;
                }
                return this.type.identifier + ShortestFloatFormatter.format(this.data);
            }

            public String toString() {
                return String.format("TextureFloatBuilder [type=%s, data=%s]", new Object[]{this.type, Float.valueOf(this.data)});
            }
        }

        public static enum TextureFloatType {
            U(PropSyntax.TEXTURE_X.id, 0.0f, false),
            V(PropSyntax.TEXTURE_Y.id, 0.0f, false),
            W(PropSyntax.TEXTURE_W.id, 1.0f, false),
            H(PropSyntax.TEXTURE_H.id, 1.0f, false),
            C(PropSyntax.TEXTURE_SPLIT_W.id, 1.0f, false),
            S(PropSyntax.TEXTURE_SPLIT_H.id, 1.0f, false),
            O(PropSyntax.TEXTURE_OPACITY.id, 10.0f, false),
            F(PropSyntax.TEXTURE_LIGHT_X.id, -1.0f, -3.0f, true),
            G(PropSyntax.TEXTURE_LIGHT_Y.id, -1.0f, -3.0f, true);

            @Nonnull
            public final String identifier;
            public final float defaultValue;
            public final float failedValue;
            public final boolean overwrite;

            private TextureFloatType(String identifier, float defaultValue, float failedValue, boolean overwrite) {
                this.identifier = identifier;
                this.defaultValue = defaultValue;
                this.failedValue = failedValue;
                this.overwrite = overwrite;
            }

            private TextureFloatType(String identifier, float defaultAndFailedValue, boolean overwrite) {
                this(identifier, defaultAndFailedValue, defaultAndFailedValue, overwrite);
            }
        }
    }
}

