/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.command;

import com.google.common.collect.Lists;
import com.kamesuta.mc.signpic.command.IModCommand;
import com.kamesuta.mc.signpic.command.SubCommand;
import com.kamesuta.mc.signpic.util.ChatBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.apache.commons.lang3.StringUtils;

public class CommandHelpers {
    public static void throwWrongUsage(@Nonnull ICommandSender sender, @Nonnull IModCommand command) throws WrongUsageException {
        throw new WrongUsageException(I18n.func_135052_a((String)"signpic.command.help", (Object[])new Object[]{command.func_71518_a(sender)}), new Object[0]);
    }

    public static void processChildCommand(@Nonnull ICommandSender sender, @Nonnull SubCommand child, @Nonnull String[] args) throws CommandException {
        if (!sender.func_70003_b(child.getRequiredPermissionLevel(), child.getFullCommandString())) {
            throw new WrongUsageException(I18n.func_135052_a((String)"signpic.command.noperms", (Object[])new Object[0]), new Object[0]);
        }
        child.func_184881_a(FMLClientHandler.instance().getServer(), sender, Arrays.copyOfRange(args, 1, args.length));
    }

    @Nullable
    public static List<String> completeChildCommand(@Nonnull ICommandSender sender, @Nonnull SubCommand child, @Nonnull String[] args) {
        return child.completeCommand(sender, Arrays.copyOfRange(args, 1, args.length));
    }

    public static void printHelp(@Nonnull ICommandSender sender, @Nonnull IModCommand command) {
        Style header = new Style();
        header.func_150238_a(TextFormatting.BLUE);
        ChatBuilder.create("signpic.command." + command.getFullCommandString().replace(" ", ".") + ".format").useTranslation().setStyle(header).setParams(command.getFullCommandString()).sendPlayer(sender);
        Style body = new Style();
        body.func_150238_a(TextFormatting.GRAY);
        List<String> aliases = command.func_71514_a();
        if (aliases != null) {
            ChatBuilder.create("signpic.command.aliases").useTranslation().setStyle(body).setParams(aliases.toString().replace("[", "").replace("]", "")).sendPlayer(sender);
        }
        ChatBuilder.create("signpic.command.permlevel").useTranslation().setStyle(body).setParams(command.getRequiredPermissionLevel()).sendPlayer(sender);
        ChatBuilder.create("signpic.command." + command.getFullCommandString().replace(" ", ".") + ".help").useTranslation().setStyle(body).sendPlayer(sender);
        if (!command.getChildren().isEmpty()) {
            ChatBuilder.create("signpic.command.list").useTranslation().sendPlayer(sender);
            for (SubCommand child : command.getChildren()) {
                ChatBuilder.create("signpic.command." + child.getFullCommandString().replace(" ", ".") + ".desc").useTranslation().setParams(child.func_71517_b()).sendPlayer(sender);
            }
        }
    }

    @Nullable
    public static List<String> completeCommands(@Nonnull ICommandSender sender, @Nonnull IModCommand command, @Nonnull String[] args) {
        if (args.length >= 2) {
            for (SubCommand child : command.getChildren()) {
                if (!StringUtils.equals((CharSequence)args[0], (CharSequence)child.func_71517_b())) continue;
                return CommandHelpers.completeChildCommand(sender, child, args);
            }
            return null;
        }
        ArrayList complete = Lists.newArrayList();
        if (!StringUtils.equals((CharSequence)"help", (CharSequence)command.func_71517_b())) {
            complete.add("help");
        }
        for (SubCommand child : command.getChildren()) {
            complete.add(child.func_71517_b());
        }
        return complete;
    }

    public static boolean processCommands(@Nonnull ICommandSender sender, @Nonnull IModCommand command, @Nonnull String[] args) throws CommandException {
        if (args.length >= 1) {
            if (args[0].equals("help")) {
                command.printHelp(sender);
                return true;
            }
            for (SubCommand child : command.getChildren()) {
                String arg = args[0];
                if (arg == null || child == null || !CommandHelpers.matches(arg, child)) continue;
                CommandHelpers.processChildCommand(sender, child, args);
                return true;
            }
        }
        return false;
    }

    public static boolean matches(@Nonnull String commandName, @Nonnull IModCommand command) {
        if (commandName.equals(command.func_71517_b())) {
            return true;
        }
        List<String> aliases = command.func_71514_a();
        if (aliases != null) {
            for (String alias : aliases) {
                if (!commandName.equals(alias)) continue;
                return true;
            }
        }
        return false;
    }
}

