/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.command;

import com.kamesuta.mc.signpic.Config;
import com.kamesuta.mc.signpic.Log;
import com.kamesuta.mc.signpic.command.SubCommand;
import com.kamesuta.mc.signpic.information.Informations;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;

public class CommandVersion
extends SubCommand {
    @Nonnull
    private final SubCommand cmdcheck = new CommandVersionCheck();
    @Nonnull
    private final SubCommand cmdupdate;

    public CommandVersion() {
        super("version");
        this.addChildCommand(this.cmdcheck);
        this.cmdupdate = new CommandVersionUpdate();
        this.addChildCommand(this.cmdupdate);
        this.addChildCommand(new CommandEnableJoinBeta());
        this.setPermLevel(SubCommand.PermLevel.EVERYONE);
    }

    private static class CommandVersionUpdate
    extends SubCommand {
        private CommandVersionUpdate() {
            super("update");
            this.setPermLevel(SubCommand.PermLevel.EVERYONE);
        }

        @Override
        public void processSubCommand(@Nonnull ICommandSender sender, @Nonnull String[] args) {
            long cooldown = TimeUnit.HOURS.toMillis(2L);
            if (Informations.instance.shouldCheck(cooldown)) {
                Informations.instance.onlineCheck(new Runnable(){

                    @Override
                    public void run() {
                        if (Informations.instance.isUpdateRequired()) {
                            Informations.instance.runUpdate();
                        } else {
                            Log.notice(I18n.func_135052_a((String)"signpic.versioning.noupdate", (Object[])new Object[0]));
                        }
                    }
                });
            } else if (Informations.instance.isUpdateRequired()) {
                Informations.instance.runUpdate();
            } else {
                Log.notice(I18n.func_135052_a((String)"signpic.versioning.noupdate", (Object[])new Object[0]));
            }
        }
    }

    private static class CommandVersionCheck
    extends SubCommand {
        private CommandVersionCheck() {
            super("check");
            this.setPermLevel(SubCommand.PermLevel.EVERYONE);
        }

        @Override
        public void processSubCommand(@Nonnull ICommandSender sender, @Nonnull String[] args) {
            long cooldown = TimeUnit.HOURS.toMillis(2L);
            if (Informations.instance.shouldCheck(cooldown)) {
                Log.notice(I18n.func_135052_a((String)"signpic.versioning.check.start", (Object[])new Object[0]));
                Informations.instance.onlineCheck(new Runnable(){

                    @Override
                    public void run() {
                        Informations.instance.check();
                    }
                });
            } else {
                Informations.instance.check();
            }
        }
    }

    private class CommandEnableJoinBeta
    extends SubCommand {
        private CommandEnableJoinBeta() {
            super("beta");
            this.addChildCommand(CommandVersion.this.cmdcheck);
            this.addChildCommand(CommandVersion.this.cmdupdate);
            this.setPermLevel(SubCommand.PermLevel.EVERYONE);
        }

        @Override
        public void func_184881_a(@Nullable MinecraftServer server, @Nullable ICommandSender sender, @Nullable String[] args) throws CommandException {
            Config.getConfig().informationJoinBeta.set(false);
            if (server != null && sender != null && args != null) {
                super.func_184881_a(server, sender, args);
            }
        }
    }
}

