/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kamesuta.mc.signpic.command.CommandHelpers;
import com.kamesuta.mc.signpic.command.IModCommand;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public abstract class SubCommand
implements IModCommand {
    @Nonnull
    private final String name;
    @Nonnull
    private final List<String> aliases = Lists.newArrayList();
    @Nonnull
    private PermLevel permLevel = PermLevel.EVERYONE;
    @Nullable
    private IModCommand parent;
    @Nonnull
    private final SortedSet<SubCommand> children = Sets.newTreeSet((Comparator)new Comparator<SubCommand>(){

        @Override
        public int compare(@Nullable SubCommand o1, @Nullable SubCommand o2) {
            if (o1 != null && o2 != null) {
                return o1.compareTo(o2);
            }
            return 0;
        }
    });

    public SubCommand(@Nonnull String name) {
        this.name = name;
    }

    @Nonnull
    public String func_71517_b() {
        return this.name;
    }

    @Nonnull
    public SubCommand addChildCommand(@Nonnull SubCommand child) {
        child.setParent(this);
        this.children.add(child);
        return this;
    }

    void setParent(@Nullable IModCommand parent) {
        this.parent = parent;
    }

    @Override
    @Nonnull
    public SortedSet<SubCommand> getChildren() {
        return this.children;
    }

    public void addAlias(@Nonnull String alias) {
        this.aliases.add(alias);
    }

    @Override
    @Nonnull
    public List<String> func_71514_a() {
        return this.aliases;
    }

    @Nullable
    public List<String> func_184883_a(@Nullable MinecraftServer server, @Nullable ICommandSender sender, @Nullable String[] args, @Nullable BlockPos pos) {
        return null;
    }

    public void func_184881_a(@Nullable MinecraftServer server, @Nullable ICommandSender sender, @Nullable String[] args) throws CommandException {
        if (sender != null && args != null && !CommandHelpers.processCommands(sender, this, args)) {
            this.processSubCommand(sender, args);
        }
    }

    @Nullable
    public List<String> completeCommand(@Nonnull ICommandSender sender, @Nonnull String[] args) {
        return CommandHelpers.completeCommands(sender, this, args);
    }

    public void processSubCommand(@Nonnull ICommandSender sender, @Nonnull String[] args) throws WrongUsageException {
        CommandHelpers.throwWrongUsage(sender, this);
    }

    @Nonnull
    public SubCommand setPermLevel(@Nonnull PermLevel permLevel) {
        this.permLevel = permLevel;
        return this;
    }

    @Override
    public int getRequiredPermissionLevel() {
        return this.permLevel.permLevel;
    }

    public boolean func_184882_a(@Nullable MinecraftServer server, @Nullable ICommandSender sender) {
        if (sender != null) {
            return sender.func_70003_b(this.getRequiredPermissionLevel(), this.func_71517_b());
        }
        return false;
    }

    public boolean func_82358_a(@Nullable String[] args, int index) {
        return false;
    }

    @Nonnull
    public String func_71518_a(@Nullable ICommandSender sender) {
        return "/" + this.getFullCommandString() + " help";
    }

    @Override
    public void printHelp(@Nonnull ICommandSender sender) {
        CommandHelpers.printHelp(sender, this);
    }

    @Override
    @Nonnull
    public String getFullCommandString() {
        if (this.parent != null) {
            return this.parent.getFullCommandString() + " " + this.func_71517_b();
        }
        return " " + this.func_71517_b();
    }

    public int compareTo(@Nullable ICommand command) {
        if (command != null) {
            return this.func_71517_b().compareTo(command.func_71517_b());
        }
        return 0;
    }

    public static enum PermLevel {
        EVERYONE(0),
        ADMIN(2);

        int permLevel;

        private PermLevel(int permLevel) {
            this.permLevel = permLevel;
        }
    }
}

