/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.entry;

import com.kamesuta.mc.signpic.attr.AttrReaders;
import com.kamesuta.mc.signpic.attr.AttrWriters;
import com.kamesuta.mc.signpic.entry.EntryId;
import com.kamesuta.mc.signpic.entry.content.Content;
import com.kamesuta.mc.signpic.entry.content.ContentId;
import com.kamesuta.mc.signpic.gui.GuiImage;
import com.kamesuta.mc.signpic.mode.CurrentMode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class Entry {
    @Nonnull
    public final EntryId id;
    @Nullable
    public final ContentId contentId;
    @Nullable
    private GuiImage gui;
    private final boolean valid;
    private final boolean outdated;
    @Nullable
    private transient AttrReaders meta;
    @Nullable
    private String cmetacache;

    protected Entry(@Nonnull EntryId id) {
        this.id = id;
        this.valid = id.isValid();
        this.outdated = id.isOutdated();
        this.contentId = id.getContentId();
    }

    @Nonnull
    public GuiImage getGui() {
        if (this.gui != null) {
            return this.gui;
        }
        this.gui = new GuiImage(this);
        return this.gui;
    }

    @Nullable
    public Content getContent() {
        if (CurrentMode.instance.isState(CurrentMode.State.HIDE)) {
            return ContentId.hideContent.content();
        }
        if (this.contentId != null) {
            return this.contentId.content();
        }
        return null;
    }

    public boolean isNotSupported() {
        AttrReaders meta = this.getMeta();
        return meta.hasInvalidMeta() || this.id.getPrePrefix() != null;
    }

    public boolean isOutdated() {
        return this.outdated;
    }

    public boolean isValid() {
        return this.valid;
    }

    @Nonnull
    public AttrReaders getMeta() {
        String newmeta;
        Content cntnt = this.getContent();
        String string = newmeta = cntnt != null ? cntnt.imagemeta : null;
        if (this.contentId != null && newmeta != null && !StringUtils.equals((CharSequence)this.cmetacache, (CharSequence)newmeta)) {
            String meta1 = this.id.getMetaSource();
            if (meta1 != null) {
                this.meta = new AttrReaders(meta1 + newmeta);
            }
            this.cmetacache = newmeta;
        }
        if (this.meta == null) {
            this.meta = this.id.getMeta();
        }
        if (this.meta != null) {
            return this.meta;
        }
        this.meta = AttrReaders.Blank;
        return this.meta;
    }

    @Nullable
    public AttrWriters getMetaBuilder() {
        String newmeta;
        Content cntnt = this.getContent();
        String string = newmeta = cntnt != null ? cntnt.imagemeta : null;
        if (this.contentId != null && newmeta != null) {
            return new AttrWriters().parse(this.id.getMetaSource() + newmeta);
        }
        return this.id.getMetaBuilder();
    }
}

