/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.entry;

import com.kamesuta.mc.signpic.attr.AttrReaders;
import com.kamesuta.mc.signpic.attr.AttrWriters;
import com.kamesuta.mc.signpic.entry.Entry;
import com.kamesuta.mc.signpic.entry.EntryManager;
import com.kamesuta.mc.signpic.entry.content.ContentId;
import com.kamesuta.mc.signpic.mode.CurrentMode;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.commons.lang3.StringUtils;

public class EntryId {
    @Nonnull
    public static final EntryId blank = new EntryId("");
    @Nonnull
    private final String id;

    protected EntryId(@Nonnull String id) {
        this.id = id;
    }

    @Nonnull
    public String id() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntryId)) {
            return false;
        }
        EntryId other = (EntryId)obj;
        return this.id().equals(other.id());
    }

    @Nonnull
    public String toString() {
        return String.format("EntryId [id=%s]", this.id());
    }

    @Nonnull
    public static EntryId from(@Nullable String string) {
        if (string != null && !StringUtils.isEmpty((CharSequence)string)) {
            if (StringUtils.equals((CharSequence)string, (CharSequence)"{#}")) {
                return PreviewEntryId.instance;
            }
            return new EntryId(string);
        }
        return blank;
    }

    @Nonnull
    public static EntryId fromStrings(@Nullable String[] strings) {
        return EntryId.from(StringUtils.join((Object[])strings));
    }

    @Nonnull
    public static EntryId fromTile(@Nullable TileEntitySign tile) {
        if (tile == null) {
            return blank;
        }
        return EntryId.fromChats(tile.field_145915_a);
    }

    @Nonnull
    public static EntryId fromChats(@Nullable ITextComponent[] chats) {
        if (chats == null) {
            return blank;
        }
        StringBuilder stb = new StringBuilder();
        for (ITextComponent chat : chats) {
            if (chat == null) continue;
            stb.append(chat.func_150260_c());
        }
        return EntryId.from(stb.toString());
    }

    @Nonnull
    public static ItemEntryId fromItemStack(@Nullable ItemStack itemStack) {
        NBTTagCompound nbt;
        if (itemStack != null && (nbt = itemStack.func_77978_p()) != null) {
            if (nbt.func_150297_b("BlockEntityTag", 10)) {
                NBTTagCompound tag = (NBTTagCompound)nbt.func_74781_a("BlockEntityTag");
                TileEntitySign tile = new TileEntitySign();
                tile.func_145839_a(tag);
                String name = null;
                if (ItemEntryId.hasName(nbt)) {
                    name = itemStack.func_82833_r();
                }
                return new ItemEntryId(EntryId.fromTile(tile), name);
            }
            if (ItemEntryId.hasName(nbt)) {
                String name = itemStack.func_82833_r();
                int index = StringUtils.lastIndexOf((CharSequence)name, (CharSequence)"}");
                String itemname = StringUtils.substringAfterLast((String)name, (String)"}");
                if (StringUtils.isEmpty((CharSequence)itemname)) {
                    itemname = null;
                }
                return new ItemEntryId(EntryId.from(StringUtils.substring((String)itemStack.func_82833_r(), (int)0, (int)(index != -1 ? index + 1 : 0))), itemname);
            }
        }
        return ItemEntryId.blank;
    }

    private boolean hasContentId() {
        return !StringUtils.isEmpty((CharSequence)this.id()) && !StringUtils.containsOnly((CharSequence)this.id(), (String)"!") && !StringUtils.containsOnly((CharSequence)this.id(), (String)"$");
    }

    private boolean hasMeta() {
        if (StringUtils.endsWith((CharSequence)this.id(), (CharSequence)"]") && StringUtils.contains((CharSequence)this.id(), (CharSequence)"[")) {
            String idstr = StringUtils.substring((String)this.id(), (int)0, (int)StringUtils.lastIndexOf((CharSequence)this.id(), (CharSequence)"["));
            return StringUtils.contains((CharSequence)idstr, (CharSequence)".") && StringUtils.contains((CharSequence)idstr, (CharSequence)"/");
        }
        return this.hasPrefix() && StringUtils.endsWith((CharSequence)this.id(), (CharSequence)"}") && StringUtils.contains((CharSequence)this.id(), (CharSequence)"{");
    }

    public boolean isOutdated() {
        return StringUtils.endsWith((CharSequence)this.id(), (CharSequence)"]") && StringUtils.contains((CharSequence)this.id(), (CharSequence)"[");
    }

    private boolean hasPrefix() {
        int i = StringUtils.indexOf((CharSequence)this.id(), (CharSequence)"#");
        return 0 <= i && i < 2;
    }

    public boolean isValid() {
        return this.hasContentId() && this.hasMeta();
    }

    @Nullable
    public String getPrePrefix() {
        if (StringUtils.indexOf((CharSequence)this.id(), (CharSequence)"#") == 1) {
            return StringUtils.substring((String)this.id(), (int)0, (int)0);
        }
        return null;
    }

    @Nullable
    public ContentId getContentId() {
        if (this.hasContentId()) {
            String id = StringUtils.contains((CharSequence)this.id(), (CharSequence)"[") ? StringUtils.substring((String)this.id(), (int)0, (int)StringUtils.lastIndexOf((CharSequence)this.id(), (CharSequence)"[")) : (this.hasPrefix() && StringUtils.contains((CharSequence)this.id(), (CharSequence)"{") ? StringUtils.substring((String)this.id(), (int)(StringUtils.indexOf((CharSequence)this.id(), (CharSequence)"#") + 1), (int)StringUtils.lastIndexOf((CharSequence)this.id(), (CharSequence)"{")) : this.id());
            return ContentId.from(id);
        }
        return null;
    }

    @Nullable
    public String getMetaSource() {
        if (this.hasMeta()) {
            if (StringUtils.endsWith((CharSequence)this.id(), (CharSequence)"}")) {
                return StringUtils.substring((String)this.id(), (int)(StringUtils.lastIndexOf((CharSequence)this.id(), (CharSequence)"{") + 1), (int)(StringUtils.length((CharSequence)this.id()) - 1));
            }
            return StringUtils.substring((String)this.id(), (int)(StringUtils.lastIndexOf((CharSequence)this.id(), (CharSequence)"[") + 1), (int)(StringUtils.length((CharSequence)this.id()) - 1));
        }
        return null;
    }

    @Nullable
    public AttrReaders getMeta() {
        String metasource = this.getMetaSource();
        if (metasource != null) {
            return new AttrReaders(metasource);
        }
        return null;
    }

    @Nullable
    public AttrWriters getMetaBuilder() {
        String metasource = this.getMetaSource();
        if (metasource != null) {
            return new AttrWriters().parse(metasource);
        }
        return null;
    }

    public boolean isPlaceable() {
        return StringUtils.length((CharSequence)this.id()) <= 60;
    }

    public boolean isNameable() {
        return StringUtils.length((CharSequence)this.id()) <= 40;
    }

    public void toStrings(@Nullable String[] sign) {
        if (sign != null) {
            int length = StringUtils.length((CharSequence)this.id());
            for (int i = 0; i < 4; ++i) {
                sign[i] = StringUtils.substring((String)this.id(), (int)(15 * i), (int)Math.min(15 * (i + 1), length));
            }
        }
    }

    public void toChats(@Nullable ITextComponent[] sign) {
        if (sign != null) {
            int length = StringUtils.length((CharSequence)this.id);
            for (int i = 0; i < 4; ++i) {
                sign[i] = new TextComponentString(StringUtils.substring((String)this.id, (int)(15 * i), (int)Math.min(15 * (i + 1), length)));
            }
        }
    }

    public int getLastLine() {
        return StringUtils.length((CharSequence)this.id()) / 15;
    }

    public void toEntity(@Nullable TileEntitySign tile) {
        if (tile != null) {
            this.toChats(tile.field_145915_a);
        }
    }

    @Nonnull
    public Entry entry() {
        return EntryManager.instance.get(this);
    }

    public static class PreviewEntryId
    extends EntryId {
        @Nonnull
        public static final String previewid = "{#}";
        @Nonnull
        public static final PreviewEntryId instance = new PreviewEntryId();

        private PreviewEntryId() {
            super(previewid);
        }

        @Override
        @Nonnull
        public String id() {
            EntryId id = CurrentMode.instance.getEntryId();
            if (!(id instanceof PreviewEntryId)) {
                return id.id();
            }
            return "";
        }

        @Override
        public String toString() {
            return "PreviewEntryId";
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + previewid.hashCode();
            return result;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return this == obj;
        }
    }

    public static class SignEntryId
    extends EntryId {
        @Nonnull
        public static final ITextComponent blankChat = new TextComponentString("");
        @Nonnull
        public static final SignEntryId blank = new SignEntryId("", new String[]{"", "", "", ""}, new ITextComponent[]{blankChat, blankChat, blankChat, blankChat});
        @Nonnull
        public final String[] strings;
        @Nullable
        private ITextComponent[] chats;

        protected SignEntryId(@Nonnull String id, @Nonnull String[] strings) {
            super(id);
            this.strings = strings;
        }

        protected SignEntryId(@Nonnull String id, @Nonnull String[] strings, @Nonnull ITextComponent[] chats) {
            this(id, strings);
            this.chats = chats;
        }

        @Nonnull
        protected static SignEntryId fromSignStrings(@Nonnull String[] strings) {
            return new SignEntryId(StringUtils.join((Object[])strings), strings);
        }

        @Nonnull
        protected static SignEntryId fromSignChats(@Nonnull String[] strings, @Nonnull ITextComponent[] chats) {
            return new SignEntryId(StringUtils.join((Object[])strings), strings, chats);
        }

        @Nonnull
        public ITextComponent[] chats() {
            if (this.chats != null) {
                return this.chats;
            }
            this.chats = new ITextComponent[4];
            ITextComponent[] chats = this.chats;
            int i = 0;
            for (String str : this.strings) {
                if (i >= 4) break;
                chats[i] = new TextComponentString(str);
                ++i;
            }
            return chats;
        }

        @Override
        public String toString() {
            return String.format("SignEntryId [strings=%s, chats=%s]", Arrays.toString(this.strings), Arrays.toString(this.chats));
        }

        @Override
        public void toEntity(@Nullable TileEntitySign tile) {
            if (tile != null) {
                System.arraycopy(this.strings, 0, tile.field_145915_a, 0, 4);
            }
        }

        @Nonnull
        public static SignEntryId fromStrings(@Nullable String[] strings) {
            if (strings == null) {
                return blank;
            }
            String[] strs = strings;
            if (strs.length < 4) {
                strs = Arrays.copyOf(strs, 4);
            }
            int i = 0;
            for (String str : strs) {
                if (i >= 4) break;
                if (str == null) {
                    strs[i] = "";
                }
                ++i;
            }
            return SignEntryId.fromSignStrings(strs);
        }

        @Nonnull
        public static SignEntryId fromChats(@Nullable ITextComponent[] chats) {
            if (chats == null) {
                return blank;
            }
            ITextComponent[] chs = chats;
            if (chs.length < 4) {
                chs = Arrays.copyOf(chs, 4);
            }
            String[] strs = new String[4];
            int i = 0;
            for (ITextComponent ch : chs) {
                if (i >= 4) break;
                if (ch == null) {
                    chs[i] = blankChat;
                    strs[i] = "";
                } else {
                    strs[i] = ch.func_150260_c();
                }
                ++i;
            }
            return SignEntryId.fromSignChats(strs, chs);
        }

        @Nonnull
        public static SignEntryId fromTile(@Nullable TileEntitySign tile) {
            if (tile == null) {
                return blank;
            }
            return SignEntryId.fromChats(tile.field_145915_a);
        }
    }

    public static class ItemEntryId
    extends EntryId {
        @Nonnull
        public static final ItemEntryId blank = new ItemEntryId(blank, null);
        @Nullable
        private final String name;

        protected ItemEntryId(@Nonnull EntryId id, @Nullable String name) {
            super(id.id());
            this.name = name;
        }

        public boolean hasName() {
            return this.name != null;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        public static boolean hasName(@Nullable NBTTagCompound nbt) {
            NBTTagCompound nbttagcompound;
            return nbt != null && nbt.func_150297_b("display", 10) && (nbttagcompound = nbt.func_74775_l("display")).func_150297_b("Name", 8);
        }

        @Override
        public String toString() {
            return String.format("ItemEntryId [name=%s]", this.name);
        }

        @Nonnull
        public static ItemEntryId fromItemStack(@Nullable ItemStack itemStack) {
            NBTTagCompound nbt;
            if (itemStack != null && (nbt = itemStack.func_77978_p()) != null && ItemEntryId.hasName(nbt)) {
                String name = itemStack.func_82833_r();
                int index = StringUtils.lastIndexOf((CharSequence)name, (CharSequence)"}");
                String itemname = StringUtils.substringAfterLast((String)name, (String)"}");
                if (StringUtils.isEmpty((CharSequence)itemname)) {
                    itemname = null;
                }
                return new ItemEntryId(ItemEntryId.from(StringUtils.substring((String)itemStack.func_82833_r(), (int)0, (int)(index != -1 ? index + 1 : 0))), itemname);
            }
            return blank;
        }
    }
}

