/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.entry;

import com.google.common.collect.Maps;
import com.kamesuta.mc.signpic.CoreEvent;
import com.kamesuta.mc.signpic.entry.Entry;
import com.kamesuta.mc.signpic.entry.EntryId;
import com.kamesuta.mc.signpic.entry.EntrySlot;
import com.kamesuta.mc.signpic.entry.ITickEntry;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;

public class EntryManager
implements ITickEntry {
    @Nonnull
    public static final EntryManager instance = new EntryManager();
    @Nonnull
    private final Map<EntryId, EntrySlot<Entry>> registry = Maps.newConcurrentMap();

    @Nonnull
    protected Entry get(@Nonnull EntryId id) {
        EntrySlot<Entry> entries = this.registry.get(id);
        if (entries != null) {
            return entries.get();
        }
        Entry entry = new Entry(id);
        this.registry.put(id, new EntrySlot<Entry>(entry));
        return entry;
    }

    @Override
    @CoreEvent
    public void onTick() {
        Iterator<Map.Entry<EntryId, EntrySlot<Entry>>> itr = this.registry.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<EntryId, EntrySlot<Entry>> entry = itr.next();
            EntrySlot<Entry> collectableSignEntry = entry.getValue();
            if (!collectableSignEntry.shouldCollect()) continue;
            itr.remove();
        }
    }
}

