/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.entry.content;

import com.kamesuta.mc.signpic.ILoadCancelable;
import com.kamesuta.mc.signpic.entry.ICollectable;
import com.kamesuta.mc.signpic.entry.IInitable;
import com.kamesuta.mc.signpic.entry.content.ContentId;
import com.kamesuta.mc.signpic.entry.content.ContentLocation;
import com.kamesuta.mc.signpic.entry.content.meta.ContentCache;
import com.kamesuta.mc.signpic.entry.content.meta.ContentMeta;
import com.kamesuta.mc.signpic.image.Image;
import com.kamesuta.mc.signpic.image.RemoteImage;
import com.kamesuta.mc.signpic.image.ResourceImage;
import com.kamesuta.mc.signpic.state.State;
import com.kamesuta.mc.signpic.state.StateType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Content
implements IInitable,
ICollectable,
ILoadCancelable {
    @Nonnull
    public final ContentId id;
    @Nonnull
    public final ContentMeta meta;
    @Nonnull
    public final State state;
    @Nonnull
    public Image image;
    @Nullable
    public String imagemeta;
    private boolean dirty;

    public Content(@Nonnull ContentId id) {
        this.id = id;
        String url = id.getURI();
        String hash = ContentLocation.hash(url);
        this.meta = new ContentMeta(ContentLocation.metaLocation(hash));
        this.meta.setURL(url);
        this.meta.setMetaID(hash);
        this.state = new State();
        this.state.setName(id.getID());
        this.image = id.isResource() ? new ResourceImage(this) : new RemoteImage(this);
    }

    @Override
    public void onInit() {
        this.state.setType(StateType.INITALIZED);
        this.image.onInit();
    }

    @Override
    public void onCollect() {
        this.image.onCollect();
    }

    public boolean shouldCollect() {
        return this.dirty;
    }

    @Override
    public void cancel() {
        this.image.cancel();
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void markDirtyWithCache() {
        this.meta.setTryCount(0);
        String id = this.meta.getCacheID();
        if (id != null) {
            ContentCache cachemeta = new ContentCache(ContentLocation.cachemetaLocation(id));
            cachemeta.setDirty(true);
        }
        this.markDirty();
    }
}

