/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.entry.content;

import com.kamesuta.mc.signpic.entry.content.Content;
import com.kamesuta.mc.signpic.entry.content.ContentManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public class ContentId {
    @Nonnull
    public static final ResourceLocation hideTexture = new ResourceLocation("signpic", "textures/state/hide.png");
    @Nonnull
    public static final ContentId hideContent = ContentId.fromResource(hideTexture);
    @Nonnull
    private final String id;

    protected ContentId(@Nonnull String uri) {
        if (StringUtils.contains((CharSequence)uri, (CharSequence)"http://")) {
            uri = "" + StringUtils.substring((String)uri, (int)7, (int)StringUtils.length((CharSequence)uri));
        } else if (StringUtils.contains((CharSequence)uri, (CharSequence)"https://")) {
            uri = "$" + StringUtils.substring((String)uri, (int)8, (int)StringUtils.length((CharSequence)uri));
        }
        this.id = uri;
    }

    @Nonnull
    public String getID() {
        return this.id;
    }

    @Nonnull
    public String getURI() {
        if (!StringUtils.startsWith((CharSequence)this.id, (CharSequence)"!")) {
            if (StringUtils.startsWith((CharSequence)this.id, (CharSequence)"$")) {
                return "https://" + StringUtils.substring((String)this.id, (int)1);
            }
            if (!StringUtils.startsWith((CharSequence)this.id, (CharSequence)"http://") && !StringUtils.startsWith((CharSequence)this.id, (CharSequence)"https://")) {
                return "http://" + this.id;
            }
        }
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentId)) {
            return false;
        }
        ContentId other = (ContentId)obj;
        return this.id.equals(other.id);
    }

    @Nullable
    public String toString() {
        return String.format("ContentId [id=%s]", this.id);
    }

    public boolean isResource() {
        return this.id.startsWith("!");
    }

    @Nonnull
    public ResourceLocation getResource() {
        return new ResourceLocation(StringUtils.substring((String)this.id, (int)1));
    }

    @Nonnull
    public Content content() {
        return ContentManager.instance.get(this);
    }

    @Nonnull
    public static ContentId from(@Nonnull String uri) {
        return new ContentId(uri);
    }

    @Nonnull
    public static ContentId fromResource(@Nonnull ResourceLocation location) {
        return ContentId.from("!" + location.toString());
    }
}

