/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.entry.content;

import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.kamesuta.mc.signpic.Config;
import com.kamesuta.mc.signpic.CoreEvent;
import com.kamesuta.mc.signpic.entry.EntrySlot;
import com.kamesuta.mc.signpic.entry.IAsyncProcessable;
import com.kamesuta.mc.signpic.entry.ICollectable;
import com.kamesuta.mc.signpic.entry.IDivisionProcessable;
import com.kamesuta.mc.signpic.entry.IInitable;
import com.kamesuta.mc.signpic.entry.ITickEntry;
import com.kamesuta.mc.signpic.entry.content.Content;
import com.kamesuta.mc.signpic.entry.content.ContentId;
import com.kamesuta.mc.signpic.util.ThreadUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import net.minecraftforge.client.event.TextureStitchEvent;

public class ContentManager
implements ITickEntry {
    @Nonnull
    public static ContentManager instance = new ContentManager();
    @Nonnull
    public final ExecutorService threadpool;
    @Nonnull
    private final Map<ContentId, ContentSlot> registry;
    @Nonnull
    private final Queue<ContentSlot> loadqueue;
    @Nonnull
    private final Queue<IDivisionProcessable> divisionqueue;
    private int loadtick;
    private int divisiontick;

    private ContentManager() {
        this.threadpool = ThreadUtils.newFixedCachedThreadPool(Config.getConfig().contentLoadThreads.get(), "signpic-content-%d");
        this.registry = Maps.newConcurrentMap();
        this.loadqueue = Queues.newConcurrentLinkedQueue();
        this.divisionqueue = Queues.newConcurrentLinkedQueue();
        this.loadtick = 0;
        this.divisiontick = 0;
    }

    public void enqueueAsync(final @Nonnull IAsyncProcessable asyncProcessable) {
        this.threadpool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    asyncProcessable.onAsyncProcess();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void enqueueDivision(@Nonnull IDivisionProcessable divisionProcessable) {
        this.divisionqueue.offer(divisionProcessable);
    }

    @Nonnull
    protected Content get(@Nonnull ContentId id) {
        ContentSlot entries = this.registry.get(id);
        if (entries != null) {
            return (Content)entries.get();
        }
        Content entry = new Content(id);
        ContentSlot slot = new ContentSlot(entry);
        this.registry.put(id, slot);
        this.loadqueue.offer(slot);
        return entry;
    }

    @Override
    @CoreEvent
    public void onTick() {
        ++this.loadtick;
        if (this.loadtick > Config.getConfig().contentLoadTick.get()) {
            this.loadtick = 0;
            ContentSlot loadprogress = this.loadqueue.poll();
            if (loadprogress != null) {
                loadprogress.onInit();
            }
        }
        ++this.divisiontick;
        if (this.divisiontick > Config.getConfig().contentSyncTick.get()) {
            this.divisiontick = 0;
            IDivisionProcessable divisionprocess = this.divisionqueue.peek();
            if (divisionprocess != null) {
                try {
                    if (divisionprocess.onDivisionProcess()) {
                        this.divisionqueue.poll();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Iterator<Map.Entry<ContentId, ContentSlot>> itr = this.registry.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<ContentId, ContentSlot> entry = itr.next();
            ContentSlot collectableSignEntry = entry.getValue();
            if (!collectableSignEntry.shouldCollect()) continue;
            this.loadqueue.remove(collectableSignEntry);
            ((Content)collectableSignEntry.get()).onCollect();
            itr.remove();
        }
    }

    public void reloadAll() {
        for (Map.Entry<ContentId, ContentSlot> entry : this.registry.entrySet()) {
            ((Content)entry.getValue().get()).markDirty();
        }
    }

    public void redownloadAll() {
        for (Map.Entry<ContentId, ContentSlot> entry : this.registry.entrySet()) {
            ((Content)entry.getValue().get()).markDirtyWithCache();
        }
    }

    @CoreEvent
    public void onResourceReloaded(@Nonnull TextureStitchEvent.Post event) {
        this.reloadAll();
    }

    public static class ContentSlot
    extends EntrySlot<Content>
    implements IInitable,
    ICollectable {
        public ContentSlot(@Nonnull Content entry) {
            super(entry);
        }

        @Override
        public void onInit() {
            ((Content)this.entry).onInit();
        }

        @Override
        public void onCollect() {
            ((Content)this.entry).onCollect();
        }

        @Override
        public boolean shouldCollect() {
            return ((Content)this.entry).shouldCollect() || super.shouldCollect();
        }

        @Override
        protected int getCollectTimes() {
            return Config.getConfig().contentGCtick.get();
        }
    }
}

