/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.entry.content.meta;

import com.kamesuta.mc.signpic.entry.content.meta.IData;
import com.kamesuta.mc.signpic.entry.content.meta.MetaIO;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ContentCache {
    @Nonnull
    private final MetaIO<CacheData> cacheio;

    public ContentCache(@Nonnull File location) {
        this.cacheio = new MetaIO<CacheData>(location, CacheData.class){

            @Override
            @Nonnull
            public CacheData createBlank() {
                return new CacheData();
            }
        };
    }

    @Nullable
    public String getURL() {
        return this.cacheio.get().url;
    }

    @Nonnull
    public ContentCache setURL(@Nullable String url) {
        this.cacheio.get().url = url;
        this.cacheio.save();
        return this;
    }

    @Nullable
    public String getMime() {
        return this.cacheio.get().mime;
    }

    @Nonnull
    public ContentCache setMime(@Nullable String mime) {
        this.cacheio.get().mime = mime;
        this.cacheio.save();
        return this;
    }

    public long getSize() {
        return this.cacheio.get().size;
    }

    @Nonnull
    public ContentCache setSize(long size) {
        this.cacheio.get().size = size;
        this.cacheio.save();
        return this;
    }

    public boolean isDirty() {
        return this.cacheio.get().dirty;
    }

    @Nonnull
    public ContentCache setDirty(boolean dirty) {
        this.cacheio.get().dirty = dirty;
        this.cacheio.save();
        return this;
    }

    public long getLastUpdated() {
        return this.cacheio.get().update;
    }

    @Nonnull
    public ContentCache setLastUpdated(long update) {
        this.cacheio.get().update = update;
        this.cacheio.save();
        return this;
    }

    public boolean isAvailable() {
        return this.cacheio.get().available;
    }

    @Nonnull
    public ContentCache setAvailable(boolean available) {
        this.cacheio.get().available = available;
        this.cacheio.save();
        return this;
    }

    public static class CacheData
    implements IData {
        public int format = 3;
        @Nullable
        public String url;
        @Nullable
        public String mime;
        public long size;
        public boolean dirty;
        public long update;
        public boolean available;

        @Override
        public int getFormat() {
            return this.format;
        }
    }
}

