/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.entry.content.meta;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.kamesuta.mc.signpic.Client;
import com.kamesuta.mc.signpic.Log;
import com.kamesuta.mc.signpic.entry.content.meta.IData;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;

public abstract class MetaIO<E extends IData> {
    @Nonnull
    public final File location;
    @Nonnull
    public final Class<E> clazz;
    @Nullable
    private transient E data;

    public MetaIO(@Nonnull File location, @Nonnull Class<E> clazz) {
        this.location = location;
        this.clazz = clazz;
    }

    @Nonnull
    public E get() {
        if (this.data != null) {
            return this.data;
        }
        this.data = this.loadData();
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private E loadData() {
        JsonReader reader;
        block4: {
            IData iData;
            reader = null;
            try {
                if (!this.location.exists()) break block4;
                reader = new JsonReader((Reader)new InputStreamReader((InputStream)new FileInputStream(this.location), StandardCharsets.UTF_8));
                IData data = (IData)Client.gson.fromJson(reader, this.clazz);
                IOUtils.closeQuietly((Closeable)reader);
                if (data == null || data.getFormat() != 3) break block4;
                iData = data;
            }
            catch (Exception e) {
                try {
                    Log.log.warn("content meta data is broken. aborted. [" + this.location.getName() + "]");
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)reader);
            }
            IOUtils.closeQuietly((Closeable)reader);
            return (E)iData;
        }
        IOUtils.closeQuietly(reader);
        return this.createBlank();
    }

    @Nonnull
    public abstract E createBlank();

    public void save() {
        this.saveData(this.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveData(@Nullable E data) {
        JsonWriter writer = null;
        try {
            writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(this.location), StandardCharsets.UTF_8));
            Client.gson.toJson(data, this.clazz, writer);
        }
        catch (Exception exception) {
            IOUtils.closeQuietly(writer);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)writer);
    }
}

