/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.entry.content.meta;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class URIStacks {
    @Nonnull
    private final URI end;
    @Nonnull
    private final List<URI> uristack;

    protected URIStacks(@Nonnull URI end, @Nonnull List<URI> uristack) {
        this.end = end;
        this.uristack = uristack;
    }

    @Nonnull
    public URI getEndPoint() {
        return this.end;
    }

    @Nonnull
    public List<URI> getRedirectTrace() {
        return this.uristack;
    }

    @Nonnull
    public String getMetaString() {
        StringBuilder stb = new StringBuilder();
        for (URI uri : this.uristack) {
            String frag = uri.getFragment();
            String[] metas = StringUtils.substringsBetween((String)frag, (String)"(=", (String)"=)");
            if (metas == null) continue;
            for (String meta : metas) {
                stb.append(meta);
            }
        }
        return stb.toString();
    }

    @Nonnull
    public static URIStacks from(@Nonnull URI base, @Nullable List<URI> redirects) {
        URI end;
        LinkedList reds;
        if (redirects != null && !redirects.isEmpty()) {
            reds = Lists.newLinkedList(redirects);
            end = (URI)reds.getLast();
            Collections.reverse(reds);
        } else {
            reds = Lists.newLinkedList();
            end = base;
        }
        reds.add(base);
        return new URIStacks(end, reds);
    }
}

