/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.gui;

import com.kamesuta.mc.bnnwidget.WBase;
import com.kamesuta.mc.bnnwidget.WEvent;
import com.kamesuta.mc.bnnwidget.WFrame;
import com.kamesuta.mc.bnnwidget.WPanel;
import com.kamesuta.mc.bnnwidget.component.MScaledLabel;
import com.kamesuta.mc.bnnwidget.motion.Easings;
import com.kamesuta.mc.bnnwidget.motion.Motion;
import com.kamesuta.mc.bnnwidget.position.Area;
import com.kamesuta.mc.bnnwidget.position.Coord;
import com.kamesuta.mc.bnnwidget.position.Point;
import com.kamesuta.mc.bnnwidget.position.R;
import com.kamesuta.mc.bnnwidget.render.OpenGL;
import com.kamesuta.mc.bnnwidget.render.RenderOption;
import com.kamesuta.mc.bnnwidget.render.WRenderer;
import com.kamesuta.mc.bnnwidget.var.V;
import com.kamesuta.mc.bnnwidget.var.VBase;
import com.kamesuta.mc.bnnwidget.var.VMotion;
import com.kamesuta.mc.signpic.Client;
import com.kamesuta.mc.signpic.attr.AttrReaders;
import com.kamesuta.mc.signpic.attr.prop.OffsetData;
import com.kamesuta.mc.signpic.attr.prop.RotationData;
import com.kamesuta.mc.signpic.attr.prop.SizeData;
import com.kamesuta.mc.signpic.entry.Entry;
import com.kamesuta.mc.signpic.entry.EntryId;
import com.kamesuta.mc.signpic.entry.content.Content;
import com.kamesuta.mc.signpic.gui.GuiSettings;
import com.kamesuta.mc.signpic.information.Informations;
import com.kamesuta.mc.signpic.mode.CurrentMode;
import com.kamesuta.mc.signpic.render.StateRender;
import com.kamesuta.mc.signpic.state.StateType;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;

public class GuiImage
extends WFrame {
    @Nonnull
    protected Entry entry;
    @Nonnull
    public static final ResourceLocation resError = new ResourceLocation("signpic", "textures/state/error.png");

    public GuiImage(@Nonnull Entry entry) {
        this.entry = entry;
        this.func_146280_a(Client.mc, 0, 0);
    }

    @Override
    protected void initWidget() {
        this.add(new WPanel(new R(new Coord[0])){

            @Override
            protected void initWidget() {
                this.add(new WBase(new R(new Coord[0])){

                    @Override
                    public void draw(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, float frame, float popacity, @Nonnull RenderOption opt) {
                        Area a = this.getGuiPosition(pgp);
                        float opacity = this.getGuiOpacity(popacity);
                        Content content = GuiImage.this.entry.getContent();
                        AttrReaders meta = GuiImage.this.entry.getMeta();
                        OpenGL.glPushMatrix();
                        if (GuiImage.this.entry.id instanceof EntryId.PreviewEntryId || GuiImage.this.entry.isNotSupported() || GuiImage.this.entry.isOutdated()) {
                            opacity *= 0.5f;
                        }
                        OpenGL.glPushMatrix();
                        if (CurrentMode.instance.isState(CurrentMode.State.SEE)) {
                            OpenGL.glColor4f(0.5f, 0.5f, 0.5f, opacity * 0.5f);
                            OpenGL.glLineWidth(1.0f);
                            WRenderer.startShape();
                            1.draw(Area.abs(0.0f, 0.0f, a.w(), a.h()), 2);
                            float h = a.h() - 0.5f;
                            WRenderer.WVertex v = 1.begin(1);
                            v.pos(a.w() / 2.0f, h, 0.0);
                            v.pos(0.0, 0.0, 0.0);
                            v.pos(a.w() / 2.0f, h, 0.0);
                            v.pos(a.w(), 0.0, 0.0);
                            v.pos(a.w() / 2.0f, h, 0.0);
                            v.pos(a.w(), a.h(), 0.0);
                            v.pos(a.w() / 2.0f, h, 0.0);
                            v.pos(0.0, a.h(), 0.0);
                            v.draw();
                        }
                        OpenGL.glScalef(a.w(), a.h(), 1.0f);
                        if (content != null && content.state.getType() == StateType.AVAILABLE && !meta.hasInvalidMeta()) {
                            float o = meta.o.getMovie().get().data * 0.1f;
                            OpenGL.glColor4f(1.0f, 1.0f, 1.0f, opacity * o);
                            content.image.draw(meta, opt.get("vertex", Area.class), opt.get("trim", Area.class));
                        } else {
                            WRenderer.startShape();
                            OpenGL.glLineWidth(1.0f);
                            OpenGL.glColor4f(1.0f, 0.0f, 0.0f, opacity * 1.0f);
                            1.draw(Area.abs(0.0f, 0.0f, 1.0f, 1.0f), 2);
                        }
                        OpenGL.glPopMatrix();
                        if (a.w() < 1.5f || (double)a.h() < 1.5) {
                            OpenGL.glScalef(0.5f, 0.5f, 0.5f);
                            OpenGL.glTranslatef(a.w() / 2.0f, a.h() / 4.0f, 0.0f);
                        }
                        OpenGL.glTranslatef(a.w() / 2.0f, a.h() / 2.0f, 0.0f);
                        OpenGL.glScalef(0.5f, 0.5f, 1.0f);
                        if (content != null && content.state.getType() != StateType.AVAILABLE) {
                            if (content.state.getType() == StateType.ERROR) {
                                OpenGL.glPushMatrix();
                                OpenGL.glTranslatef(-0.5f, -0.5f, 0.0f);
                                WRenderer.startTexture();
                                1.texture().func_110577_a(resError);
                                1.drawTexture(opt.get("vertex", Area.class), opt.get("trim", Area.class), null);
                                OpenGL.glPopMatrix();
                            }
                            StateRender.drawLoading(content.state.getProgress(), content.state.getType().circle, content.state.getType().speed);
                            StateRender.drawMessage(content, 1.font());
                        }
                        OpenGL.glEnable(2896);
                        OpenGL.glPopMatrix();
                    }
                });
                if (GuiImage.this.entry.isOutdated()) {
                    this.add(new OutdatedPanel(new R(new Coord[0])));
                } else if (GuiImage.this.entry.isNotSupported()) {
                    this.add(new NotSupportedPanel(new R(new Coord[0])));
                }
            }
        });
    }

    public void renderSignPicture(float opacity, float scale, @Nonnull RenderOption opt) {
        Content content = this.entry.getContent();
        AttrReaders attr = this.entry.getMeta();
        SizeData size01 = content != null ? content.image.getSize() : SizeData.DefaultSize;
        SizeData size = attr.sizes.getMovie().get().aspectSize(size01);
        OpenGL.glPushMatrix();
        OffsetData offset = attr.offsets.getMovie().get();
        OffsetData centeroffset = attr.centeroffsets.getMovie().get();
        Quat4f rotate = attr.rotations.getMovie().get().getRotate();
        boolean see = CurrentMode.instance.isState(CurrentMode.State.SEE);
        if (see) {
            OpenGL.glColor4f(0.5f, 0.5f, 0.5f, opacity * 0.5f);
            OpenGL.glLineWidth(1.0f);
            WRenderer.startShape();
            WRenderer.WVertex v1 = WRenderer.begin(3);
            Matrix4f m = new Matrix4f();
            Vector3f ov = new Vector3f(offset.x.offset, offset.y.offset, offset.z.offset);
            Vector3f cv = new Vector3f(centeroffset.x.offset, centeroffset.y.offset, centeroffset.z.offset);
            Point3f p = new Point3f();
            v1.pos(p.x, p.y, p.z);
            m.set(ov);
            m.transform(p);
            m.set(cv);
            m.transform(p);
            v1.pos(p.x, p.y, p.z);
            p.set(0.0f, 0.0f, 0.0f);
            cv.negate();
            m.set(cv);
            m.transform(p);
            m.set(rotate);
            m.transform(p);
            cv.negate();
            m.set(cv);
            m.transform(p);
            m.set(ov);
            m.transform(p);
            v1.pos(p.x, p.y, p.z);
            v1.draw();
        }
        OpenGL.glTranslatef(offset.x.offset, offset.y.offset, offset.z.offset);
        OpenGL.glTranslatef(centeroffset.x.offset, centeroffset.y.offset, centeroffset.z.offset);
        RotationData.RotationGL.glRotate(rotate);
        OpenGL.glTranslatef(-centeroffset.x.offset, -centeroffset.y.offset, -centeroffset.z.offset);
        OpenGL.glTranslatef(-size.getWidth() / 2.0f, size.getHeight() + (size.getHeight() >= 0.0f ? 0.0f : -size.getHeight()) - 0.5f, 0.0f);
        OpenGL.glScalef(size.getWidth() < 0.0f ? -1.0f : 1.0f, size.getHeight() < 0.0f ? 1.0f : -1.0f, 1.0f);
        OpenGL.glScalef(scale, scale, 1.0f);
        this.drawScreen(0, 0, 0.0f, opacity, size.getWidth() / scale, size.getHeight() / scale, opt);
        OpenGL.glPopMatrix();
    }

    public void applyLight(float x, float y, float z, @Nonnull Quat4f signrotate) {
        AttrReaders attr = this.entry.getMeta();
        int lightx = (int)attr.f.getMovie().get().data;
        int lighty = (int)attr.g.getMovie().get().data;
        if (lightx != -1 || lighty != -1) {
            if (lightx < 0 || lighty < 0) {
                int lsign = 0;
                int lcenter = 0;
                int lpicture = 0;
                if (lightx != -2 && lightx != -3 || lighty != -2 && lighty != -3) {
                    lsign = Client.mc.field_71441_e.func_175642_b(EnumSkyBlock.SKY, new BlockPos(MathHelper.func_76141_d((float)x), MathHelper.func_76141_d((float)y), MathHelper.func_76141_d((float)z)));
                }
                if (lightx == -2 || lighty == -2 || lightx == -3 || lighty == -3) {
                    OffsetData offset = attr.offsets.getMovie().get();
                    OffsetData centeroffset = attr.centeroffsets.getMovie().get();
                    Matrix4f m = new Matrix4f();
                    Point3f p = new Point3f();
                    Quat4f rotate = attr.rotations.getMovie().get().getRotate();
                    Vector3f tv = new Vector3f(x, y, z);
                    Vector3f ov = new Vector3f(offset.x.offset, offset.y.offset, offset.z.offset);
                    Vector3f cv = new Vector3f(centeroffset.x.offset, centeroffset.y.offset, centeroffset.z.offset);
                    m.set(ov);
                    m.transform(p);
                    m.set(cv);
                    m.transform(p);
                    m.set(signrotate);
                    m.transform(p);
                    m.set(tv);
                    m.transform(p);
                    if (lightx == -2 || lighty == -2) {
                        lcenter = Client.mc.field_71441_e.func_175642_b(EnumSkyBlock.SKY, new BlockPos(MathHelper.func_76141_d((float)p.x), MathHelper.func_76141_d((float)p.y), MathHelper.func_76141_d((float)p.z)));
                    }
                    if (lightx == -3 || lighty == -3) {
                        Point3f p2 = new Point3f();
                        m.set(cv);
                        m.transform(p2);
                        m.set(signrotate);
                        m.transform(p2);
                        m.set(rotate);
                        m.transform(p2);
                        p.sub((Tuple3f)p2);
                        lpicture = Client.mc.field_71441_e.func_175642_b(EnumSkyBlock.SKY, new BlockPos(MathHelper.func_76141_d((float)p.x), MathHelper.func_76141_d((float)p.y), MathHelper.func_76141_d((float)p.z)));
                    }
                }
                if (lightx < 0) {
                    lightx = lightx == -2 ? lcenter % 65536 >> 4 : (lightx == -3 ? lpicture % 65536 >> 4 : lsign % 65536 >> 4);
                }
                if (lighty < 0) {
                    lighty = lighty == -2 ? lcenter / 65536 >> 4 : (lighty == -3 ? lpicture / 65536 >> 4 : lsign / 65536 >> 4);
                }
            }
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(lightx << 4), (float)(lighty << 4));
        }
    }

    public void drawScreen(int mousex, int mousey, float f, float opacity, float width, float height, @Nonnull RenderOption opt) {
        this.setWidth(width).setHeight(height);
        super.drawScreen(mousex, mousey, f, opacity, opt);
    }

    protected class UpdateLogo
    extends WBase {
        @Nonnull
        protected VMotion rot;

        public UpdateLogo(R position) {
            super(position);
            this.rot = V.pm(0.0f).add(Motion.of(0.0f, Easings.easeInOutSine.move(2.87f, 1.0f), Motion.blank(0.58f)).setLoop(true)).setLoop(true).start();
        }

        @Override
        public void draw(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, float frame, float popacity, RenderOption opt) {
            Area a = this.getGuiPosition(pgp);
            UpdateLogo.texture().func_110577_a(GuiSettings.update);
            OpenGL.glColor4f(0.5625f, 0.74609375f, 0.1875f, 1.0f);
            WRenderer.startTexture();
            OpenGL.glPushMatrix();
            OpenGL.glTranslatef(a.x1() + a.w() / 2.0f, a.y1() + a.h() / 2.0f, 0.0f);
            OpenGL.glRotatef(this.rot.get() * 360.0f, 0.0f, 0.0f, 1.0f);
            OpenGL.glTranslatef(-a.x1() - a.w() / 2.0f, -a.y1() - a.h() / 2.0f, -0.001f);
            UpdateLogo.drawTexture(a, null, null);
            OpenGL.glTranslatef(0.0f, 0.0f, -0.002f);
            UpdateLogo.drawTexture(a, null, null);
            OpenGL.glPopMatrix();
        }
    }

    protected class OutdatedPanel
    extends WPanel {
        public OutdatedPanel(R position) {
            super(position);
        }

        @Override
        protected void initWidget() {
            VBase var = V.a(0.8f);
            this.add(new UpdateLogo(new R(Coord.width(var), Coord.height(var), Coord.pleft(0.5f), Coord.ptop(0.5f)).child(Coord.pleft(-0.5f), Coord.ptop(-0.5f))));
            this.add(new MScaledLabel(new R(Coord.pleft(0.5f), Coord.top(0.0f), Coord.pheight(0.4f), Coord.width(2.0f)).child(Coord.pleft(-0.5f))).setText(I18n.func_135052_a((String)"signpic.advmsg.format.outdated", (Object[])new Object[0])).setColor(0xFF9900).setShadow(true));
            this.add(new MScaledLabel(new R(Coord.pleft(0.5f), Coord.bottom(0.0f), Coord.pheight(0.4f), Coord.width(2.0f)).child(Coord.pleft(-0.5f))).setText(I18n.func_135052_a((String)"signpic.advmsg.format.needreplace", (Object[])new Object[0])).setColor(0xFF9900).setShadow(true));
        }

        @Override
        public void draw(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, float frame, float popacity, RenderOption opt) {
            WRenderer.startShape();
            OpenGL.glLineWidth(1.0f);
            OpenGL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            OpenGL.glPushMatrix();
            OpenGL.glTranslatef(0.0f, 0.0f, 0.002f);
            super.draw(ev, pgp, p, frame, popacity, opt);
            OpenGL.glPopMatrix();
        }
    }

    protected class NotSupportedPanel
    extends WPanel {
        public NotSupportedPanel(R position) {
            super(position);
        }

        @Override
        protected void initWidget() {
            VBase var = V.a(0.8f);
            this.add(new UpdateLogo(new R(Coord.width(var), Coord.height(var), Coord.pleft(0.5f), Coord.ptop(0.5f)).child(Coord.pleft(-0.5f), Coord.ptop(-0.5f))));
            this.add(new MScaledLabel(new R(Coord.pleft(0.5f), Coord.top(0.0f), Coord.pheight(0.4f), Coord.width(2.0f)).child(Coord.pleft(-0.5f))).setText(I18n.func_135052_a((String)"signpic.advmsg.format.unsupported", (Object[])new Object[0])).setColor(0xFF9900).setShadow(true));
            if (Informations.instance.isUpdateRequired()) {
                this.add(new MScaledLabel(new R(Coord.pleft(0.5f), Coord.bottom(0.0f), Coord.pheight(0.4f), Coord.width(2.0f)).child(Coord.pleft(-0.5f))).setText(I18n.func_135052_a((String)"signpic.advmsg.format.needupdate", (Object[])new Object[0])).setColor(0xFF9900).setShadow(true));
            }
        }

        @Override
        public void draw(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, float frame, float popacity, RenderOption opt) {
            WRenderer.startShape();
            OpenGL.glLineWidth(1.0f);
            OpenGL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            OpenGL.glPushMatrix();
            OpenGL.glTranslatef(0.0f, 0.0f, 0.002f);
            super.draw(ev, pgp, p, frame, popacity, opt);
            OpenGL.glPopMatrix();
        }
    }
}

