/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.gui;

import com.kamesuta.mc.bnnwidget.WEvent;
import com.kamesuta.mc.bnnwidget.WFrame;
import com.kamesuta.mc.bnnwidget.WPanel;
import com.kamesuta.mc.bnnwidget.font.FontStyle;
import com.kamesuta.mc.bnnwidget.font.TrueTypeFont;
import com.kamesuta.mc.bnnwidget.font.WFontRenderer;
import com.kamesuta.mc.bnnwidget.motion.Easings;
import com.kamesuta.mc.bnnwidget.motion.Motion;
import com.kamesuta.mc.bnnwidget.position.Area;
import com.kamesuta.mc.bnnwidget.position.Coord;
import com.kamesuta.mc.bnnwidget.position.Point;
import com.kamesuta.mc.bnnwidget.position.R;
import com.kamesuta.mc.bnnwidget.render.OpenGL;
import com.kamesuta.mc.bnnwidget.render.RenderOption;
import com.kamesuta.mc.bnnwidget.render.WGui;
import com.kamesuta.mc.bnnwidget.render.WRenderer;
import com.kamesuta.mc.bnnwidget.var.V;
import com.kamesuta.mc.bnnwidget.var.VMotion;
import com.kamesuta.mc.signpic.Client;
import com.kamesuta.mc.signpic.Log;
import com.kamesuta.mc.signpic.gui.GuiWindowScreenShot;
import com.kamesuta.mc.signpic.http.upload.UploadCallback;
import com.kamesuta.mc.signpic.mode.CurrentMode;
import com.kamesuta.mc.signpic.util.FileUtilitiy;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.IntBuffer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class GuiIngameScreenShot
extends WFrame {
    private static WFontRenderer font = new WFontRenderer(new TrueTypeFont(new FontStyle.Builder().build()));
    private boolean takescreenshot;
    @Nullable
    private static IntBuffer pixelBuffer;
    @Nullable
    private static int[] pixelValues;

    public GuiIngameScreenShot(@Nullable GuiScreen parent) {
        super(parent);
        this.setGuiPauseGame(false);
    }

    public GuiIngameScreenShot() {
        this.setGuiPauseGame(false);
    }

    @Override
    public void func_146281_b() {
        WGui.showCursor();
        super.func_146281_b();
    }

    @Override
    protected void initWidget() {
        WGui.hideCursor();
        this.add(new WPanel(new R(new Coord[0])){
            @Nullable
            private Point point;
            private boolean takingscreenshot;
            private boolean disable;
            private boolean flushing;
            @Nonnull
            private final VMotion opacity;
            {
                this.opacity = V.pm(0.0f).start();
            }

            @Override
            public boolean mouseClicked(WEvent ev, Area pgp, Point p, int button) {
                if (this.point == null) {
                    this.point = p;
                }
                return super.mouseClicked(ev, pgp, p, button);
            }

            @Override
            public boolean mouseReleased(WEvent ev, Area pgp, Point p, int button) {
                if (this.point != null && !this.point.equals(p)) {
                    GuiIngameScreenShot.this.takescreenshot = true;
                }
                return super.mouseReleased(ev, pgp, p, button);
            }

            @Override
            public void draw(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point point2, float frame, float popacity, @Nonnull RenderOption opt) {
                boolean continuemode = CurrentMode.instance.isState(CurrentMode.State.CONTINUE);
                Area a = this.getGuiPosition(pgp);
                WRenderer.startShape(WRenderer.BlendType.ONE_MINUS_DST_COLOR, WRenderer.BlendType.ZERO);
                OpenGL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                this.drawCursor(point2);
                if (this.flushing) {
                    Point point = this.point;
                    Area rect = point != null ? Area.abs(point2.x(), point2.y(), point.x(), point.y()) : a;
                    WRenderer.startShape();
                    if (continuemode) {
                        OpenGL.glColor(GuiWindowScreenShot.bgcolor);
                        1.draw(a);
                    }
                    OpenGL.glColor4f(1.0f, 1.0f, 1.0f, this.opacity.get());
                    1.draw(rect);
                    if (this.opacity.isFinished()) {
                        if (!continuemode) {
                            GuiIngameScreenShot.this.requestClose();
                        }
                        this.flushing = false;
                        this.point = null;
                    }
                } else if (this.takingscreenshot) {
                    BufferedImage image;
                    this.takingscreenshot = false;
                    Point point1 = this.point;
                    if (point1 != null) {
                        Area rect = Area.abs(point2.x() * GuiIngameScreenShot.this.scaleX(), point2.y() * GuiIngameScreenShot.this.scaleY(), point1.x() * GuiIngameScreenShot.this.scaleX(), point1.y() * GuiIngameScreenShot.this.scaleY());
                        image = GuiIngameScreenShot.takeScreenshotRect((int)rect.x1(), (int)rect.y1(), (int)rect.w() - 1, (int)rect.h() - 1, mc.func_147110_a());
                    } else {
                        image = GuiIngameScreenShot.takeScreenshot(mc.func_147110_a());
                    }
                    if (image != null) {
                        try {
                            FileUtilitiy.uploadImage(image, UploadCallback.copyOnDone);
                        }
                        catch (IOException e) {
                            Log.notice(I18n.func_135052_a((String)"signpic.gui.notice.screenshot.ingame.capture.error", (Object[])new Object[]{e}));
                        }
                    }
                    Client.playSound(new ResourceLocation("signpic", "gui.screenshot"), 1.0f);
                    this.opacity.stop().add(Motion.move(0.25f)).add(Easings.easeLinear.move(0.5f, 0.0f));
                    this.flushing = true;
                    if (!continuemode) {
                        this.disable = true;
                    }
                } else if (GuiIngameScreenShot.this.takescreenshot) {
                    GuiIngameScreenShot.this.takescreenshot = false;
                    this.takingscreenshot = true;
                } else if (!this.disable && !GuiIngameScreenShot.this.closeRequest) {
                    Point point = this.point;
                    if (point != null) {
                        Area rect = Area.abs(point2.x(), point2.y(), point.x(), point.y());
                        WRenderer.startShape();
                        OpenGL.glColor(GuiWindowScreenShot.bgcolor);
                        this.drawAround(a, rect);
                        WRenderer.startTexture();
                        OpenGL.glColor(GuiWindowScreenShot.textcolor);
                        font.drawString(String.valueOf((int)rect.w()), Area.abs(rect.x2() - 5.0f, rect.y2() - 12.0f, 10.0f, 3.0f), GuiIngameScreenShot.this.guiScaleX(), WGui.Align.RIGHT, true);
                        font.drawString(String.valueOf((int)rect.h()), Area.abs(rect.x2() - 5.0f, rect.y2() - 8.0f, 10.0f, 3.0f), GuiIngameScreenShot.this.guiScaleY(), WGui.Align.RIGHT, true);
                    } else {
                        WRenderer.startShape();
                        OpenGL.glColor4f(0.0f, 0.0f, 0.0f, 0.25f);
                        1.draw(a);
                    }
                }
                WRenderer.startShape();
                super.draw(ev, pgp, point2, frame, popacity, opt);
            }

            private void drawCursor(Point point) {
                float s = 0.5f;
                1.draw(Area.abs(point.x() - 0.5f, point.y() - 0.5f, point.x() + 0.5f, point.y() + 0.5f));
                1.draw(Area.abs(point.x() - 4.5f, point.y() - 0.5f, point.x(), point.y() + 0.5f));
                1.draw(Area.abs(point.x(), point.y() - 0.5f, point.x() + 4.5f, point.y() + 0.5f));
                1.draw(Area.abs(point.x() - 0.5f, point.y() - 4.5f, point.x() + 0.5f, point.y()));
                1.draw(Area.abs(point.x() - 0.5f, point.y(), point.x() + 0.5f, point.y() + 4.5f));
            }

            private void drawAround(@Nonnull Area out, @Nonnull Area in) {
                1.draw(Area.abs(out.x1(), out.y1(), out.x2(), in.y1()));
                1.draw(Area.abs(out.x1(), in.y1(), in.x1(), in.y2()));
                1.draw(Area.abs(in.x2(), in.y1(), out.x2(), in.y2()));
                1.draw(Area.abs(out.x1(), in.y2(), out.x2(), out.y2()));
            }
        });
    }

    public void takeFullScreenshot() {
        this.takescreenshot = true;
    }

    @Nullable
    public static BufferedImage takeScreenshotRect(int x, int y, int w, int h, Framebuffer framebuffer) {
        if (w <= 0 || h <= 0) {
            return null;
        }
        try {
            int displayHeight;
            int displayWidth;
            boolean fboEnabled = OpenGlHelper.func_148822_b();
            if (fboEnabled) {
                displayWidth = framebuffer.field_147622_a;
                displayHeight = framebuffer.field_147620_b;
            } else {
                displayWidth = Client.mc.field_71443_c;
                displayHeight = Client.mc.field_71440_d;
            }
            int k = displayWidth * displayHeight;
            IntBuffer buffer = pixelBuffer;
            int[] pixel = pixelValues;
            if (buffer == null || pixel == null || buffer.capacity() < k || pixel.length < k) {
                pixelBuffer = buffer = BufferUtils.createIntBuffer((int)k);
                pixelValues = pixel = new int[k];
            }
            GL11.glPixelStorei((int)3333, (int)1);
            GL11.glPixelStorei((int)3317, (int)1);
            buffer.clear();
            if (fboEnabled) {
                GL11.glBindTexture((int)3553, (int)framebuffer.field_147617_g);
                GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)buffer);
            } else {
                GL11.glReadPixels((int)x, (int)(displayHeight - (h + y + 1)), (int)w, (int)h, (int)32993, (int)33639, (IntBuffer)buffer);
            }
            buffer.get(pixel);
            if (fboEnabled) {
                TextureUtil.func_147953_a((int[])pixel, (int)displayWidth, (int)displayHeight);
            } else {
                TextureUtil.func_147953_a((int[])pixel, (int)w, (int)h);
            }
            BufferedImage bufferedimage = null;
            if (fboEnabled) {
                bufferedimage = new BufferedImage(w, h, 1);
                int l = displayHeight - framebuffer.field_147618_d;
                for (int iy = 0; iy < h; ++iy) {
                    for (int ix = 0; ix < w; ++ix) {
                        bufferedimage.setRGB(ix, iy, pixel[(iy + l + y) * displayWidth + ix + x]);
                    }
                }
            } else {
                bufferedimage = new BufferedImage(w, h, 1);
                bufferedimage.setRGB(0, 0, w, h, pixel, 0, w);
            }
            return bufferedimage;
        }
        catch (Exception e) {
            Log.notice(I18n.func_135052_a((String)"signpic.gui.notice.screenshot.ingame.error", (Object[])new Object[]{e}));
            return null;
        }
    }

    @Nullable
    public static BufferedImage takeScreenshot(Framebuffer framebuffer) {
        return GuiIngameScreenShot.takeScreenshotRect(0, 0, Client.mc.field_71443_c, Client.mc.field_71440_d, framebuffer);
    }
}

