/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.gui;

import com.google.common.collect.Maps;
import com.kamesuta.mc.bnnwidget.WCommon;
import com.kamesuta.mc.bnnwidget.WEvent;
import com.kamesuta.mc.bnnwidget.WPanel;
import com.kamesuta.mc.bnnwidget.component.FontLabel;
import com.kamesuta.mc.bnnwidget.component.MButton;
import com.kamesuta.mc.bnnwidget.component.MNumber;
import com.kamesuta.mc.bnnwidget.font.WFont;
import com.kamesuta.mc.bnnwidget.motion.Easings;
import com.kamesuta.mc.bnnwidget.motion.Motion;
import com.kamesuta.mc.bnnwidget.position.Area;
import com.kamesuta.mc.bnnwidget.position.Coord;
import com.kamesuta.mc.bnnwidget.position.Point;
import com.kamesuta.mc.bnnwidget.position.R;
import com.kamesuta.mc.bnnwidget.var.V;
import com.kamesuta.mc.bnnwidget.var.VMotion;
import com.kamesuta.mc.signpic.attr.prop.RotationData;
import com.kamesuta.mc.signpic.gui.PropertyChangeEvent;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class GuiRotation
extends WPanel {
    @Nonnull
    protected RefRotation rotation;
    @Nonnull
    protected RotationEditor editor;
    @Nullable
    protected RotationPanel panel;

    public GuiRotation(@Nonnull R position, @Nonnull RefRotation rotation) {
        super(position);
        this.rotation = rotation;
        final VMotion left = V.pm(-1.0f).add(Easings.easeOutBack.move(0.25f, 0.0f)).start();
        this.editor = new RotationEditor(new R(Coord.left(left), Coord.top(0.0f), Coord.pwidth(1.0f), Coord.height(15.0f))){

            @Override
            public boolean onCloseRequest() {
                left.stop().add(Easings.easeInBack.move(0.25f, -1.0f));
                return false;
            }

            @Override
            public boolean onClosing(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point mouse) {
                return left.isFinished();
            }
        };
    }

    protected abstract void onUpdate();

    @Override
    protected void initWidget() {
        final VMotion label = V.pm(-1.0f).add(Easings.easeOutBack.move(0.25f, 0.0f)).start();
        this.add(new FontLabel(new R(Coord.left(label), Coord.pwidth(1.0f), Coord.top(0.0f), Coord.height(15.0f)), WFont.fontRenderer){

            @Override
            public boolean onCloseRequest() {
                label.stop().add(Easings.easeInBack.move(0.25f, -1.0f));
                return false;
            }

            @Override
            public boolean onClosing(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point mouse) {
                return label.isFinished();
            }
        }.setText(I18n.func_135052_a((String)"signpic.gui.editor.rotation.category", (Object[])new Object[0])));
        this.add(this.editor);
        this.panel = new RotationPanel(new R(Coord.left(0.0f), Coord.top(15.0f), Coord.right(0.0f), Coord.bottom(0.0f)));
        this.add(this.panel);
    }

    @SubscribeEvent
    public void onChanged(@Nullable PropertyChangeEvent ev) {
        if (this.panel != null) {
            this.remove(this.panel);
        }
        this.panel = new RotationPanel(new R(Coord.left(0.0f), Coord.top(15.0f), Coord.right(0.0f), Coord.bottom(0.0f)));
        this.add(this.panel);
    }

    @Override
    public void update(@Nonnull WEvent ev, @Nonnull Area pgp, Point p) {
        ev.bus.register((Object)this);
        super.update(ev, pgp, p);
    }

    protected void add(@Nonnull RotationData.RotationBuilder.ImageRotate rotate) {
        RotationPanel panel = this.panel;
        if (panel != null) {
            panel.add(rotate);
            panel.update();
        }
    }

    protected void remove() {
        RotationPanel panel = this.panel;
        if (panel != null) {
            panel.remove();
            panel.update();
        }
    }

    protected class RotationPanel
    extends WPanel {
        @Nonnull
        private final Map<RotationData.RotationBuilder.ImageRotate, RotationElement> map;

        public RotationPanel(R position) {
            super(position);
            this.map = Maps.newHashMap();
            RotationData.RotationBuilder rb = GuiRotation.this.rotation.rotation();
            ListIterator<RotationData.RotationBuilder.ImageRotate> itr = rb.rotates.listIterator();
            while (itr.hasNext()) {
                int n = itr.nextIndex();
                RotationData.RotationBuilder.ImageRotate rotate = itr.next();
                this.addWidget(rotate, n);
            }
        }

        @Override
        protected void initWidget() {
        }

        public void add(@Nonnull RotationData.RotationBuilder.ImageRotate rotate) {
            RotationData.RotationBuilder rb = GuiRotation.this.rotation.rotation();
            int n = rb.rotates.size();
            if (n < 3) {
                rb.rotates.add(rotate);
                this.addWidget(rotate, n);
            }
        }

        public void remove() {
            RotationData.RotationBuilder rb = GuiRotation.this.rotation.rotation();
            if (!rb.rotates.isEmpty()) {
                RotationData.RotationBuilder.ImageRotate rotate = rb.rotates.remove(rb.rotates.size() - 1);
                this.remove((WCommon)this.map.get(rotate));
            }
        }

        public void up(@Nonnull RotationData.RotationBuilder.ImageRotate rotate) {
            RotationData.RotationBuilder rb = GuiRotation.this.rotation.rotation();
            int i = rb.rotates.indexOf(rotate);
            if (i != -1 && i > 0) {
                RotationData.RotationBuilder.ImageRotate prev = rb.rotates.get(i - 1);
                rb.rotates.set(i, prev);
                rb.rotates.set(i - 1, rotate);
                this.update();
            }
        }

        public void down(@Nonnull RotationData.RotationBuilder.ImageRotate rotate) {
            RotationData.RotationBuilder rb = GuiRotation.this.rotation.rotation();
            int i = rb.rotates.indexOf(rotate);
            if (i != -1 && i < rb.rotates.size() - 1) {
                RotationData.RotationBuilder.ImageRotate next = rb.rotates.get(i + 1);
                rb.rotates.set(i, next);
                rb.rotates.set(i + 1, rotate);
                this.update();
            }
        }

        private void addWidget(@Nonnull RotationData.RotationBuilder.ImageRotate rotate, int n) {
            float t = n * 15;
            VMotion left = V.pm(-1.0f).add(Motion.blank(t / 15.0f * 0.025f)).add(Easings.easeOutBack.move(0.25f, 0.0f)).start();
            VMotion top = V.am(t);
            RotationElement element = new RotationElement(new R(Coord.left(left), Coord.top(top), Coord.pwidth(1.0f), Coord.height(15.0f)), left, top, rotate);
            this.map.put(rotate, element);
            this.add(element);
        }

        public void update() {
            RotationData.RotationBuilder rb = GuiRotation.this.rotation.rotation();
            int i = 0;
            for (RotationData.RotationBuilder.ImageRotate rotate : rb.rotates) {
                RotationElement element = this.map.get(rotate);
                element.top.stop().add(Easings.easeInCirc.move(0.25f, i++ * 15)).start();
            }
            GuiRotation.this.onUpdate();
        }

        protected class RotationElement
        extends WPanel {
            @Nonnull
            protected RotationData.RotationBuilder.ImageRotate rotate;
            @Nonnull
            protected VMotion left;
            @Nonnull
            protected VMotion top;

            public RotationElement(@Nonnull R position, @Nonnull VMotion left, @Nonnull VMotion top, RotationData.RotationBuilder.ImageRotate rotate) {
                super(position);
                this.left = left;
                this.top = top;
                this.rotate = rotate;
            }

            @Override
            protected void initWidget() {
                this.add(new Type(new R(Coord.left(0.0f), Coord.top(0.0f), Coord.width(15.0f), Coord.bottom(0.0f)), this.rotate));
                this.add(new MNumber(new R(Coord.left(15.0f), Coord.top(0.0f), Coord.right(30.0f), Coord.bottom(0.0f)), 15.0f){
                    {
                        if (RotationElement.this.rotate.rotate != 0.0f) {
                            this.setNumber(RotationElement.this.rotate.rotate);
                        }
                    }

                    @Override
                    protected void onNumberChanged(@Nonnull String oldText, @Nonnull String newText) {
                        if (NumberUtils.isCreatable((String)newText)) {
                            float f = NumberUtils.toFloat((String)newText);
                            RotationElement.this.rotate.rotate = GuiRotation.this.rotation.isFirst() ? (f % 8.0f + 8.0f) % 8.0f : f;
                        } else {
                            RotationElement.this.rotate.rotate = 0.0f;
                        }
                        if (this.initialized) {
                            GuiRotation.this.onUpdate();
                        }
                    }

                    @Override
                    protected boolean negClicked() {
                        boolean b = super.negClicked();
                        if (NumberUtils.toFloat((String)this.field.getText()) == 0.0f) {
                            this.field.setText("");
                        }
                        return b;
                    }

                    @Override
                    protected boolean posClicked() {
                        boolean b = super.posClicked();
                        if (NumberUtils.toFloat((String)this.field.getText()) == 0.0f) {
                            this.field.setText("");
                        }
                        return b;
                    }
                }.setNegLabel(I18n.func_135052_a((String)"signpic.gui.editor.rotation.neg", (Object[])new Object[0])).setPosLabel(I18n.func_135052_a((String)"signpic.gui.editor.rotation.pos", (Object[])new Object[0])).setUnknownLabel(I18n.func_135052_a((String)"signpic.gui.editor.rotation.unknown", (Object[])new Object[0])));
                this.add(new MButton(new R(Coord.right(15.0f), Coord.top(0.0f), Coord.width(15.0f), Coord.bottom(0.0f))){

                    @Override
                    protected boolean onClicked(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, int button) {
                        RotationPanel.this.up(RotationElement.this.rotate);
                        return true;
                    }
                }.setText(I18n.func_135052_a((String)"signpic.gui.editor.rotation.up", (Object[])new Object[0])));
                this.add(new MButton(new R(Coord.right(0.0f), Coord.top(0.0f), Coord.width(15.0f), Coord.bottom(0.0f))){

                    @Override
                    protected boolean onClicked(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, int button) {
                        RotationPanel.this.down(RotationElement.this.rotate);
                        return true;
                    }
                }.setText(I18n.func_135052_a((String)"signpic.gui.editor.rotation.down", (Object[])new Object[0])));
            }

            @Override
            public boolean onCloseRequest() {
                this.left.stop().add(Motion.blank(this.top.get() / 15.0f * 0.025f)).add(Easings.easeInBack.move(0.25f, -1.0f)).start();
                return false;
            }

            @Override
            public boolean onClosing(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p) {
                return this.left.isFinished();
            }

            protected class Type
            extends MButton {
                protected RotationData.RotationBuilder.ImageRotate rotate;

                public Type(@Nonnull R position, RotationData.RotationBuilder.ImageRotate rotate) {
                    super(position);
                    this.setText(rotate.type.name());
                    this.rotate = rotate;
                }

                @Override
                protected boolean onClicked(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, int button) {
                    this.next();
                    return true;
                }

                protected RotationData.RotateType nextType(@Nonnull RotationData.RotateType type) {
                    RotationData.RotateType[] rotateTypes = RotationData.RotateType.values();
                    if (rotateTypes.length > 0) {
                        RotationData.RotateType rotateType = rotateTypes[0];
                        boolean next = false;
                        for (RotationData.RotateType r : rotateTypes) {
                            if (next) {
                                rotateType = r;
                                break;
                            }
                            if (r != type) continue;
                            next = true;
                        }
                        type = rotateType;
                    }
                    return type;
                }

                protected void next() {
                    this.rotate.type = this.nextType(this.rotate.type);
                    GuiRotation.this.onUpdate();
                    this.setText(this.rotate.type.name());
                }

                @Nonnull
                public RotationData.RotateType getType() {
                    return this.rotate.type;
                }
            }
        }
    }

    protected class RotationEditor
    extends WPanel {
        public RotationEditor(R position) {
            super(position);
        }

        @Override
        protected void initWidget() {
            this.add(new MButton(new R(Coord.ptop(0.0f), Coord.right(15.0f), Coord.width(15.0f), Coord.pheight(1.0f))){

                @Override
                protected boolean onClicked(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, int button) {
                    GuiRotation.this.add(new RotationData.RotationBuilder.ImageRotate(RotationData.RotateType.X, 0.0f));
                    return true;
                }
            }.setText(I18n.func_135052_a((String)"signpic.gui.editor.rotation.add", (Object[])new Object[0])));
            this.add(new MButton(new R(Coord.ptop(0.0f), Coord.right(0.0f), Coord.width(15.0f), Coord.pheight(1.0f))){

                @Override
                protected boolean onClicked(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, int button) {
                    GuiRotation.this.remove();
                    return true;
                }
            }.setText(I18n.func_135052_a((String)"signpic.gui.editor.rotation.remove", (Object[])new Object[0])));
        }
    }

    public static interface RefRotation {
        @Nonnull
        public RotationData.RotationBuilder rotation();

        public boolean isFirst();
    }
}

