/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.gui;

import com.google.common.collect.Lists;
import com.kamesuta.mc.bnnwidget.WBase;
import com.kamesuta.mc.bnnwidget.WBox;
import com.kamesuta.mc.bnnwidget.WEvent;
import com.kamesuta.mc.bnnwidget.WPanel;
import com.kamesuta.mc.bnnwidget.component.FontLabel;
import com.kamesuta.mc.bnnwidget.component.FunnyButton;
import com.kamesuta.mc.bnnwidget.component.MButton;
import com.kamesuta.mc.bnnwidget.component.MCheckBox;
import com.kamesuta.mc.bnnwidget.component.MScaledLabel;
import com.kamesuta.mc.bnnwidget.component.MSelect;
import com.kamesuta.mc.bnnwidget.component.MSelectField;
import com.kamesuta.mc.bnnwidget.component.MSelectLabel;
import com.kamesuta.mc.bnnwidget.component.MTab;
import com.kamesuta.mc.bnnwidget.font.WFont;
import com.kamesuta.mc.bnnwidget.motion.Easings;
import com.kamesuta.mc.bnnwidget.motion.Motion;
import com.kamesuta.mc.bnnwidget.position.Area;
import com.kamesuta.mc.bnnwidget.position.Coord;
import com.kamesuta.mc.bnnwidget.position.Point;
import com.kamesuta.mc.bnnwidget.position.R;
import com.kamesuta.mc.bnnwidget.render.OpenGL;
import com.kamesuta.mc.bnnwidget.render.RenderOption;
import com.kamesuta.mc.bnnwidget.render.WRenderer;
import com.kamesuta.mc.bnnwidget.var.V;
import com.kamesuta.mc.bnnwidget.var.VBase;
import com.kamesuta.mc.bnnwidget.var.VCommon;
import com.kamesuta.mc.bnnwidget.var.VMotion;
import com.kamesuta.mc.signpic.Apis;
import com.kamesuta.mc.signpic.Client;
import com.kamesuta.mc.signpic.Config;
import com.kamesuta.mc.signpic.entry.content.ContentManager;
import com.kamesuta.mc.signpic.gui.OverlayFrame;
import com.kamesuta.mc.signpic.gui.config.ConfigGui;
import com.kamesuta.mc.signpic.information.Informations;
import com.kamesuta.mc.signpic.mode.CurrentMode;
import java.awt.Color;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import org.apache.commons.lang3.StringUtils;

public class GuiSettings
extends WPanel {
    @Nonnull
    public static final ResourceLocation settings = new ResourceLocation("signpic", "textures/gui/settings.png");
    @Nonnull
    public static final ResourceLocation update = new ResourceLocation("signpic", "textures/gui/update.png");
    protected boolean show = true;
    @Nonnull
    protected VMotion bottom = V.pm(0.0f);
    protected boolean closing;

    public void show() {
        this.bottom.stop().add(Motion.blank(0.25f).setAfter(new Runnable(){

            @Override
            public void run() {
                WRenderer.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)new SoundEvent(new ResourceLocation("signpic", "gui.show")), (float)1.0f));
            }
        })).add(Easings.easeOutQuad.move(0.7f, 1.0f)).start();
    }

    public void hide() {
        this.bottom.stop().add(Easings.easeOutBounce.move(0.7f, 0.0f)).start();
    }

    public GuiSettings(@Nonnull R area) {
        super(area);
    }

    @Override
    protected void initWidget() {
        final boolean isUpdateRequired = Informations.instance.isUpdateRequired() && Config.getConfig().informationUpdateGui.get() != false;
        final int updatepanelHeight = isUpdateRequired ? 40 : 0;
        float hitarea = 5.0f;
        this.add(new WPanel(new R(Coord.bottom(0.0f), Coord.height(122 + updatepanelHeight))){

            @Override
            protected void initWidget() {
                this.add(new WPanel(new R(Coord.bottom(V.per(V.combine(V.p(-1.0f), V.a(5.0f)), V.p(0.0f), GuiSettings.this.bottom)))){

                    @Override
                    public void update(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p) {
                        Area a = this.getGuiPosition(pgp);
                        boolean b = a.pointInside(p);
                        if (!GuiSettings.this.closing) {
                            if (b) {
                                if (!GuiSettings.this.show) {
                                    GuiSettings.this.show();
                                }
                                GuiSettings.this.show = true;
                            } else {
                                if (GuiSettings.this.show) {
                                    GuiSettings.this.hide();
                                }
                                GuiSettings.this.show = false;
                            }
                        }
                        super.update(ev, pgp, p);
                    }

                    @Override
                    public boolean onCloseRequest() {
                        GuiSettings.this.closing = true;
                        GuiSettings.this.bottom.stop().add(Easings.easeInBack.move(0.25f, 0.0f)).start();
                        return false;
                    }

                    @Override
                    public boolean onClosing(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p) {
                        return GuiSettings.this.bottom.isFinished();
                    }

                    @Override
                    public boolean mouseClicked(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, int button) {
                        Area a = this.getGuiPosition(pgp);
                        return super.mouseClicked(ev, pgp, p, button) || a.pointInside(p);
                    }

                    @Override
                    protected void initWidget() {
                        this.add(new WPanel(new R(Coord.top(5.0f), Coord.bottom(0.0f))){
                            protected R line;
                            {
                                this.line = new R(Coord.top(0.0f), Coord.top(2.0f));
                            }

                            @Override
                            public void draw(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, float frame, float opacity, @Nonnull RenderOption opt) {
                                Area a = this.getGuiPosition(pgp);
                                WRenderer.startShape();
                                OpenGL.glColor4f(0.0f, 0.0f, 0.0f, 0.6f);
                                1.draw(a);
                                OpenGL.glColor4f(0.0f, 0.3046875f, 0.60546875f, 1.0f);
                                1.draw(this.line.getAbsolute(a));
                                super.draw(ev, pgp, p, frame, opacity, opt);
                            }

                            @Override
                            protected void initWidget() {
                                this.add(new WBase(new R(Coord.top(5.0f), Coord.left(3.0f), Coord.width(90.0f), Coord.height(26.0f))){

                                    @Override
                                    public void draw(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, float frame, float opacity, @Nonnull RenderOption opt) {
                                        Area a = this.getGuiPosition(pgp);
                                        1.texture().func_110577_a(settings);
                                        OpenGL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                                        WRenderer.startTexture();
                                        1.drawTexture(a, null, null);
                                    }
                                });
                                MTab tab = new MTab(new R(Coord.left(5.0f), Coord.width(250.0f), Coord.top(33.0f), Coord.height(82.0f)), Coord.CoordSide.Left, 15.0f, 15.0f);
                                tab.addTab(I18n.func_135052_a((String)"signpic.gui.settings.api.upimage", (Object[])new Object[0]), new GuiApis<Apis.ImageUploaderFactory>(new R(new Coord[0]), Apis.instance.imageUploaders, I18n.func_135052_a((String)"signpic.gui.settings.api.upimage.desc", (Object[])new Object[0])));
                                tab.addTab(I18n.func_135052_a((String)"signpic.gui.settings.api.urlshortener", (Object[])new Object[0]), new GuiApis<Apis.URLShortenerFactory>(new R(new Coord[0]), Apis.instance.urlShorteners, I18n.func_135052_a((String)"signpic.gui.settings.api.urlshortener.desc", (Object[])new Object[0])));
                                this.add(tab);
                                this.add(new WPanel(new R(Coord.bottom(5 + updatepanelHeight + 80), Coord.right(5.0f), Coord.width(100.0f), Coord.height(15.0f))){

                                    @Override
                                    protected void initWidget() {
                                        this.add(new MCheckBox(new R(Coord.left(0.0f), Coord.width(15.0f))){
                                            {
                                                this.check(this.getConfig().get());
                                            }

                                            @Nonnull
                                            private Config.ConfigProperty<Boolean> getConfig() {
                                                return Config.getConfig().multiplayPAAS;
                                            }

                                            @Override
                                            protected void onCheckChanged(boolean oldCheck) {
                                                this.getConfig().set(this.isCheck());
                                            }
                                        });
                                        this.add(new FontLabel(new R(Coord.left(15.0f), Coord.right(0.0f)), WFont.fontRenderer).setText(I18n.func_135052_a((String)"signpic.gui.settings.paas", (Object[])new Object[0])));
                                    }
                                });
                                this.add(new FunnyButton(new R(Coord.bottom(5 + updatepanelHeight + 60), Coord.right(5.0f), Coord.width(100.0f), Coord.height(15.0f))){

                                    @Override
                                    protected boolean onClicked(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, int button) {
                                        CurrentMode.instance.toggleState(CurrentMode.State.HIDE);
                                        return true;
                                    }

                                    @Override
                                    public boolean isHighlight() {
                                        return CurrentMode.instance.isState(CurrentMode.State.HIDE);
                                    }
                                }.setText(I18n.func_135052_a((String)"signpic.gui.settings.hide", (Object[])new Object[0])));
                                this.add(new MButton(new R(Coord.bottom(5 + updatepanelHeight + 40), Coord.right(5.0f), Coord.width(100.0f), Coord.height(15.0f))){

                                    @Override
                                    protected boolean onClicked(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, int button) {
                                        ContentManager.instance.reloadAll();
                                        return true;
                                    }
                                }.setText(I18n.func_135052_a((String)"signpic.gui.settings.sign.reloadall", (Object[])new Object[0])));
                                this.add(new MButton(new R(Coord.bottom(5 + updatepanelHeight + 20), Coord.right(5.0f), Coord.width(100.0f), Coord.height(15.0f))){

                                    @Override
                                    protected boolean onClicked(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, int button) {
                                        ContentManager.instance.redownloadAll();
                                        OverlayFrame.instance.pane.task.show(2.0f);
                                        return true;
                                    }
                                }.setText(I18n.func_135052_a((String)"signpic.gui.settings.sign.redownloadall", (Object[])new Object[0])));
                                this.add(new MButton(new R(Coord.bottom(5 + updatepanelHeight), Coord.right(5.0f), Coord.width(100.0f), Coord.height(15.0f))){

                                    @Override
                                    protected boolean onClicked(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, int button) {
                                        Client.mc.func_147108_a((GuiScreen)new ConfigGui(ev.owner));
                                        return true;
                                    }
                                }.setText(I18n.func_135052_a((String)"signpic.gui.settings.config", (Object[])new Object[0])));
                                if (isUpdateRequired) {
                                    final VMotion state = V.pm(0.0f);
                                    final VBase vstart = V.a(32.0f);
                                    final VBase vend = V.a(37.0f);
                                    final VBase hstart = V.a(30.0f);
                                    final VBase hend = V.a(10.0f);
                                    this.add(new WPanel(new R(Coord.bottom(0.0f), Coord.height(updatepanelHeight))){

                                        @Override
                                        public void draw(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, float frame, float popacity, @Nonnull RenderOption opt) {
                                            Area a = this.getGuiPosition(pgp);
                                            OpenGL.glColor4f(0.0f, 0.0f, 0.0f, 0.4f);
                                            WRenderer.startShape();
                                            7.draw(a);
                                            super.draw(ev, pgp, p, frame, popacity, opt);
                                        }

                                        @Override
                                        protected void initWidget() {
                                            this.add(new WPanel(new R(Coord.left(V.per(hstart, hend, state)), Coord.right(V.per(hstart, hend, state)), Coord.height(V.per(vstart, vend, state)), Coord.ptop(0.5f)).child(Coord.ptop(-0.5f), Coord.pheight(1.0f))){
                                                protected boolean in;
                                                protected VMotion rot;
                                                protected float orot;
                                                {
                                                    this.rot = V.pm(0.0f).add(Easings.easeLinear.move(2.01f, 1.0f)).setLoop(true).start();
                                                    this.orot = 0.0f;
                                                }

                                                @Override
                                                public void update(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p) {
                                                    Area a = this.getGuiPosition(pgp);
                                                    if (a.pointInside(p)) {
                                                        if (!this.in) {
                                                            state.stop().add(Easings.easeOutCubic.move(1.0f, 1.0f)).start();
                                                            this.orot += this.rot.get();
                                                            this.rot.stopFirst().reset().add(Easings.easeLinear.move(2.01f, 1.0f));
                                                        }
                                                        this.in = true;
                                                    } else {
                                                        if (this.in) {
                                                            state.stop().add(Easings.easeOutCubic.move(1.0f, 0.0f)).start();
                                                            this.orot += this.rot.get();
                                                            this.rot.stopFirst().reset().add(Easings.easeOutSine.move(1.5f, 0.5f)).add(Motion.of(Motion.move(0.0f), Easings.easeInOutSine.move(2.87f, 1.0f), Motion.blank(0.58f)).setLoop(true));
                                                        }
                                                        this.in = false;
                                                    }
                                                    super.update(ev, pgp, p);
                                                }

                                                @Override
                                                public boolean mouseClicked(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, int button) {
                                                    Area a = this.getGuiPosition(pgp);
                                                    if (a.pointInside(p)) {
                                                        Informations.instance.runUpdate();
                                                        return true;
                                                    }
                                                    return false;
                                                }

                                                @Override
                                                protected void initWidget() {
                                                    this.add(new WBase(new R(Coord.width(V.per(vstart, vend, state)), Coord.pleft(0.5f)).child(Coord.pleft(-0.5f))){

                                                        @Override
                                                        public void draw(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, float frame, float opacity, @Nonnull RenderOption opt) {
                                                            Area a = this.getGuiPosition(pgp);
                                                            1.texture().func_110577_a(update);
                                                            float f = state.get();
                                                            OpenGL.glColor4f(256.0f * (1.0f - f) / 256.0f + 144.0f * f / 256.0f, 256.0f * (1.0f - f) / 256.0f + 191.0f * f / 256.0f, 256.0f * (1.0f - f) / 256.0f + 48.0f * f / 256.0f, 1.0f);
                                                            WRenderer.startTexture();
                                                            OpenGL.glPushMatrix();
                                                            OpenGL.glTranslatef(a.x1() + a.w() / 2.0f, a.y1() + a.h() / 2.0f, 0.0f);
                                                            OpenGL.glRotatef((orot + rot.get()) * 360.0f, 0.0f, 0.0f, 1.0f);
                                                            OpenGL.glTranslatef(-a.x1() - a.w() / 2.0f, -a.y1() - a.h() / 2.0f, 0.0f);
                                                            1.drawTexture(a, null, null);
                                                            OpenGL.glPopMatrix();
                                                        }
                                                    });
                                                    final VMotion o = V.pm(0.0f).add(Easings.easeLinear.move(0.8f, 1.0f)).add(Motion.blank(2.0f)).add(Easings.easeLinear.move(0.8f, 0.0f)).add(Motion.blank(2.0f)).setLoop(true).start();
                                                    String message = I18n.func_135052_a((String)"signpic.gui.update.message", (Object[])new Object[0]);
                                                    String update = Informations.instance.getUpdateMessage();
                                                    this.add(new MScaledLabel(new R(Coord.pheight(0.4f), Coord.ptop(0.5f)).child(Coord.ptop(-0.5f), Coord.pheight(1.0f))){

                                                        @Override
                                                        @Nonnull
                                                        protected VCommon initOpacity() {
                                                            return o;
                                                        }

                                                        @Override
                                                        public int getColor() {
                                                            float f = state.get();
                                                            return new Color(256.0f * (1.0f - f) / 256.0f + 144.0f * f / 256.0f, 256.0f * (1.0f - f) / 256.0f + 191.0f * f / 256.0f, 256.0f * (1.0f - f) / 256.0f + 48.0f * f / 256.0f).getRGB();
                                                        }

                                                        @Override
                                                        public void draw(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, float frame, float popacity, @Nonnull RenderOption opt) {
                                                            OpenGL.glPushMatrix();
                                                            OpenGL.glTranslatef(0.0f, 0.0f, 10.0f);
                                                            super.draw(ev, pgp, p, frame, popacity, opt);
                                                            OpenGL.glPopMatrix();
                                                        }
                                                    }.setShadow(true).setText(message));
                                                    this.add(new MScaledLabel(new R(Coord.pheight(0.4f), Coord.ptop(0.5f)).child(Coord.ptop(-0.5f), Coord.pheight(1.0f))){

                                                        @Override
                                                        @Nonnull
                                                        protected VCommon initOpacity() {
                                                            return V.per(V.p(1.0f), V.p(0.0f), o);
                                                        }

                                                        @Override
                                                        public int getColor() {
                                                            float f = state.get();
                                                            return new Color(256.0f * (1.0f - f) / 256.0f + 144.0f * f / 256.0f, 256.0f * (1.0f - f) / 256.0f + 191.0f * f / 256.0f, 256.0f * (1.0f - f) / 256.0f + 48.0f * f / 256.0f).getRGB();
                                                        }

                                                        @Override
                                                        public void draw(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, float frame, float popacity, @Nonnull RenderOption opt) {
                                                            OpenGL.glPushMatrix();
                                                            OpenGL.glTranslatef(0.0f, 0.0f, 10.0f);
                                                            super.draw(ev, pgp, p, frame, popacity, opt);
                                                            OpenGL.glPopMatrix();
                                                        }
                                                    }.setShadow(true).setText(!StringUtils.isEmpty((CharSequence)update) ? I18n.func_135052_a((String)"signpic.gui.update.message.changelog", (Object[])new Object[]{update}) : message));
                                                }
                                            });
                                        }
                                    });
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    static class Key
    extends WPanel {
        @Nonnull
        protected Apis.Setting setting;

        public Key(@Nonnull R position, @Nonnull Apis.Setting setting) {
            super(position);
            this.setting = setting;
        }

        @Override
        public void draw(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, float frame, float opacity, @Nonnull RenderOption opt) {
            Area a = this.getGuiPosition(pgp);
            WRenderer.startShape();
            OpenGL.glColor4f(0.0f, 0.0f, 0.0f, 0.2f);
            OpenGL.glLineWidth(0.5f);
            Key.draw(a, 2);
            super.draw(ev, pgp, p, frame, opacity, opt);
        }

        @Override
        protected void initWidget() {
            this.add(new FontLabel(new R(Coord.left(1.0f), Coord.right(1.0f), Coord.top(1.0f), Coord.height(15.0f)), WFont.fontRenderer).setText(I18n.func_135052_a((String)"signpic.gui.settings.api.key", (Object[])new Object[0])));
            this.add(new MSelectField(new R(Coord.left(1.0f), Coord.right(1.0f), Coord.top(16.0f), Coord.height(15.0f)), 15.0f){

                @Override
                protected void initWidget() {
                    this.setSelector(new MSelect.StringSelector(){
                        {
                            ArrayList settings = Lists.newArrayList((Object[])new String[]{""});
                            settings.addAll(setting.getSettings());
                            this.setList(settings);
                        }
                    });
                    this.field.setWatermark(I18n.func_135052_a((String)"signpic.gui.settings.default", (Object[])new Object[0]));
                    this.field.setMaxStringLength(256);
                    this.setText(setting.getConfig());
                }

                @Override
                protected void onChanged(@Nonnull String oldText, @Nonnull String newText) {
                    if (!StringUtils.equals((CharSequence)oldText, (CharSequence)newText) && !StringUtils.equals((CharSequence)newText, (CharSequence)setting.getConfig())) {
                        setting.setConfig(newText);
                    }
                }
            });
        }
    }

    static class GuiApis<E extends Apis.ApiFactory>
    extends WPanel {
        @Nonnull
        protected Apis.MapSetting<E> typesetting;
        @Nonnull
        protected String title;
        protected WBox box = new WBox(new R(Coord.left(1.0f), Coord.right(1.0f), Coord.top(49.0f), Coord.height(32.0f))){

            @Override
            protected void initWidget() {
                Apis.ApiFactory factory = (Apis.ApiFactory)typesetting.solve(typesetting.getConfig());
                if (factory != null) {
                    box.set(new Key(new R(new Coord[0]), factory.keySettings()));
                } else {
                    box.set(null);
                }
            }
        };

        public GuiApis(@Nonnull R position, @Nonnull Apis.MapSetting<E> typesetting, @Nonnull String title) {
            super(position);
            this.typesetting = typesetting;
            this.title = title;
        }

        @Override
        public void draw(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, float frame, float opacity, @Nonnull RenderOption opt) {
            Area a = this.getGuiPosition(pgp);
            WRenderer.startShape();
            OpenGL.glColor4f(0.0f, 0.0f, 0.0f, 0.2f);
            OpenGL.glLineWidth(0.5f);
            GuiApis.draw(a, 2);
            super.draw(ev, pgp, p, frame, opacity, opt);
        }

        @Override
        protected void initWidget() {
            float top = 1.0f;
            this.add(new FontLabel(new R(Coord.left(1.0f), Coord.right(1.0f), Coord.top(top), Coord.height(15.0f)), WFont.fontRenderer).setText(this.title));
            this.add(new WPanel(new R(Coord.left(1.0f), Coord.right(1.0f), Coord.top(top += 15.0f), Coord.height(32.0f))){

                @Override
                public void draw(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, float frame, float opacity, @Nonnull RenderOption opt) {
                    Area a = this.getGuiPosition(pgp);
                    WRenderer.startShape();
                    OpenGL.glColor4f(0.0f, 0.0f, 0.0f, 0.2f);
                    OpenGL.glLineWidth(0.5f);
                    2.draw(a, 2);
                    super.draw(ev, pgp, p, frame, opacity, opt);
                }

                @Override
                protected void initWidget() {
                    this.add(new FontLabel(new R(Coord.left(1.0f), Coord.right(1.0f), Coord.top(1.0f), Coord.height(15.0f)), WFont.fontRenderer).setText(I18n.func_135052_a((String)"signpic.gui.settings.api.type", (Object[])new Object[0])));
                    this.add(new MSelectLabel(new R(Coord.left(1.0f), Coord.right(1.0f), Coord.top(16.0f), Coord.height(15.0f)), 15.0f){

                        @Override
                        protected void initWidget() {
                            this.setSelector(new MSelect.StringSelector(){
                                {
                                    ArrayList settings = Lists.newArrayList((Object[])new String[]{""});
                                    settings.addAll(typesetting.getSettings());
                                    this.setList(settings);
                                }
                            });
                            this.field.setWatermark(I18n.func_135052_a((String)"signpic.gui.settings.default", (Object[])new Object[0]));
                            this.setText(typesetting.getConfig());
                        }

                        @Override
                        protected void onChanged(@Nonnull String oldText, @Nonnull String newText) {
                            if (!StringUtils.equals((CharSequence)oldText, (CharSequence)newText)) {
                                Apis.ApiFactory factory;
                                if (!StringUtils.equals((CharSequence)newText, (CharSequence)typesetting.getConfig())) {
                                    typesetting.setConfig(newText);
                                }
                                if ((factory = (Apis.ApiFactory)typesetting.solve(newText)) != null) {
                                    box.set(new Key(new R(new Coord[0]), factory.keySettings()));
                                } else {
                                    box.set(null);
                                }
                            }
                        }
                    });
                }
            });
            this.add(this.box);
        }
    }
}

