/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.gui;

import com.kamesuta.mc.bnnwidget.WFrame;
import com.kamesuta.mc.bnnwidget.motion.Easings;
import com.kamesuta.mc.bnnwidget.motion.Motion;
import com.kamesuta.mc.bnnwidget.var.V;
import com.kamesuta.mc.bnnwidget.var.VMotion;
import com.kamesuta.mc.signpic.Client;
import com.kamesuta.mc.signpic.Log;
import com.kamesuta.mc.signpic.http.upload.UploadCallback;
import com.kamesuta.mc.signpic.mode.CurrentMode;
import com.kamesuta.mc.signpic.util.FileUtilitiy;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class GuiWindowScreenShot
extends WFrame {
    public static final Color windowcolor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Color bgcolor = new Color(0.0f, 0.0f, 0.0f, 0.25f);
    public static final Color textcolor = new Color(1.0f, 1.0f, 1.0f, 0.6f);
    public static final Color textshadowcolor = new Color(0.0f, 0.0f, 0.0f, 0.6f);
    @Nullable
    private Window window;
    @Nullable
    private Point point1;
    @Nullable
    private Point point2;
    private boolean takescreenshot;

    public GuiWindowScreenShot(@Nullable GuiScreen parent) {
        super(parent);
        this.setGuiPauseGame(false);
    }

    public GuiWindowScreenShot() {
        this.setGuiPauseGame(false);
    }

    @Override
    public void func_146281_b() {
        this.destroy();
        super.func_146281_b();
    }

    public void destroy() {
        final Window frame = this.window;
        if (frame != null) {
            this.window = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.dispose();
                }
            });
        }
        this.requestClose();
    }

    @Nullable
    public Rectangle getSelectedRect() {
        Point point1 = this.point1;
        Point point2 = this.point2;
        if (point1 != null && point2 != null) {
            int x1 = Math.min(point1.x, point2.x);
            int y1 = Math.min(point1.y, point2.y);
            int x2 = Math.max(point1.x, point2.x);
            int y2 = Math.max(point1.y, point2.y);
            return new Rectangle(x1, y1, x2 - x1, y2 - y1);
        }
        return null;
    }

    @Override
    public void func_73863_a(int mousex, int mousey, float f) {
        if (this.window != null) {
            this.window.repaint();
        }
        super.func_73863_a(mousex, mousey, f);
    }

    @Override
    protected void initWidget() {
        if (this.window == null) {
            try {
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice[] screens = ge.getScreenDevices();
                Rectangle rect0 = null;
                GraphicsDevice screen0 = null;
                GraphicsConfiguration config0 = null;
                for (GraphicsDevice screen : screens) {
                    GraphicsConfiguration config = screen.getDefaultConfiguration();
                    if (screen0 == null) {
                        screen0 = screen;
                    }
                    if (config0 == null) {
                        config0 = config;
                    }
                    if (rect0 == null) {
                        rect0 = config.getBounds();
                        continue;
                    }
                    rect0.add(config.getBounds());
                }
                final Rectangle rect = rect0;
                if (screen0 != null && rect != null) {
                    final GraphicsDevice screen = screen0;
                    JDialog window = new JDialog();
                    this.window = window;
                    window.setTitle("SignPicture");
                    window.setUndecorated(true);
                    window.setBackground(windowcolor);
                    window.setDefaultCloseOperation(0);
                    window.setAlwaysOnTop(true);
                    window.setCursor(Cursor.getPredefinedCursor(1));
                    window.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(@Nullable WindowEvent e) {
                            GuiWindowScreenShot.this.destroy();
                        }
                    });
                    window.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyPressed(@Nullable KeyEvent e) {
                            if (e != null && e.getKeyCode() == 27) {
                                GuiWindowScreenShot.this.destroy();
                            }
                        }
                    });
                    window.setBounds(rect0);
                    JPanel panel = new JPanel(){
                        private boolean takingscreenshot;
                        private boolean disable;
                        private boolean flushing;
                        @Nonnull
                        private VMotion opacity = V.pm(0.0f).start();

                        @Override
                        protected void paintComponent(@Nullable Graphics g) {
                            boolean continuemode = CurrentMode.instance.isState(CurrentMode.State.CONTINUE);
                            if (this.flushing) {
                                if (g != null && g instanceof Graphics2D) {
                                    Graphics2D g2 = (Graphics2D)g;
                                    if (continuemode) {
                                        g2.setColor(bgcolor);
                                        g2.fill(rect);
                                    }
                                    g.setColor(new Color(1.0f, 1.0f, 1.0f, this.opacity.get()));
                                    Rectangle in = GuiWindowScreenShot.this.getSelectedRect();
                                    g2.fill(in);
                                }
                                if (this.opacity.isFinished()) {
                                    if (!continuemode) {
                                        GuiWindowScreenShot.this.destroy();
                                    }
                                    this.flushing = false;
                                    GuiWindowScreenShot.this.point1 = null;
                                    GuiWindowScreenShot.this.point2 = null;
                                }
                            } else if (this.takingscreenshot) {
                                this.takingscreenshot = false;
                                Rectangle in = GuiWindowScreenShot.this.getSelectedRect();
                                if (in != null) {
                                    BufferedImage image = GuiWindowScreenShot.takeScreenshotRect(screen, in);
                                    if (image != null) {
                                        try {
                                            FileUtilitiy.uploadImage(image, UploadCallback.copyOnDone);
                                        }
                                        catch (IOException ex) {
                                            Log.notice(I18n.func_135052_a((String)"signpic.gui.notice.screenshot.window.capture.error", (Object[])new Object[]{ex}));
                                        }
                                    }
                                    Client.playSound(new ResourceLocation("signpic", "gui.screenshot"), 1.0f);
                                    this.opacity.stop().add(Motion.move(0.25f)).add(Easings.easeLinear.move(0.5f, 0.0f));
                                    this.flushing = true;
                                    if (!continuemode) {
                                        this.disable = true;
                                    }
                                }
                            } else if (GuiWindowScreenShot.this.takescreenshot) {
                                GuiWindowScreenShot.this.takescreenshot = false;
                                this.takingscreenshot = true;
                            } else if (!this.disable && g != null && g instanceof Graphics2D) {
                                Graphics2D g2 = (Graphics2D)g;
                                Area area = new Area(rect);
                                Rectangle in = GuiWindowScreenShot.this.getSelectedRect();
                                if (in != null) {
                                    area.subtract(new Area(in));
                                    int x = in.x + in.width;
                                    int y = in.y + in.height;
                                    g2.setColor(textshadowcolor);
                                    g2.drawString(String.valueOf(in.width), x - 30 + 2, y - 20 + 2);
                                    g2.drawString(String.valueOf(in.height), x - 30 + 2, y - 10 + 2);
                                    g2.setColor(textcolor);
                                    g2.drawString(String.valueOf(in.width), x - 30, y - 20);
                                    g2.drawString(String.valueOf(in.height), x - 30, y - 10);
                                }
                                g2.setColor(bgcolor);
                                g2.fill(area);
                            }
                        }
                    };
                    MouseAdapter mouse = new MouseAdapter(){

                        @Override
                        public void mousePressed(@Nullable MouseEvent e) {
                            if (e != null) {
                                if (GuiWindowScreenShot.this.point1 == null) {
                                    GuiWindowScreenShot.this.point1 = e.getPoint();
                                } else {
                                    this.checkAndTake();
                                }
                            }
                            super.mousePressed(e);
                        }

                        @Override
                        public void mouseReleased(@Nullable MouseEvent e) {
                            if (e != null) {
                                GuiWindowScreenShot.this.point2 = e.getPoint();
                                this.checkAndTake();
                            }
                            super.mouseReleased(e);
                        }

                        @Override
                        public void mouseMoved(@Nullable MouseEvent e) {
                            if (e != null) {
                                this.mouseUpdate(e.getPoint());
                            }
                            super.mouseMoved(e);
                        }

                        @Override
                        public void mouseDragged(@Nullable MouseEvent e) {
                            if (e != null) {
                                this.mouseUpdate(e.getPoint());
                            }
                            super.mouseDragged(e);
                        }

                        private void mouseUpdate(@Nullable Point p) {
                            GuiWindowScreenShot.this.point2 = p;
                        }

                        private void checkAndTake() {
                            Point p1 = GuiWindowScreenShot.this.point1;
                            Point p2 = GuiWindowScreenShot.this.point2;
                            if (p1 != null && p2 != null && p1.x != p2.x && p1.y != p2.y) {
                                GuiWindowScreenShot.this.takescreenshot = true;
                            }
                        }
                    };
                    panel.addMouseListener(mouse);
                    panel.addMouseMotionListener(mouse);
                    window.setContentPane(panel);
                    window.setVisible(true);
                }
            }
            catch (Exception e) {
                Log.notice(I18n.func_135052_a((String)"signpic.gui.notice.screenshot.window.error", (Object[])new Object[]{e}));
                this.destroy();
            }
        }
    }

    @Nullable
    public static BufferedImage takeScreenshotRect(GraphicsDevice device, Rectangle rect) {
        if (rect.isEmpty()) {
            return null;
        }
        try {
            Robot robot = new Robot(device);
            return robot.createScreenCapture(rect);
        }
        catch (Exception e) {
            Log.notice(I18n.func_135052_a((String)"signpic.gui.notice.screenshot.window.error", (Object[])new Object[]{e}));
            return null;
        }
    }
}

