/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.gui;

import com.kamesuta.mc.bnnwidget.WBase;
import com.kamesuta.mc.bnnwidget.WEvent;
import com.kamesuta.mc.bnnwidget.position.Area;
import com.kamesuta.mc.bnnwidget.position.Point;
import com.kamesuta.mc.bnnwidget.position.R;
import com.kamesuta.mc.bnnwidget.render.OpenGL;
import com.kamesuta.mc.bnnwidget.render.RenderOption;
import com.kamesuta.mc.bnnwidget.render.WRenderer;
import com.kamesuta.mc.signpic.attr.AttrReaders;
import com.kamesuta.mc.signpic.attr.prop.SizeData;
import com.kamesuta.mc.signpic.entry.Entry;
import com.kamesuta.mc.signpic.entry.EntryId;
import com.kamesuta.mc.signpic.entry.EntryIdBuilder;
import com.kamesuta.mc.signpic.entry.content.Content;
import com.kamesuta.mc.signpic.entry.content.ContentManager;
import com.kamesuta.mc.signpic.information.Informations;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public class SignPicLabel
extends WBase {
    @Nonnull
    public static final ResourceLocation defaultTexture = new ResourceLocation("signpic", "textures/logo.png");
    @Nullable
    protected EntryId entryId;
    @Nonnull
    protected ContentManager manager;
    @Nullable
    protected EntryId update;

    public SignPicLabel(@Nonnull R position, @Nonnull ContentManager manager) {
        super(position);
        String image;
        this.manager = manager;
        if (Informations.instance.isUpdateRequired() && (image = Informations.instance.getUpdateImage()) != null) {
            EntryIdBuilder eidb = new EntryIdBuilder();
            eidb.setURI(image);
            this.update = eidb.build();
        }
    }

    @Override
    public void draw(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, float frame, float popacity, @Nonnull RenderOption opt) {
        Area a = this.getGuiPosition(pgp);
        float opacity = this.getGuiOpacity(popacity);
        EntryId entryId = this.getEntryId();
        if (entryId != null) {
            Entry entry = entryId.entry();
            Content content = null;
            if (entry.isValid() && (content = entry.getContent()) != null) {
                Entry upentry = null;
                if (this.update != null) {
                    upentry = this.update.entry();
                }
                if (!StringUtils.isEmpty((CharSequence)content.id.getID())) {
                    SignPicLabel.drawEntry(a, opacity, entry, opt);
                } else if (upentry != null && upentry.isValid()) {
                    SignPicLabel.drawEntry(a, opacity, upentry, opt);
                } else {
                    WRenderer.startTexture();
                    OpenGL.glColor4f(1.0f, 1.0f, 1.0f, 0.2f);
                    SignPicLabel.texture().func_110577_a(defaultTexture);
                    SizeData size1 = SizeData.ImageSizes.INNER.defineSize(SizeData.create(1.0f, 1.0f), SizeData.create(a));
                    SignPicLabel.drawTexture(Area.abs(a.x1() + a.w() / 2.0f - size1.getWidth() / 2.0f, a.y1() + a.h() / 2.0f - size1.getHeight() / 2.0f, a.x1() + a.w() / 2.0f + size1.getWidth() / 2.0f, a.y1() + a.h() / 2.0f + size1.getHeight() / 2.0f), null, null);
                }
            }
        }
    }

    public static void drawEntry(@Nonnull Area a, float opacity, @Nonnull Entry entry, @Nonnull RenderOption opt) {
        OpenGL.glDisable(2884);
        OpenGL.glPushMatrix();
        AttrReaders attr = entry.getMeta();
        Content content = entry.getContent();
        SizeData size00 = attr.sizes.getMovie().get();
        SizeData size01 = content != null ? content.image.getSize() : SizeData.DefaultSize;
        SizeData size1 = size00.aspectSize(size01);
        SizeData size2 = SizeData.ImageSizes.INNER.defineSize(size1, SizeData.create(a));
        SizeData size = size2.scale(0.01f);
        OpenGL.glTranslatef(a.x1(), a.y1(), 0.0f);
        OpenGL.glTranslatef((a.w() - size2.getWidth()) / 2.0f, (a.h() - size2.getHeight()) / 2.0f, 0.0f);
        OpenGL.glScalef(size.getWidth() < 0.0f ? -1.0f : 1.0f, size.getHeight() < 0.0f ? -1.0f : 1.0f, 1.0f);
        OpenGL.glScalef(100.0f, 100.0f, 1.0f);
        entry.getGui().drawScreen(0, 0, 0.0f, opacity, size.getWidth(), size.getHeight(), opt);
        OpenGL.glPopMatrix();
        OpenGL.glEnable(2884);
    }

    @Nullable
    public EntryId getEntryId() {
        return this.entryId;
    }

    @Nonnull
    public SignPicLabel setEntryId(@Nullable EntryId entryId) {
        this.entryId = entryId;
        return this;
    }
}

