/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.gui.file;

import com.kamesuta.mc.signpic.Client;
import com.kamesuta.mc.signpic.gui.file.UiUpload;
import com.kamesuta.mc.signpic.http.upload.UploadApiUtil;
import com.kamesuta.mc.signpic.http.upload.UploadCallback;
import com.kamesuta.mc.signpic.http.upload.UploadRequest;
import com.kamesuta.mc.signpic.mode.CurrentMode;
import com.kamesuta.mc.signpic.state.State;
import com.kamesuta.mc.signpic.util.FileUtilitiy;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class McUiUpload
extends UiUpload {
    @Nonnull
    public static final McUiUpload instance = new McUiUpload();

    @Override
    protected void initialize() {
        super.initialize();
        if (this.frame != null) {
            this.frame.setAlwaysOnTop(true);
        }
    }

    @Override
    @Nullable
    protected BufferedImage getImage(@Nonnull String path) {
        try {
            return ImageIO.read(Client.mc.func_110442_L().func_110536_a(new ResourceLocation("signpic", path)).func_110527_b());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    @Nonnull
    protected String getString(@Nonnull String id) {
        return I18n.func_135052_a((String)id, (Object[])new Object[0]);
    }

    @Override
    protected void transfer(@Nonnull Transferable transferable) {
        if (FileUtilitiy.transfer(transferable, UploadCallback.copyOnDone) && !CurrentMode.instance.isState(CurrentMode.State.CONTINUE)) {
            this.close();
        }
    }

    @Override
    protected void apply(@Nonnull File f) {
        if (UploadApiUtil.upload(UploadRequest.fromFile(f, new State()), UploadCallback.copyOnDone) && !CurrentMode.instance.isState(CurrentMode.State.CONTINUE)) {
            this.close();
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            this.requestOpen();
        } else {
            this.requestClose();
        }
    }
}

