/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.gui.file;

import com.kamesuta.mc.signpic.gui.file.UiImage;
import com.kamesuta.mc.signpic.lib.ComponentMover;
import com.kamesuta.mc.signpic.lib.ComponentResizer;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.border.AbstractBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public abstract class UiUpload {
    @Nullable
    protected JDialog frame;
    private boolean initialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        UiUpload uiUpload = this;
        synchronized (uiUpload) {
            if (!this.initialized) {
                this.initialize();
            }
            this.initialized = true;
        }
    }

    protected void initialize() {
        final JDialog frame = this.frame = new JDialog();
        frame.setTitle(this.getString("signpic.ui.title"));
        frame.setDefaultCloseOperation(0);
        frame.setUndecorated(true);
        JPanel base = new JPanel();
        frame.getContentPane().add((Component)base, "Center");
        base.setLayout(new BorderLayout(0, 0));
        JPanel title = new JPanel();
        title.setBackground(new Color(45, 45, 45));
        base.add((Component)title, "North");
        UiImage close = new UiImage();
        close.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@Nullable MouseEvent e) {
                UiUpload.this.requestClose();
            }
        });
        close.setImage(this.getImage("textures/ui/close.png"));
        UiImage icon = new UiImage();
        icon.setImage(this.getImage("textures/logo.png"));
        JLabel lbltitle = new JLabel(this.getString("signpic.ui.title"));
        lbltitle.setForeground(new Color(154, 202, 71));
        lbltitle.setFont(new Font("Dialog", 1, 30));
        JLabel lbldescription = new JLabel(this.getString("signpic.ui.description"));
        lbldescription.setFont(new Font("Dialog", 0, 12));
        lbldescription.setForeground(new Color(0, 255, 255));
        GroupLayout gl_title = new GroupLayout(title);
        gl_title.setHorizontalGroup(gl_title.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_title.createSequentialGroup().addGap(12).addComponent(icon, -2, 64, -2).addGroup(gl_title.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_title.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_title.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 206, Short.MAX_VALUE).addGap(4).addComponent(close, -2, 16, -2).addGap(4)).addGroup(gl_title.createSequentialGroup().addComponent(lbltitle).addGap(16))).addGroup(gl_title.createSequentialGroup().addGap(16).addComponent(lbldescription)))));
        gl_title.setVerticalGroup(gl_title.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_title.createSequentialGroup().addGap(4).addGroup(gl_title.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(close, -2, 16, -2)).addGroup(gl_title.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_title.createSequentialGroup().addComponent(lbltitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lbldescription)).addComponent(icon, -2, 64, -2)).addContainerGap(20, Short.MAX_VALUE)));
        title.setLayout(gl_title);
        JPanel drop = new JPanel();
        drop.setBorder(new LineBorder(new Color(45, 45, 45)));
        drop.setBackground(new Color(255, 255, 255));
        drop.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(@Nullable DropTargetDropEvent evt) {
                if (evt != null) {
                    try {
                        evt.acceptDrop(1);
                        Transferable transferable = evt.getTransferable();
                        if (transferable != null) {
                            UiUpload.this.transfer(transferable);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        base.add((Component)drop, "Center");
        JPanel droparea = new JPanel();
        droparea.setBackground(new Color(255, 255, 255));
        droparea.setBorder(new DashedBorder());
        GroupLayout gl_drop = new GroupLayout(drop);
        gl_drop.setHorizontalGroup(gl_drop.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_drop.createSequentialGroup().addContainerGap().addComponent(droparea, -1, 16, Short.MAX_VALUE).addContainerGap()));
        gl_drop.setVerticalGroup(gl_drop.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_drop.createSequentialGroup().addContainerGap().addComponent(droparea, -1, 16, Short.MAX_VALUE).addContainerGap()));
        droparea.setLayout(new BoxLayout(droparea, 1));
        Component glue1 = Box.createVerticalGlue();
        droparea.add(glue1);
        Component verticalStrut_2 = Box.createVerticalStrut(15);
        droparea.add(verticalStrut_2);
        JLabel lblimagehere = new JLabel(this.getString("signpic.ui.drop"));
        droparea.add(lblimagehere);
        lblimagehere.setAlignmentX(0.5f);
        lblimagehere.setFont(new Font("Dialog", 0, 25));
        final JButton btnselect = new JButton(this.getString("signpic.ui.select"));
        btnselect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@Nullable ActionEvent ev) {
                FileDialog fileDialog = new FileDialog((Dialog)frame, UiUpload.this.getString("signpic.ui.title.file"), 0);
                fileDialog.setVisible(true);
                String dir = fileDialog.getDirectory();
                String name = fileDialog.getFile();
                if (dir != null && name != null) {
                    UiUpload.this.apply(new File(dir, name));
                }
            }
        });
        btnselect.setForeground(Color.BLACK);
        btnselect.setBackground(Color.WHITE);
        LineBorder line = new LineBorder(Color.BLACK);
        EmptyBorder margin = new EmptyBorder(5, 15, 5, 15);
        CompoundBorder compound = new CompoundBorder(line, margin);
        btnselect.setBorder(compound);
        btnselect.setFocusPainted(false);
        btnselect.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(@Nullable MouseEvent evt) {
                btnselect.setBackground(Color.CYAN);
            }

            @Override
            public void mouseExited(@Nullable MouseEvent evt) {
                btnselect.setBackground(Color.WHITE);
            }
        });
        btnselect.setAlignmentX(0.5f);
        droparea.add(btnselect);
        Component verticalStrut_1 = Box.createVerticalStrut(20);
        droparea.add(verticalStrut_1);
        Component glue2 = Box.createVerticalGlue();
        droparea.add(glue2);
        drop.setLayout(gl_drop);
        frame.pack();
        Dimension minsize = new Dimension(frame.getSize());
        frame.setMinimumSize(minsize);
        ComponentResizer cr = new ComponentResizer();
        cr.registerComponent(frame);
        cr.setMinimumSize(minsize);
        cr.setEdgeInsets(null);
        ComponentMover cm = new ComponentMover(frame, new Component[0]);
        cm.registerComponent(title);
        cm.setChangeCursor(false);
        cm.setEdgeInsets(null);
        frame.setSize(400, 400);
        frame.setLocationRelativeTo(null);
    }

    @Nullable
    protected abstract BufferedImage getImage(@Nonnull String var1);

    @Nonnull
    protected abstract String getString(@Nonnull String var1);

    protected void requestOpen() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                UiUpload.this.open();
            }
        });
    }

    protected void open() {
        this.init();
        if (this.frame != null) {
            this.frame.setVisible(true);
        }
    }

    protected void requestClose() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                UiUpload.this.close();
            }
        });
    }

    protected void close() {
        if (this.frame != null) {
            this.frame.setVisible(false);
        }
    }

    public boolean isVisible() {
        if (this.frame != null && this.initialized) {
            return this.frame.isVisible();
        }
        return false;
    }

    protected abstract void transfer(@Nonnull Transferable var1);

    protected abstract void apply(@Nonnull File var1);

    static class DashedBorder
    extends AbstractBorder {
        DashedBorder() {
        }

        @Override
        public void paintBorder(@Nullable Component comp, @Nullable Graphics g, int x, int y, int w, int h) {
            if (g != null) {
                Graphics2D gg = (Graphics2D)g.create();
                gg.setColor(Color.GRAY);
                gg.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{6.0f}, 0.0f));
                gg.drawRect(x, y, w - 1, h - 1);
                gg.dispose();
            }
        }
    }
}

