/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.handler;

import com.google.common.collect.Lists;
import com.kamesuta.mc.bnnwidget.render.WRenderer;
import com.kamesuta.mc.signpic.Client;
import com.kamesuta.mc.signpic.CoreEvent;
import com.kamesuta.mc.signpic.gui.GuiHub;
import com.kamesuta.mc.signpic.gui.GuiIngameScreenShot;
import com.kamesuta.mc.signpic.gui.GuiMain;
import com.kamesuta.mc.signpic.gui.GuiWindowScreenShot;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.Timer;

public class KeyHandler {
    @Nonnull
    public static final Key keySignPicture = new Key.AbstractKey(){

        @Override
        public int getCode() {
            return Keys.KEY_BINDING_GUI.binding.func_151463_i();
        }
    };
    @Nonnull
    public static final Key keyScreenShotFull = new Key.FixedKey(24);
    @Nonnull
    public static final Key keyScreenShot = new Key.FixedKey(25);
    @Nonnull
    public static final Key keySwingScreenShot = new Key.FixedKey(23);
    @Nonnull
    public static final KeyHandler instance = new KeyHandler();
    @Nonnull
    private Timer signpickeypressed = new Timer();

    public static void init() {
        for (Keys key : Keys.values()) {
            ClientRegistry.registerKeyBinding((KeyBinding)key.binding);
        }
    }

    private KeyHandler() {
        this.signpickeypressed.pause();
    }

    @CoreEvent
    public void onKeyInput(@Nonnull InputEvent event) {
        for (Keys key : Keys.values()) {
            key.onKeyInput(event, key.binding);
        }
    }

    public boolean onGuiKeyInput(@Nonnull GuiScreen screen) {
        float time = this.signpickeypressed.getTime();
        if (!(screen instanceof GuiIngameScreenShot) && !(screen instanceof GuiWindowScreenShot)) {
            if (keySignPicture.isKeyPressed()) {
                if (!this.keyHook(screen)) {
                    this.signpickeypressed.resume();
                    return true;
                }
                this.clearInput();
            } else if (!(screen instanceof GuiMain) && time > 0.35f) {
                WRenderer.mc.func_147108_a((GuiScreen)new GuiMain(screen));
                this.clearInput();
            }
        }
        this.signpickeypressed.reset();
        this.signpickeypressed.pause();
        return false;
    }

    public boolean keyHook(@Nonnull GuiScreen screen) {
        if (keyScreenShot.isKeyPressed()) {
            WRenderer.mc.func_147108_a((GuiScreen)new GuiIngameScreenShot(screen));
        } else if (keyScreenShotFull.isKeyPressed()) {
            GuiIngameScreenShot shot = new GuiIngameScreenShot(screen);
            WRenderer.mc.func_147108_a((GuiScreen)shot);
            shot.takeFullScreenshot();
        } else if (keySwingScreenShot.isKeyPressed()) {
            WRenderer.mc.func_147108_a((GuiScreen)new GuiWindowScreenShot(screen));
        } else {
            return false;
        }
        return true;
    }

    public void clearInput() {
        if (Mouse.isCreated()) {
            while (Mouse.next()) {
            }
        }
        if (Keyboard.isCreated()) {
            while (Keyboard.next()) {
            }
        }
    }

    @Nonnull
    public static List<KeyBinding> getKeyConflict(@Nonnull KeyBinding binding) {
        LinkedList conflict = Lists.newLinkedList();
        if (binding.func_151463_i() != 0) {
            for (KeyBinding keybinding : Client.mc.field_71474_y.field_74324_K) {
                if (keybinding == binding || keybinding.func_151463_i() != binding.func_151463_i()) continue;
                conflict.add(keybinding);
            }
        }
        return conflict;
    }

    public static enum Keys {
        KEY_BINDING_GUI(new KeyBinding("signpic.key.gui", 43, "signpic.key.category")){

            @Override
            public void onKeyInput(@Nonnull InputEvent event, @Nonnull KeyBinding binding) {
                if (Client.mc.field_71462_r == null && binding.func_151468_f()) {
                    Client.mc.func_147108_a((GuiScreen)new GuiHub(Client.mc.field_71462_r));
                }
            }
        };

        @Nonnull
        public final KeyBinding binding;

        private Keys(KeyBinding binding) {
            this.binding = binding;
        }

        public abstract void onKeyInput(@Nonnull InputEvent var1, @Nonnull KeyBinding var2);
    }

    public static interface Key {
        public int getCode();

        public boolean isKeyPressed();

        @Nonnull
        public String getName();

        public static class FixedKey
        extends AbstractKey {
            protected int code;

            public FixedKey(int code) {
                this.code = code;
            }

            @Override
            public int getCode() {
                return this.code;
            }
        }

        public static abstract class AbstractKey
        implements Key {
            @Override
            public boolean isKeyPressed() {
                return Keyboard.isKeyDown((int)this.getCode());
            }

            @Override
            @Nonnull
            public String getName() {
                return Keyboard.getKeyName((int)this.getCode());
            }
        }
    }
}

