/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.handler;

import com.google.common.collect.Sets;
import com.kamesuta.mc.signpic.Client;
import com.kamesuta.mc.signpic.Config;
import com.kamesuta.mc.signpic.CoreEvent;
import com.kamesuta.mc.signpic.Log;
import com.kamesuta.mc.signpic.attr.AttrReaders;
import com.kamesuta.mc.signpic.attr.prop.OffsetData;
import com.kamesuta.mc.signpic.attr.prop.SizeData;
import com.kamesuta.mc.signpic.entry.Entry;
import com.kamesuta.mc.signpic.entry.EntryId;
import com.kamesuta.mc.signpic.entry.content.ContentId;
import com.kamesuta.mc.signpic.gui.GuiSignOption;
import com.kamesuta.mc.signpic.handler.AnvilHandler;
import com.kamesuta.mc.signpic.handler.INameHandler;
import com.kamesuta.mc.signpic.handler.KeyHandler;
import com.kamesuta.mc.signpic.http.shortening.ShortenerApiUtil;
import com.kamesuta.mc.signpic.mode.CurrentMode;
import com.kamesuta.mc.signpic.preview.SignEntity;
import com.kamesuta.mc.signpic.reflect.lib.ReflectClass;
import com.kamesuta.mc.signpic.reflect.lib.ReflectField;
import com.kamesuta.mc.signpic.util.Sign;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiEditSign;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.lwjgl.input.Keyboard;

public class SignHandler {
    @Nonnull
    public static ReflectField<GuiEditSign, TileEntitySign> guiEditSignTileEntity = ReflectClass.fromClass(GuiEditSign.class).getFieldFromType(null, TileEntitySign.class);
    @Nonnull
    private static Set<INameHandler> handlers = Sets.newHashSet();
    private boolean isPlaceMode;

    public static void init() {
        handlers.add(new AnvilHandler());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CoreEvent
    public void onSign(@Nonnull GuiOpenEvent event) {
        ContentId id;
        for (INameHandler handler : handlers) {
            if (handler == null) continue;
            handler.reset();
        }
        EntryId handSign = CurrentMode.instance.getHandSign();
        boolean handSignValid = handSign.entry().isValid();
        this.isPlaceMode = CurrentMode.instance.isMode(CurrentMode.Mode.PLACE);
        if (!handSignValid && !this.isPlaceMode) return;
        EntryId entryId = CurrentMode.instance.getEntryId();
        if (event.getGui() instanceof GuiEditSign) {
            EntryId placeSign;
            event.setCanceled(true);
            EntryId entryId2 = placeSign = handSignValid ? handSign : entryId;
            if (placeSign.isPlaceable()) {
                try {
                    TileEntitySign tileSign = guiEditSignTileEntity.get((GuiEditSign)event.getGui());
                    if (tileSign != null) {
                        Sign.placeSign(placeSign, tileSign);
                        if (CurrentMode.instance.isState(CurrentMode.State.CONTINUE)) return;
                        CurrentMode.instance.setMode();
                        SignEntity se = Sign.preview;
                        if (!se.isRenderable()) return;
                        BlockPos preview = se.getTileEntity().func_174877_v();
                        BlockPos tileSignPos = tileSign.func_174877_v();
                        if (preview.func_177958_n() != tileSignPos.func_177958_n() || preview.func_177956_o() != tileSignPos.func_177956_o() || preview.func_177952_p() != tileSignPos.func_177952_p()) return;
                        se.setVisible(false);
                        CurrentMode.instance.setState(CurrentMode.State.PREVIEW, false);
                        CurrentMode.instance.setState(CurrentMode.State.SEE, false);
                        return;
                    }
                    Log.notice(I18n.func_135052_a((String)"signpic.chat.error.place", (Object[])new Object[0]));
                    return;
                }
                catch (Exception e) {
                    Log.notice(I18n.func_135052_a((String)"signpic.chat.error.place", (Object[])new Object[0]));
                }
                return;
            }
            if (CurrentMode.instance.isShortening()) {
                Log.notice((Object)I18n.func_135052_a((String)"signpic.gui.notice.shortening", (Object[])new Object[0]), 1.0f);
                return;
            } else {
                Log.notice((Object)I18n.func_135052_a((String)"signpic.gui.notice.toolongplace", (Object[])new Object[0]), 1.0f);
            }
            return;
        }
        boolean b = false;
        for (INameHandler handler : handlers) {
            if (handler == null) continue;
            b = handler.onOpen(event.getGui(), entryId) || b;
        }
        if (!b) return;
        if (!entryId.isNameable() && (id = entryId.entry().contentId) != null) {
            ShortenerApiUtil.requestShoretning(id);
        }
        if (CurrentMode.instance.isState(CurrentMode.State.CONTINUE)) return;
        CurrentMode.instance.setMode();
        Sign.preview.setVisible(false);
        CurrentMode.instance.setState(CurrentMode.State.PREVIEW, false);
        CurrentMode.instance.setState(CurrentMode.State.SEE, false);
    }

    @CoreEvent
    public void onTick() {
        if (this.isPlaceMode) {
            for (INameHandler handler : handlers) {
                if (handler == null) continue;
                handler.onTick();
            }
        }
    }

    @CoreEvent
    public void onDraw(@Nonnull GuiScreenEvent.DrawScreenEvent.Post event) {
        if (this.isPlaceMode) {
            for (INameHandler handler : handlers) {
                GuiScreen gui = event.getGui();
                if (handler == null || gui == null) continue;
                handler.onDraw(gui);
            }
        }
    }

    @CoreEvent
    public void onClick(@Nonnull MouseEvent event) {
        if (event.isButtonstate() && Client.mc.field_71474_y.field_74313_G.func_151463_i() == event.getButton() - 100) {
            ItemStack handItem = Client.mc.field_71439_g.func_184614_ca();
            if (handItem == null || handItem.func_77973_b() != Items.field_151155_ap) {
                handItem = Client.mc.field_71439_g.func_184592_cb();
            }
            EntryId.ItemEntryId handEntry = null;
            if (handItem != null && handItem.func_77973_b() == Items.field_151155_ap) {
                handEntry = EntryId.ItemEntryId.fromItemStack(handItem);
                CurrentMode.instance.setHandSign(handEntry);
            } else {
                CurrentMode.instance.setHandSign(EntryId.blank);
            }
            if (CurrentMode.instance.isMode(CurrentMode.Mode.SETPREVIEW)) {
                Sign.preview.capturePlace();
                event.setCanceled(true);
                CurrentMode.instance.setMode();
                Client.openEditor();
            } else if (CurrentMode.instance.isMode(CurrentMode.Mode.OPTION)) {
                TileEntitySign tilesign = Client.getTileSignLooking();
                Entry entry = null;
                if (tilesign != null) {
                    entry = EntryId.SignEntryId.fromTile(tilesign).entry();
                } else if (handEntry != null) {
                    entry = handEntry.entry();
                }
                if (entry != null) {
                    event.setCanceled(true);
                    Client.mc.func_147108_a((GuiScreen)new GuiSignOption(entry));
                    if (!CurrentMode.instance.isState(CurrentMode.State.CONTINUE)) {
                        CurrentMode.instance.setMode();
                    }
                }
            }
        }
    }

    @CoreEvent
    public void onTooltip(@Nonnull ItemTooltipEvent event) {
        if (event.getItemStack().func_77973_b() == Items.field_151155_ap) {
            EntryId.ItemEntryId id = EntryId.fromItemStack(event.getItemStack());
            Entry entry = id.entry();
            List tip = event.getToolTip();
            if (entry.isValid()) {
                String raw;
                String string = raw = !tip.isEmpty() ? (String)tip.get(0) : "";
                if (id.hasName()) {
                    tip.set(0, id.getName());
                } else if (entry.contentId != null) {
                    tip.set(0, I18n.func_135052_a((String)"signpic.item.sign.desc.named", (Object[])new Object[]{entry.contentId.getURI()}));
                }
                KeyBinding sneak = Client.mc.field_71474_y.field_74311_E;
                if (!Keyboard.isKeyDown((int)sneak.func_151463_i())) {
                    tip.add(I18n.func_135052_a((String)"signpic.item.hold", (Object[])new Object[]{GameSettings.func_74298_c((int)sneak.func_151463_i())}));
                } else {
                    AttrReaders meta = entry.getMeta();
                    SizeData size = meta.sizes.getMovie().get();
                    tip.add(I18n.func_135052_a((String)"signpic.item.sign.desc.named.prop.size", (Object[])new Object[]{Float.valueOf(size.getWidth()), Float.valueOf(size.getHeight())}));
                    OffsetData offset = meta.offsets.getMovie().get();
                    tip.add(I18n.func_135052_a((String)"signpic.item.sign.desc.named.prop.offset", (Object[])new Object[]{Float.valueOf(offset.x.offset), Float.valueOf(offset.y.offset), Float.valueOf(offset.z.offset)}));
                    if (id.hasName() && entry.contentId != null) {
                        tip.add(I18n.func_135052_a((String)"signpic.item.sign.desc.named.url", (Object[])new Object[]{entry.contentId.getURI()}));
                    }
                    tip.add(I18n.func_135052_a((String)"signpic.item.sign.desc.named.raw", (Object[])new Object[]{raw}));
                }
            } else if (Config.getConfig().signTooltip.get().booleanValue() || !Config.getConfig().guiExperienced.get().booleanValue()) {
                KeyBinding binding = KeyHandler.Keys.KEY_BINDING_GUI.binding;
                List<KeyBinding> conflict = KeyHandler.getKeyConflict(binding);
                String keyDisplay = GameSettings.func_74298_c((int)binding.func_151463_i());
                if (!conflict.isEmpty()) {
                    keyDisplay = TextFormatting.RED + keyDisplay;
                }
                tip.add(I18n.func_135052_a((String)"signpic.item.sign.desc", (Object[])new Object[]{keyDisplay}));
                if (!conflict.isEmpty()) {
                    tip.add(I18n.func_135052_a((String)"signpic.item.sign.desc.keyconflict", (Object[])new Object[]{I18n.func_135052_a((String)"menu.options", (Object[])new Object[0]), I18n.func_135052_a((String)"options.controls", (Object[])new Object[0])}));
                    for (KeyBinding key : conflict) {
                        tip.add(I18n.func_135052_a((String)"signpic.item.sign.desc.keyconflict.key", (Object[])new Object[]{I18n.func_135052_a((String)key.func_151466_e(), (Object[])new Object[0]), I18n.func_135052_a((String)key.func_151464_g(), (Object[])new Object[0])}));
                    }
                }
            }
        }
    }
}

