/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.http;

import com.kamesuta.mc.bnnwidget.util.NotifyCollections;
import com.kamesuta.mc.signpic.Config;
import com.kamesuta.mc.signpic.http.ICommunicate;
import com.kamesuta.mc.signpic.state.Progressable;
import com.kamesuta.mc.signpic.util.ThreadUtils;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;

public class Communicator {
    @Nonnull
    public static Communicator instance = new Communicator();
    @Nonnull
    private final NotifyCollections.NotifyArrayDeque<Progressable> tasks = new NotifyCollections.NotifyArrayDeque();
    @Nonnull
    private final ExecutorService threadpool;

    public Communicator() {
        this.threadpool = ThreadUtils.newFixedCachedThreadPool(Config.getConfig().communicateThreads.get(), "signpic-http-%d");
    }

    @Nonnull
    public NotifyCollections.NotifyArrayDeque<Progressable> getTasks() {
        return this.tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void communicate(final @Nonnull ICommunicate communicate) {
        if (communicate instanceof Progressable) {
            NotifyCollections.NotifyArrayDeque<Progressable> notifyArrayDeque = this.tasks;
            synchronized (notifyArrayDeque) {
                this.tasks.offer((Progressable)((Object)communicate));
            }
        }
        this.threadpool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    communicate.communicate();
                }
                finally {
                    NotifyCollections.NotifyArrayDeque notifyArrayDeque = Communicator.this.tasks;
                    synchronized (notifyArrayDeque) {
                        Communicator.this.tasks.remove(communicate);
                    }
                }
            }
        });
    }
}

