/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.http.download;

import com.kamesuta.mc.signpic.Client;
import com.kamesuta.mc.signpic.Config;
import com.kamesuta.mc.signpic.LoadCanceledException;
import com.kamesuta.mc.signpic.entry.content.Content;
import com.kamesuta.mc.signpic.entry.content.ContentCapacityOverException;
import com.kamesuta.mc.signpic.entry.content.ContentLocation;
import com.kamesuta.mc.signpic.entry.content.meta.ContentCache;
import com.kamesuta.mc.signpic.entry.content.meta.URIStacks;
import com.kamesuta.mc.signpic.http.Communicate;
import com.kamesuta.mc.signpic.http.CommunicateResponse;
import com.kamesuta.mc.signpic.state.Progress;
import com.kamesuta.mc.signpic.state.Progressable;
import com.kamesuta.mc.signpic.state.State;
import com.kamesuta.mc.signpic.util.Downloader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HttpContext;

public class ContentDownload
extends Communicate
implements Progressable {
    @Nonnull
    private final Content content;
    private boolean canceled;

    public ContentDownload(@Nonnull Content content) {
        this.content = content;
    }

    @Override
    @Nonnull
    public State getState() {
        return this.content.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void communicate() {
        CountingOutputStream output;
        InputStream input;
        File tmp;
        block10: {
            block9: {
                tmp = null;
                input = null;
                output = null;
                try {
                    this.setCurrent();
                    String url = this.content.meta.getURL();
                    if (url == null) {
                        throw new URISyntaxException("", "URL input is null");
                    }
                    URI base = ContentLocation.remoteLocation(url);
                    HttpGet req = new HttpGet(base);
                    HttpClientContext context = HttpClientContext.create();
                    HttpResponse response = Downloader.downloader.client.execute((HttpUriRequest)req, (HttpContext)context);
                    List redirects = context.getRedirectLocations();
                    URIStacks uristacks = URIStacks.from(base, redirects);
                    this.content.meta.setURLStack(uristacks);
                    this.content.meta.setImageMeta(uristacks.getMetaString());
                    String end = uristacks.getEndPoint().toString();
                    String endid = ContentLocation.hash(end);
                    this.content.meta.setCacheID(endid);
                    ContentCache cachemeta = new ContentCache(ContentLocation.cachemetaLocation(endid));
                    cachemeta.setURL(end);
                    File cachefile = ContentLocation.cacheLocation(endid);
                    if (cachemeta.isAvailable() && !cachemeta.isDirty() && cachefile.exists()) {
                        req.abort();
                        this.onDone(new CommunicateResponse(true, null));
                        this.unsetCurrent();
                        break block9;
                    }
                    cachemeta.setDirty(false);
                    HttpEntity entity = response.getEntity();
                    cachemeta.setMime(ContentType.getOrDefault((HttpEntity)entity).getMimeType());
                    tmp = Client.getLocation().createCache("content");
                    long max = Config.getConfig().contentMaxByte.get().intValue();
                    long size = entity.getContentLength();
                    if (max > 0L && size > max) {
                        req.abort();
                        throw new ContentCapacityOverException("size: " + size);
                    }
                    Progress progress = this.content.state.getProgress();
                    progress.setOverall(entity.getContentLength());
                    input = entity.getContent();
                    output = new CountingOutputStream(new FileOutputStream(tmp), (HttpUriRequest)req, max, progress){
                        final /* synthetic */ HttpUriRequest val$req;
                        final /* synthetic */ long val$max;
                        final /* synthetic */ Progress val$progress;
                        {
                            this.val$req = httpUriRequest;
                            this.val$max = l;
                            this.val$progress = progress;
                            super(x0);
                        }

                        protected void afterWrite(int n) throws IOException {
                            if (ContentDownload.this.canceled) {
                                this.val$req.abort();
                                throw new LoadCanceledException();
                            }
                            long bcount = this.getByteCount();
                            if (this.val$max > 0L && bcount > this.val$max) {
                                this.val$req.abort();
                                throw new ContentCapacityOverException();
                            }
                            this.val$progress.setDone(bcount);
                        }
                    };
                    IOUtils.copyLarge((InputStream)input, (OutputStream)output);
                    IOUtils.closeQuietly((OutputStream)output);
                    FileUtils.deleteQuietly((File)cachefile);
                    FileUtils.moveFile((File)tmp, (File)cachefile);
                    cachemeta.setLastUpdated(System.currentTimeMillis());
                    cachemeta.setSize(cachefile.length());
                    this.onDone(new CommunicateResponse(true, null));
                    this.unsetCurrent();
                    break block10;
                }
                catch (Exception e) {
                    this.onDone(new CommunicateResponse(false, e));
                    return;
                }
            }
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(output);
            FileUtils.deleteQuietly((File)tmp);
            return;
        }
        IOUtils.closeQuietly((InputStream)input);
        IOUtils.closeQuietly((OutputStream)output);
        FileUtils.deleteQuietly((File)tmp);
        return;
        finally {
            this.unsetCurrent();
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(output);
            FileUtils.deleteQuietly(tmp);
        }
    }

    @Override
    public void cancel() {
        this.canceled = true;
        super.cancel();
    }
}

