/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.http.download;

import com.kamesuta.mc.signpic.Client;
import com.kamesuta.mc.signpic.LoadCanceledException;
import com.kamesuta.mc.signpic.Log;
import com.kamesuta.mc.signpic.http.Communicate;
import com.kamesuta.mc.signpic.http.CommunicateResponse;
import com.kamesuta.mc.signpic.information.Info;
import com.kamesuta.mc.signpic.information.Informations;
import com.kamesuta.mc.signpic.state.Progressable;
import com.kamesuta.mc.signpic.state.State;
import com.kamesuta.mc.signpic.util.ChatBuilder;
import com.kamesuta.mc.signpic.util.Downloader;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class ModDownload
extends Communicate
implements Progressable {
    protected boolean canceled;
    @Nonnull
    protected State status = new State().setName("\u00a76SignPicture Mod Update");
    @Nullable
    public ModDLResult result;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void communicate() {
        Informations.InfoState state = Informations.instance.getState();
        Informations.InfoSource source = Informations.instance.getSource();
        File tmp = null;
        InputStream input = null;
        CountingOutputStream output = null;
        try {
            String local;
            this.setCurrent();
            if (source == null) {
                throw new IllegalStateException("No update data available");
            }
            Informations.InfoVersion online = source.onlineVersion();
            Info.Version version = online.version;
            if (version == null) {
                throw new IllegalStateException("Invalid version data");
            }
            String stringremote = version.remote;
            String stringlocal = version.local;
            if (stringlocal != null && !StringUtils.isEmpty((CharSequence)stringlocal)) {
                local = stringlocal;
            } else if (stringremote != null && !StringUtils.isEmpty((CharSequence)stringremote)) {
                local = stringremote.substring(stringremote.lastIndexOf("/") + 1, stringremote.length());
            } else {
                throw new IllegalStateException("No update url provided in repository");
            }
            ChatBuilder.create("signpic.versioning.startingDownload").setParams(local).useTranslation().useJson().chatClient();
            Log.notice(I18n.func_135052_a((String)"signpic.gui.notice.downloading", (Object[])new Object[]{local}));
            state.downloading = true;
            HttpGet req = new HttpGet(new URI(version.remote));
            HttpResponse response = Downloader.downloader.client.execute((HttpUriRequest)req);
            HttpEntity entity = response.getEntity();
            this.status.getProgress().overall = entity.getContentLength();
            input = entity.getContent();
            tmp = Client.getLocation().createCache("modupdate");
            File f1 = new File(Client.getLocation().modDir, local);
            output = new CountingOutputStream(new FileOutputStream(tmp), (HttpUriRequest)req){
                final /* synthetic */ HttpUriRequest val$req;
                {
                    this.val$req = httpUriRequest;
                    super(x0);
                }

                protected void afterWrite(int n) throws IOException {
                    if (ModDownload.this.canceled) {
                        this.val$req.abort();
                        throw new LoadCanceledException();
                    }
                    ModDownload.this.status.getProgress().setDone(this.getByteCount());
                }
            };
            IOUtils.copyLarge((InputStream)input, (OutputStream)output);
            IOUtils.closeQuietly((OutputStream)output);
            FileUtils.deleteQuietly((File)f1);
            if (!f1.exists()) {
                FileUtils.moveFile((File)tmp, (File)f1);
            }
            ITextComponent chat = Client.getLocation().modFile.isFile() ? ChatBuilder.create("signpic.versioning.doneDownloadingWithFile").useTranslation().setId(897).setParams(local, Client.getLocation().modFile.getName()).setStyle(new Style().func_150238_a(TextFormatting.GREEN)).build() : ChatBuilder.create("signpic.versioning.doneDownloading").useTranslation().setId(897).setParams(local).setStyle(new Style().func_150238_a(TextFormatting.GREEN)).build();
            Log.notice(I18n.func_135052_a((String)"signpic.gui.notice.downloaded", (Object[])new Object[]{local}));
            Desktop.getDesktop().open(Client.getLocation().modDir.getCanonicalFile());
            state.downloadedFile = f1;
            this.result = new ModDLResult(chat);
            this.onDone(new CommunicateResponse(true, null));
        }
        catch (Throwable e) {
            try {
                Log.log.warn("Updater Downloading Error", e);
                ITextComponent chat = new ChatBuilder().setChat(new TextComponentTranslation("signpic.versioning.error", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED))).build();
                this.result = new ModDLResult(chat);
                this.onDone(new CommunicateResponse(false, e));
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.unsetCurrent();
                IOUtils.closeQuietly(input);
                IOUtils.closeQuietly(output);
                FileUtils.deleteQuietly(tmp);
                state.downloading = false;
            }
        }
        this.unsetCurrent();
        IOUtils.closeQuietly((InputStream)input);
        IOUtils.closeQuietly((OutputStream)output);
        FileUtils.deleteQuietly((File)tmp);
        state.downloading = false;
        return;
    }

    @Override
    @Nonnull
    public State getState() {
        return this.status;
    }

    @Override
    public void cancel() {
        this.canceled = true;
        super.cancel();
    }

    public static class ModDLResult {
        @Nonnull
        public final ITextComponent response;

        public ModDLResult(@Nonnull ITextComponent response) {
            this.response = response;
        }
    }
}

