/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.http.shortening;

import com.google.gson.stream.JsonReader;
import com.kamesuta.mc.signpic.Client;
import com.kamesuta.mc.signpic.http.Communicate;
import com.kamesuta.mc.signpic.http.CommunicateResponse;
import com.kamesuta.mc.signpic.http.shortening.IShortener;
import com.kamesuta.mc.signpic.http.shortening.ShorteningRequest;
import com.kamesuta.mc.signpic.state.Progressable;
import com.kamesuta.mc.signpic.state.State;
import com.kamesuta.mc.signpic.util.Downloader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class BitlyShortener
extends Communicate
implements Progressable,
IShortener {
    @Nonnull
    protected ShorteningRequest shortreq;
    @Nonnull
    protected String key;
    @Nullable
    protected BitlyResult result;

    public BitlyShortener(@Nonnull ShorteningRequest shortreq, @Nonnull String key) {
        this.shortreq = shortreq;
        this.key = key;
    }

    @Override
    @Nonnull
    public State getState() {
        return this.shortreq.getState("\u00a7dbit.ly: \u00a7r%s");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void communicate() {
        JsonReader jsonReader1;
        InputStream resstream;
        block9: {
            block10: {
                block8: {
                    String url = "https://api-ssl.bitly.com/v3/shorten?access_token=%s&longUrl=%s";
                    resstream = null;
                    jsonReader1 = null;
                    try {
                        this.setCurrent();
                        HttpGet httpget = new HttpGet(String.format("https://api-ssl.bitly.com/v3/shorten?access_token=%s&longUrl=%s", this.key, this.shortreq.getLongURL()));
                        HttpResponse response = Downloader.downloader.client.execute((HttpUriRequest)httpget);
                        if (response.getStatusLine().getStatusCode() == 200) {
                            HttpEntity resEntity = response.getEntity();
                            if (resEntity != null) {
                                resstream = resEntity.getContent();
                                jsonReader1 = new JsonReader((Reader)new InputStreamReader(resstream, StandardCharsets.UTF_8));
                                this.result = (BitlyResult)Client.gson.fromJson(jsonReader1, BitlyResult.class);
                                this.onDone(new CommunicateResponse(this.result != null && this.result.status_code == 200, null));
                                this.unsetCurrent();
                                break block8;
                            }
                            this.unsetCurrent();
                            break block9;
                        }
                        this.onDone(new CommunicateResponse(false, new IOException("Bad Response")));
                        this.unsetCurrent();
                        break block10;
                    }
                    catch (Exception e) {
                        this.onDone(new CommunicateResponse(false, e));
                        return;
                    }
                }
                IOUtils.closeQuietly((InputStream)resstream);
                IOUtils.closeQuietly((Closeable)jsonReader1);
                return;
            }
            IOUtils.closeQuietly((InputStream)resstream);
            IOUtils.closeQuietly(jsonReader1);
            return;
        }
        IOUtils.closeQuietly((InputStream)resstream);
        IOUtils.closeQuietly(jsonReader1);
        this.onDone(new CommunicateResponse(false, null));
        return;
        finally {
            this.unsetCurrent();
            IOUtils.closeQuietly(resstream);
            IOUtils.closeQuietly(jsonReader1);
        }
    }

    @Override
    @Nullable
    public String getShortLink() {
        if (this.result != null && this.result.data != null) {
            return this.result.data.url;
        }
        return null;
    }

    public static class BitlyResult {
        @Nullable
        public Data data;
        public int status_code;
        @Nullable
        public String status_txt;

        public static class Data {
            @Nullable
            public String long_url;
            @Nullable
            public String url;
            @Nullable
            public String hash;
            @Nullable
            public String global_hash;
            @Nullable
            public String new_hash;
        }
    }
}

