/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.http.shortening;

import com.google.gson.stream.JsonReader;
import com.kamesuta.mc.signpic.Client;
import com.kamesuta.mc.signpic.http.Communicate;
import com.kamesuta.mc.signpic.http.CommunicateResponse;
import com.kamesuta.mc.signpic.http.shortening.IShortener;
import com.kamesuta.mc.signpic.http.shortening.ShorteningRequest;
import com.kamesuta.mc.signpic.state.Progressable;
import com.kamesuta.mc.signpic.state.State;
import com.kamesuta.mc.signpic.util.Downloader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;

public class GooglShortener
extends Communicate
implements Progressable,
IShortener {
    @Nonnull
    protected ShorteningRequest shortreq;
    @Nonnull
    protected String key;
    @Nullable
    protected GooglResult result;

    public GooglShortener(@Nonnull ShorteningRequest shortreq, @Nonnull String key) {
        this.shortreq = shortreq;
        this.key = key;
    }

    @Override
    @Nonnull
    public State getState() {
        return this.shortreq.getState("\u00a7dgoo.gl: \u00a7r%s");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void communicate() {
        JsonReader jsonReader1;
        InputStream resstream;
        block9: {
            block10: {
                block8: {
                    String url = "https://www.googleapis.com/urlshortener/v1/url?key=%s";
                    resstream = null;
                    jsonReader1 = null;
                    try {
                        this.setCurrent();
                        HttpPost httppost = new HttpPost(String.format("https://www.googleapis.com/urlshortener/v1/url?key=%s", this.key));
                        EntityBuilder builder = EntityBuilder.create();
                        String reqjson = Client.gson.toJson((Object)new GooglRequest(this.shortreq.getLongURL()));
                        builder.setContentType(ContentType.APPLICATION_JSON);
                        builder.setText(reqjson);
                        httppost.setEntity(builder.build());
                        HttpResponse response = Downloader.downloader.client.execute((HttpUriRequest)httppost);
                        if (response.getStatusLine().getStatusCode() == 200) {
                            HttpEntity resEntity = response.getEntity();
                            if (resEntity != null) {
                                resstream = resEntity.getContent();
                                jsonReader1 = new JsonReader((Reader)new InputStreamReader(resstream, StandardCharsets.UTF_8));
                                this.result = (GooglResult)Client.gson.fromJson(jsonReader1, GooglResult.class);
                                this.onDone(new CommunicateResponse(true, null));
                                this.unsetCurrent();
                                break block8;
                            }
                            this.unsetCurrent();
                            break block9;
                        }
                        this.onDone(new CommunicateResponse(false, new IOException("Bad Response")));
                        this.unsetCurrent();
                        break block10;
                    }
                    catch (Exception e) {
                        this.onDone(new CommunicateResponse(false, e));
                        return;
                    }
                }
                IOUtils.closeQuietly((InputStream)resstream);
                IOUtils.closeQuietly((Closeable)jsonReader1);
                return;
            }
            IOUtils.closeQuietly((InputStream)resstream);
            IOUtils.closeQuietly(jsonReader1);
            return;
        }
        IOUtils.closeQuietly((InputStream)resstream);
        IOUtils.closeQuietly(jsonReader1);
        this.onDone(new CommunicateResponse(false, null));
        return;
        finally {
            this.unsetCurrent();
            IOUtils.closeQuietly(resstream);
            IOUtils.closeQuietly(jsonReader1);
        }
    }

    @Override
    @Nullable
    public String getShortLink() {
        if (this.result != null) {
            return this.result.id;
        }
        return null;
    }

    public static class GooglResult {
        @Nullable
        public String kind;
        @Nullable
        public String id;
        @Nullable
        public String longUrl;
    }

    public static class GooglRequest {
        @Nonnull
        public String longUrl;

        public GooglRequest(@Nonnull String longUrl) {
            this.longUrl = longUrl;
        }
    }
}

