/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.http.shortening;

import com.kamesuta.mc.signpic.Apis;
import com.kamesuta.mc.signpic.Log;
import com.kamesuta.mc.signpic.entry.content.ContentId;
import com.kamesuta.mc.signpic.gui.GuiMain;
import com.kamesuta.mc.signpic.http.Communicator;
import com.kamesuta.mc.signpic.http.ICommunicateCallback;
import com.kamesuta.mc.signpic.http.ICommunicateResponse;
import com.kamesuta.mc.signpic.http.shortening.IShortener;
import com.kamesuta.mc.signpic.http.shortening.ShorteningRequest;
import com.kamesuta.mc.signpic.mode.CurrentMode;
import com.kamesuta.mc.signpic.state.State;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;

public class ShortenerApiUtil {
    public static boolean shortening(@Nonnull ShorteningRequest content, final @Nullable Runnable onDone) {
        try {
            Apis.URLShortenerFactory factory = ShortenerApiUtil.getShortenerFactory();
            String key = ShortenerApiUtil.getKey(factory);
            if (factory != null && key != null) {
                content.getPendingState().getMeta().put("gui.highlight", true);
                final IShortener upload = factory.create(content, key);
                upload.setCallback(new ICommunicateCallback(){

                    @Override
                    public void onDone(ICommunicateResponse res) {
                        if (upload.getShortLink() != null) {
                            String url = upload.getShortLink();
                            if (url != null) {
                                GuiMain.setContentId(url);
                            }
                            if (onDone != null) {
                                onDone.run();
                            }
                        }
                        if (!res.isSuccess()) {
                            Log.notice(I18n.func_135052_a((String)"signpic.gui.notice.shorteningfailed", (Object[])new Object[]{res.getError()}));
                        }
                    }
                });
                Communicator.instance.communicate(upload);
            }
            return true;
        }
        catch (IOException e) {
            Log.notice(I18n.func_135052_a((String)"signpic.gui.notice.shorteningfailed", (Object[])new Object[]{e}));
            return false;
        }
    }

    public static boolean shortening(@Nonnull ShorteningRequest content) {
        return ShortenerApiUtil.shortening(content, null);
    }

    @Nullable
    public static Apis.URLShortenerFactory getShortenerFactory() {
        return Apis.instance.urlShorteners.solve(Apis.instance.urlShorteners.getConfigOrRandom());
    }

    @Nullable
    public static String getKey(@Nullable Apis.URLShortenerFactory factory) {
        if (factory != null) {
            return factory.keySettings().getConfigOrRandom();
        }
        return null;
    }

    public static void requestShoretning(@Nonnull ContentId id) {
        if (!CurrentMode.instance.isShortening()) {
            String longurl = id.getURI();
            CurrentMode.instance.setShortening(true);
            ShortenerApiUtil.shortening(new ShorteningRequest(longurl, longurl, new State()), new Runnable(){

                @Override
                public void run() {
                    CurrentMode.instance.setShortening(false);
                }
            });
        } else {
            Log.notice(I18n.func_135052_a((String)"signpic.gui.notice.shorteningother", (Object[])new Object[0]));
        }
    }
}

