/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.http.upload;

import com.google.gson.stream.JsonReader;
import com.kamesuta.mc.signpic.Client;
import com.kamesuta.mc.signpic.LoadCanceledException;
import com.kamesuta.mc.signpic.entry.content.ContentLocation;
import com.kamesuta.mc.signpic.http.Communicate;
import com.kamesuta.mc.signpic.http.CommunicateResponse;
import com.kamesuta.mc.signpic.http.upload.IUploader;
import com.kamesuta.mc.signpic.http.upload.UploadRequest;
import com.kamesuta.mc.signpic.lib.org.apache.http.entity.mime.MultipartEntityBuilder;
import com.kamesuta.mc.signpic.state.Progressable;
import com.kamesuta.mc.signpic.state.State;
import com.kamesuta.mc.signpic.util.Downloader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;

public class GyazoUpload
extends Communicate
implements Progressable,
IUploader {
    @Nonnull
    protected UploadRequest upreq;
    @Nonnull
    protected String key;
    protected boolean canceled;
    @Nullable
    protected GyazoResult result;

    public GyazoUpload(@Nonnull UploadRequest upload, @Nonnull String key) {
        this.upreq = upload;
        this.key = key;
    }

    @Override
    @Nonnull
    public State getState() {
        return this.upreq.getState("\u00a73Gyazo: \u00a7r%s");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void communicate() {
        JsonReader jsonReader1;
        CountingInputStream countupstream;
        InputStream resstream;
        File tmp;
        block10: {
            block11: {
                block9: {
                    String url = "https://upload.gyazo.com/api/upload";
                    tmp = null;
                    resstream = null;
                    countupstream = null;
                    jsonReader1 = null;
                    try {
                        this.setCurrent();
                        tmp = Client.getLocation().createCache("gyazo");
                        FileUtils.copyInputStreamToFile((InputStream)this.upreq.getStream(), (File)tmp);
                        final HttpPost httppost = new HttpPost("https://upload.gyazo.com/api/upload");
                        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                        final State state = this.getState();
                        countupstream = new CountingInputStream(new FileInputStream(tmp)){

                            protected void beforeRead(int n) throws IOException {
                                if (GyazoUpload.this.canceled) {
                                    httppost.abort();
                                    throw new LoadCanceledException();
                                }
                            }

                            protected void afterRead(int n) {
                                super.afterRead(n);
                                state.getProgress().done = this.getByteCount();
                            }
                        };
                        builder.addTextBody("access_token", this.key);
                        builder.addBinaryBody("imagedata", (InputStream)countupstream, ContentType.DEFAULT_BINARY, this.upreq.getName());
                        httppost.setEntity(builder.build());
                        HttpResponse response = Downloader.downloader.client.execute((HttpUriRequest)httppost);
                        if (response.getStatusLine().getStatusCode() == 200) {
                            HttpEntity resEntity = response.getEntity();
                            if (resEntity != null) {
                                resstream = resEntity.getContent();
                                jsonReader1 = new JsonReader((Reader)new InputStreamReader(resstream, StandardCharsets.UTF_8));
                                this.result = (GyazoResult)Client.gson.fromJson(jsonReader1, GyazoResult.class);
                                String link = this.getLink();
                                if (link != null) {
                                    FileUtils.moveFile((File)tmp, (File)ContentLocation.cacheLocation(ContentLocation.hash(link)));
                                }
                                this.onDone(new CommunicateResponse(true, null));
                                this.unsetCurrent();
                                break block9;
                            }
                            this.unsetCurrent();
                            break block10;
                        }
                        this.onDone(new CommunicateResponse(false, new IOException("Bad Response")));
                        this.unsetCurrent();
                        break block11;
                    }
                    catch (Exception e) {
                        this.onDone(new CommunicateResponse(false, e));
                        return;
                    }
                }
                IOUtils.closeQuietly((InputStream)countupstream);
                IOUtils.closeQuietly((InputStream)resstream);
                IOUtils.closeQuietly((Closeable)jsonReader1);
                FileUtils.deleteQuietly((File)tmp);
                return;
            }
            IOUtils.closeQuietly((InputStream)countupstream);
            IOUtils.closeQuietly((InputStream)resstream);
            IOUtils.closeQuietly(jsonReader1);
            FileUtils.deleteQuietly((File)tmp);
            return;
        }
        IOUtils.closeQuietly((InputStream)countupstream);
        IOUtils.closeQuietly((InputStream)resstream);
        IOUtils.closeQuietly(jsonReader1);
        FileUtils.deleteQuietly((File)tmp);
        this.onDone(new CommunicateResponse(false, null));
        return;
        finally {
            this.unsetCurrent();
            IOUtils.closeQuietly(countupstream);
            IOUtils.closeQuietly(resstream);
            IOUtils.closeQuietly(jsonReader1);
            FileUtils.deleteQuietly((File)tmp);
        }
    }

    @Override
    public void cancel() {
        this.canceled = true;
        super.cancel();
    }

    @Override
    @Nullable
    public String getLink() {
        if (this.result != null) {
            return this.result.url;
        }
        return null;
    }

    public static class GyazoResult {
        @Nullable
        public String created_at;
        @Nullable
        public String image_id;
        @Nullable
        public String permalink_url;
        @Nullable
        public String thumb_url;
        @Nullable
        public String type;
        @Nullable
        public String url;
    }
}

