/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.http.upload;

import com.google.gson.stream.JsonReader;
import com.kamesuta.mc.signpic.Client;
import com.kamesuta.mc.signpic.LoadCanceledException;
import com.kamesuta.mc.signpic.entry.content.Content;
import com.kamesuta.mc.signpic.entry.content.ContentId;
import com.kamesuta.mc.signpic.entry.content.ContentLocation;
import com.kamesuta.mc.signpic.http.Communicate;
import com.kamesuta.mc.signpic.http.CommunicateResponse;
import com.kamesuta.mc.signpic.http.upload.IUploader;
import com.kamesuta.mc.signpic.http.upload.UploadRequest;
import com.kamesuta.mc.signpic.lib.org.apache.http.entity.mime.MultipartEntityBuilder;
import com.kamesuta.mc.signpic.state.Progressable;
import com.kamesuta.mc.signpic.state.State;
import com.kamesuta.mc.signpic.util.Downloader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;

public class ImgurUpload
extends Communicate
implements Progressable,
IUploader {
    @Nonnull
    protected UploadRequest upreq;
    @Nonnull
    protected String key;
    protected boolean canceled;
    @Nullable
    protected ImgurResult result;

    public ImgurUpload(@Nonnull UploadRequest upload, @Nonnull String key) {
        this.upreq = upload;
        this.key = key;
    }

    @Override
    @Nonnull
    public State getState() {
        return this.upreq.getState("\u00a73Imgur: \u00a7r%s");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void communicate() {
        JsonReader jsonReader1;
        CountingInputStream countupstream;
        InputStream resstream;
        File tmp;
        block11: {
            block12: {
                block10: {
                    String url = "https://api.imgur.com/3/image";
                    tmp = null;
                    resstream = null;
                    countupstream = null;
                    jsonReader1 = null;
                    try {
                        this.setCurrent();
                        tmp = Client.getLocation().createCache("imgur");
                        FileUtils.copyInputStreamToFile((InputStream)this.upreq.getStream(), (File)tmp);
                        final HttpPost httppost = new HttpPost("https://api.imgur.com/3/image");
                        httppost.addHeader("Authorization", "Client-ID " + this.key);
                        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                        final State state = this.getState();
                        countupstream = new CountingInputStream(new FileInputStream(tmp)){

                            protected void beforeRead(int n) throws IOException {
                                if (ImgurUpload.this.canceled) {
                                    httppost.abort();
                                    throw new LoadCanceledException();
                                }
                            }

                            protected void afterRead(int n) {
                                super.afterRead(n);
                                state.getProgress().done = this.getByteCount();
                            }
                        };
                        builder.addBinaryBody("image", (InputStream)countupstream, ContentType.DEFAULT_BINARY, this.upreq.getName());
                        httppost.setEntity(builder.build());
                        HttpResponse response = Downloader.downloader.client.execute((HttpUriRequest)httppost);
                        if (response.getStatusLine().getStatusCode() == 200) {
                            HttpEntity resEntity = response.getEntity();
                            if (resEntity != null) {
                                resstream = resEntity.getContent();
                                jsonReader1 = new JsonReader((Reader)new InputStreamReader(resstream, StandardCharsets.UTF_8));
                                this.result = (ImgurResult)Client.gson.fromJson(jsonReader1, ImgurResult.class);
                                String link = this.getLink();
                                if (link != null) {
                                    Content content = ContentId.from(link).content();
                                    String id = content.meta.getCacheID();
                                    if (id != null) {
                                        FileUtils.moveFile((File)tmp, (File)ContentLocation.cacheLocation(id));
                                    }
                                }
                                this.onDone(new CommunicateResponse(this.result != null && this.result.success, null));
                                this.unsetCurrent();
                                break block10;
                            }
                            this.unsetCurrent();
                            break block11;
                        }
                        this.onDone(new CommunicateResponse(false, new IOException("Bad Response")));
                        this.unsetCurrent();
                        break block12;
                    }
                    catch (Exception e) {
                        this.onDone(new CommunicateResponse(false, e));
                        return;
                    }
                }
                IOUtils.closeQuietly((InputStream)countupstream);
                IOUtils.closeQuietly((InputStream)resstream);
                IOUtils.closeQuietly((Closeable)jsonReader1);
                FileUtils.deleteQuietly((File)tmp);
                return;
            }
            IOUtils.closeQuietly((InputStream)countupstream);
            IOUtils.closeQuietly((InputStream)resstream);
            IOUtils.closeQuietly(jsonReader1);
            FileUtils.deleteQuietly((File)tmp);
            return;
        }
        IOUtils.closeQuietly((InputStream)countupstream);
        IOUtils.closeQuietly((InputStream)resstream);
        IOUtils.closeQuietly(jsonReader1);
        FileUtils.deleteQuietly((File)tmp);
        this.onDone(new CommunicateResponse(false, null));
        return;
        finally {
            this.unsetCurrent();
            IOUtils.closeQuietly(countupstream);
            IOUtils.closeQuietly(resstream);
            IOUtils.closeQuietly(jsonReader1);
            FileUtils.deleteQuietly((File)tmp);
        }
    }

    @Override
    public void cancel() {
        this.canceled = true;
        super.cancel();
    }

    @Override
    @Nullable
    public String getLink() {
        if (this.result != null && this.result.data != null) {
            return this.result.data.link;
        }
        return null;
    }

    public static class ImgurResult {
        @Nullable
        public Data data;
        public boolean success;
        public int status;

        public static class Data {
            @Nullable
            public String id;
            @Nullable
            public String title;
            @Nullable
            public String description;
            public int datetime;
            @Nullable
            public String type;
            public boolean animated;
            public int width;
            public int height;
            public int size;
            public int views;
            public int bandwidth;
            @Nullable
            public String vote;
            public boolean favorite;
            @Nullable
            public String nsfw;
            @Nullable
            public String section;
            @Nullable
            public String account_url;
            public int account_id;
            public boolean is_ad;
            public boolean in_gallery;
            @Nullable
            public String deletehash;
            @Nullable
            public String name;
            @Nullable
            public String link;
            @Nullable
            public String gifv;
            @Nullable
            public String mp4;
            public int mp4_size;
            public boolean looping;
        }
    }
}

