/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.http.upload;

import com.kamesuta.mc.signpic.Apis;
import com.kamesuta.mc.signpic.Log;
import com.kamesuta.mc.signpic.gui.GuiMain;
import com.kamesuta.mc.signpic.http.Communicator;
import com.kamesuta.mc.signpic.http.ICommunicateCallback;
import com.kamesuta.mc.signpic.http.ICommunicateResponse;
import com.kamesuta.mc.signpic.http.upload.IUploader;
import com.kamesuta.mc.signpic.http.upload.UploadCallback;
import com.kamesuta.mc.signpic.http.upload.UploadRequest;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;

public class UploadApiUtil {
    public static boolean upload(final @Nonnull UploadRequest content, final @Nullable UploadCallback onDone) {
        try {
            Apis.ImageUploaderFactory factory = UploadApiUtil.getUploaderFactory();
            String key = UploadApiUtil.getKey(factory);
            if (factory != null && key != null) {
                content.getPendingState().getMeta().put("gui.highlight", true);
                content.getPendingState().getMeta().put("gui.showpanel", 3);
                final IUploader upload = factory.create(content, key);
                upload.setCallback(new ICommunicateCallback(){

                    @Override
                    public void onDone(@Nonnull ICommunicateResponse res) {
                        String url = upload.getLink();
                        if (url != null) {
                            if (!GuiMain.setContentId(url)) {
                                Log.notice(I18n.func_135052_a((String)"signpic.gui.notice.uploaded", (Object[])new Object[]{content.getName()}));
                            }
                            if (onDone != null) {
                                onDone.onDone(url);
                            }
                        }
                        if (!res.isSuccess()) {
                            Log.notice(I18n.func_135052_a((String)"signpic.gui.notice.uploadfailed", (Object[])new Object[]{res.getError()}));
                        }
                    }
                });
                Communicator.instance.communicate(upload);
            }
            return true;
        }
        catch (IOException e) {
            Log.notice(I18n.func_135052_a((String)"signpic.gui.notice.uploadfailed", (Object[])new Object[]{e}));
            return false;
        }
    }

    @Nullable
    public static Apis.ImageUploaderFactory getUploaderFactory() {
        return Apis.instance.imageUploaders.solve(Apis.instance.imageUploaders.getConfigOrRandom());
    }

    @Nullable
    public static String getKey(@Nullable Apis.ImageUploaderFactory factory) {
        if (factory != null) {
            return factory.keySettings().getConfigOrRandom();
        }
        return null;
    }
}

