/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.http.upload;

import com.kamesuta.mc.signpic.state.State;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;

public abstract class UploadRequest {
    @Nonnull
    protected final State state;

    public UploadRequest(@Nonnull State state) {
        this.state = state;
    }

    public State getState(@Nonnull String format) {
        State state = this.getPendingState();
        state.setName(String.format(format, this.getName()));
        state.getProgress().setOverall(this.getSize());
        return state;
    }

    @Nonnull
    public State getPendingState() {
        return this.state;
    }

    @Nonnull
    public abstract String getName();

    public abstract long getSize();

    @Nonnull
    public abstract InputStream getStream() throws IOException;

    @Nonnull
    public static UploadRequest fromStream(@Nonnull String name, @Nonnull InputStream stream, long size, @Nonnull State state) {
        return new StreamUploadContent(name, stream, size, state);
    }

    @Nonnull
    public static UploadRequest fromFile(@Nonnull File file, @Nonnull State state) {
        return new FileUploadContent(file, state);
    }

    private static class FileUploadContent
    extends UploadRequest {
        @Nonnull
        private final File file;

        public FileUploadContent(@Nonnull File file, @Nonnull State state) {
            super(state);
            this.file = file;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.file.getName();
        }

        @Override
        public long getSize() {
            return this.file.length();
        }

        @Override
        @Nonnull
        public InputStream getStream() throws FileNotFoundException {
            return new FileInputStream(this.file);
        }
    }

    private static class StreamUploadContent
    extends UploadRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final InputStream stream;
        private final long size;

        public StreamUploadContent(@Nonnull String name, @Nonnull InputStream stream, long size, @Nonnull State state) {
            super(state);
            this.name = name;
            this.stream = stream;
            this.size = size;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        @Override
        @Nonnull
        public InputStream getStream() {
            return this.stream;
        }
    }
}

