/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.image;

import com.kamesuta.mc.bnnwidget.render.OpenGL;
import com.kamesuta.mc.signpic.Client;
import com.kamesuta.mc.signpic.Config;
import com.kamesuta.mc.signpic.attr.prop.SizeData;
import com.kamesuta.mc.signpic.image.ImageTexture;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureUtil;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public abstract class DynamicImageTexture
implements ImageTexture {
    @Nonnull
    public static final DynamicImageTexture NULL = new DynamicTexture(null, 1, 1);
    protected final int width;
    protected final int height;
    @Nonnull
    private final SizeData size;
    private int id = -1;

    public DynamicImageTexture(int width, int height) {
        this.width = width;
        this.height = height;
        this.size = SizeData.create(width, height);
    }

    @Nonnull
    public DynamicImageTexture load() {
        if (this.id == -1) {
            this.id = OpenGL.glGenTextures();
            this.loadDirect();
        }
        return this;
    }

    @Nonnull
    protected abstract DynamicImageTexture loadDirect();

    @Override
    public abstract boolean hasMipmap();

    @Override
    @Nonnull
    public SizeData getSize() {
        return this.size;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void bind() {
        if (this.id != -1) {
            OpenGL.glBindTexture(3553, this.id);
        }
    }

    public void delete() {
        if (this.id != -1) {
            OpenGL.glDeleteTextures(this.id);
        }
        this.id = -1;
    }

    @Nonnull
    public static DynamicImageTexture create(@Nonnull BufferedImage image, int width, int height) {
        if (Config.getConfig().renderUseMipmap.get().booleanValue()) {
            return MipmapDynamicTexture.createFromImage(image, width, height, Client.mc.field_71474_y.field_151442_I);
        }
        return DynamicTexture.createFromImage(image, width, height);
    }

    @Deprecated
    public static class GlMipmapDynamicTexture
    extends DynamicImageTexture {
        @Nullable
        private BufferedImage image;
        private final int miplevel;

        private GlMipmapDynamicTexture(@Nonnull BufferedImage image, int miplevel) {
            super(image.getWidth(), image.getHeight());
            this.image = image;
            this.miplevel = miplevel;
        }

        @Override
        @Nonnull
        public DynamicImageTexture loadDirect() {
            BufferedImage bufferedImage = this.image;
            if (bufferedImage != null) {
                try {
                    ByteBuffer byteBuffer;
                    int width = bufferedImage.getWidth();
                    int height = bufferedImage.getHeight();
                    byte bpp = (byte)bufferedImage.getColorModel().getPixelSize();
                    DataBuffer db = bufferedImage.getData().getDataBuffer();
                    if (db instanceof DataBufferInt) {
                        int[] intI = ((DataBufferInt)bufferedImage.getData().getDataBuffer()).getData();
                        byte[] newI = new byte[intI.length * 4];
                        for (int i = 0; i < intI.length; ++i) {
                            byte[] b = GlMipmapDynamicTexture.intToByteArray(intI[i]);
                            int newIndex = i * 4;
                            newI[newIndex] = b[1];
                            newI[newIndex + 1] = b[2];
                            newI[newIndex + 2] = b[3];
                            newI[newIndex + 3] = b[0];
                        }
                        byteBuffer = ByteBuffer.allocateDirect(width * height * (bpp / 8)).order(ByteOrder.nativeOrder()).put(newI);
                    } else {
                        byteBuffer = ByteBuffer.allocateDirect(width * height * (bpp / 8)).order(ByteOrder.nativeOrder()).put(((DataBufferByte)bufferedImage.getData().getDataBuffer()).getData());
                    }
                    byteBuffer.flip();
                    int internalFormat = 32856;
                    int format = 6408;
                    int textureId = this.getId();
                    OpenGL.glBindTexture(3553, textureId);
                    OpenGL.glTexParameteri(3553, 10242, 10496);
                    OpenGL.glTexParameteri(3553, 10243, 10496);
                    OpenGL.glTexParameteri(3553, 10240, 9729);
                    OpenGL.glTexParameteri(3553, 10241, 9729);
                    GL11.glTexEnvf((int)8960, (int)8704, (float)8448.0f);
                    GLU.gluBuild2DMipmaps((int)3553, (int)32856, (int)width, (int)height, (int)6408, (int)5121, (ByteBuffer)byteBuffer);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.image = null;
            }
            return this;
        }

        private static byte[] intToByteArray(int value) {
            return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        }

        @Override
        public boolean hasMipmap() {
            return this.miplevel >= 1;
        }

        @Override
        public void delete() {
            super.delete();
            if (this.image != null) {
                this.image = null;
            }
        }

        @Nonnull
        public static GlMipmapDynamicTexture createFromSizedImage(@Nonnull BufferedImage sizedImage, int miplevel) {
            return new GlMipmapDynamicTexture(sizedImage, miplevel);
        }

        @Nonnull
        public static GlMipmapDynamicTexture createFromImage(@Nonnull BufferedImage image, int width, int height, int miplevel) {
            if (width == image.getWidth() && height == image.getHeight()) {
                return GlMipmapDynamicTexture.createFromSizedImage(image, miplevel);
            }
            BufferedImage s = new BufferedImage(width, height, image.getType());
            Graphics2D g = s.createGraphics();
            g.drawImage(image.getScaledInstance(width, height, Config.getConfig().imageResizeFast.get() != false ? 2 : 4), 0, 0, null);
            g.dispose();
            return GlMipmapDynamicTexture.createFromSizedImage(s, miplevel);
        }

        @Nonnull
        public static GlMipmapDynamicTexture createFromImage(@Nonnull BufferedImage image, int miplevel) {
            return GlMipmapDynamicTexture.createFromImage(image, image.getWidth(), image.getHeight(), miplevel);
        }
    }

    public static class MipmapDynamicTexture
    extends DynamicImageTexture {
        @Nullable
        private int[][] mipdata;
        private final int miplevel;

        private MipmapDynamicTexture(@Nullable int[][] mipdata, int width, int height, int miplevel) {
            super(width, height);
            this.mipdata = mipdata;
            this.miplevel = miplevel;
        }

        @Override
        @Nonnull
        public DynamicImageTexture loadDirect() {
            int[][] mipdata = this.mipdata;
            if (mipdata != null && mipdata.length >= 1) {
                int id = this.getId();
                if (this.miplevel >= 1) {
                    TextureUtil.func_180600_a((int)id, (int)this.miplevel, (int)this.width, (int)this.height);
                    TextureUtil.func_147955_a((int[][])mipdata, (int)this.width, (int)this.height, (int)0, (int)0, (boolean)false, (boolean)false);
                } else {
                    TextureUtil.func_110991_a((int)id, (int)this.width, (int)this.height);
                    TextureUtil.func_110988_a((int)id, (int[])mipdata[0], (int)this.width, (int)this.height);
                }
                this.mipdata = null;
            }
            return this;
        }

        @Override
        public boolean hasMipmap() {
            return this.miplevel >= 1;
        }

        @Override
        public void delete() {
            super.delete();
            if (this.mipdata != null) {
                this.mipdata = null;
            }
        }

        @Nonnull
        public static MipmapDynamicTexture createFromRawMipmap(@Nullable int[][] mipdata, int width, int height, int miplevel) {
            return new MipmapDynamicTexture(mipdata, width, height, miplevel);
        }

        @Nonnull
        public static MipmapDynamicTexture createFromRawData(@Nonnull int[] image, int width, int height, int miplevel) {
            int[][] aint = new int[miplevel + 1][];
            aint[0] = image;
            int[][] bint = MipmapDynamicTexture.generateMipmapData(miplevel, width, aint);
            return new MipmapDynamicTexture(bint, width, height, miplevel);
        }

        @Nonnull
        public static MipmapDynamicTexture createFromSizedImage(@Nonnull BufferedImage sizedImage, int miplevel) {
            int width = sizedImage.getWidth();
            int height = sizedImage.getHeight();
            return MipmapDynamicTexture.createFromRawData(sizedImage.getRGB(0, 0, width, height, null, 0, width), width, height, miplevel);
        }

        @Nonnull
        public static MipmapDynamicTexture createFromImage(@Nonnull BufferedImage image, int width, int height, int miplevel) {
            int unitmip = 2 << miplevel;
            int nwidth = (int)Math.ceil((double)width / (double)unitmip) * unitmip;
            int nheight = (int)Math.ceil((double)height / (double)unitmip) * unitmip;
            if (nwidth == image.getWidth() && nheight == image.getHeight()) {
                return MipmapDynamicTexture.createFromSizedImage(image, miplevel);
            }
            BufferedImage s = new BufferedImage(nwidth, nheight, image.getType());
            Graphics2D g = s.createGraphics();
            g.drawImage(image.getScaledInstance(nwidth, nheight, Config.getConfig().imageResizeFast.get() != false ? 2 : 4), 0, 0, null);
            g.dispose();
            return MipmapDynamicTexture.createFromSizedImage(s, miplevel);
        }

        @Nonnull
        public static MipmapDynamicTexture createFromImage(@Nonnull BufferedImage image, int miplevel) {
            return MipmapDynamicTexture.createFromImage(image, image.getWidth(), image.getHeight(), miplevel);
        }

        public static int[][] generateMipmapData(int miplevel, int width, int[][] mipdata) {
            int[][] aint1 = new int[miplevel + 1][];
            aint1[0] = mipdata[0];
            if (miplevel > 0) {
                int k;
                boolean flag = false;
                for (k = 0; k < mipdata.length; ++k) {
                    if (mipdata[0][k] >> 24 != 0) continue;
                    flag = true;
                    break;
                }
                for (k = 1; k <= miplevel; ++k) {
                    if (mipdata[k] != null) {
                        aint1[k] = mipdata[k];
                        continue;
                    }
                    int[] aint2 = aint1[k - 1];
                    int[] aint3 = new int[aint2.length >> 2];
                    int l = width >> k;
                    int i1 = aint3.length / l;
                    int j1 = l << 1;
                    for (int k1 = 0; k1 < l; ++k1) {
                        for (int l1 = 0; l1 < i1; ++l1) {
                            int i2 = 2 * (k1 + l1 * j1);
                            aint3[k1 + l1 * l] = MipmapDynamicTexture.calcPixel(aint2[i2 + 0], aint2[i2 + 1], aint2[i2 + 0 + j1], aint2[i2 + 1 + j1], flag);
                        }
                    }
                    aint1[k] = aint3;
                }
            }
            return aint1;
        }

        private static int calcPixel(int pixel1, int pixel2, int pixel3, int pixel4, boolean isClearSize) {
            int i1;
            if (!isClearSize) {
                int i2 = MipmapDynamicTexture.calcClearPixel(pixel1, pixel2, pixel3, pixel4, 24);
                int j2 = MipmapDynamicTexture.calcClearPixel(pixel1, pixel2, pixel3, pixel4, 16);
                int k2 = MipmapDynamicTexture.calcClearPixel(pixel1, pixel2, pixel3, pixel4, 8);
                int l2 = MipmapDynamicTexture.calcClearPixel(pixel1, pixel2, pixel3, pixel4, 0);
                return i2 << 24 | j2 << 16 | k2 << 8 | l2;
            }
            int[] pixel = new int[]{pixel1, pixel2, pixel3, pixel4};
            float f = 0.0f;
            float f1 = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            for (i1 = 0; i1 < 4; ++i1) {
                if (pixel[i1] >> 24 == 0) continue;
                f += (float)Math.pow((float)(pixel[i1] >> 24 & 0xFF) / 255.0f, 2.2);
                f1 += (float)Math.pow((float)(pixel[i1] >> 16 & 0xFF) / 255.0f, 2.2);
                f2 += (float)Math.pow((float)(pixel[i1] >> 8 & 0xFF) / 255.0f, 2.2);
                f3 += (float)Math.pow((float)(pixel[i1] >> 0 & 0xFF) / 255.0f, 2.2);
            }
            i1 = (int)(Math.pow(f / 4.0f, 0.45454545454545453) * 255.0);
            int j1 = (int)(Math.pow(f1 / 4.0f, 0.45454545454545453) * 255.0);
            int k1 = (int)(Math.pow(f2 / 4.0f, 0.45454545454545453) * 255.0);
            int l1 = (int)(Math.pow(f3 / 4.0f, 0.45454545454545453) * 255.0);
            if (i1 < 96) {
                i1 = 0;
            }
            return i1 << 24 | j1 << 16 | k1 << 8 | l1;
        }

        private static int calcClearPixel(int pixel1, int pixel2, int pixel3, int pixel4, int color) {
            float f = (float)Math.pow((float)(pixel1 >> color & 0xFF) / 255.0f, 2.2);
            float f1 = (float)Math.pow((float)(pixel2 >> color & 0xFF) / 255.0f, 2.2);
            float f2 = (float)Math.pow((float)(pixel3 >> color & 0xFF) / 255.0f, 2.2);
            float f3 = (float)Math.pow((float)(pixel4 >> color & 0xFF) / 255.0f, 2.2);
            float f4 = (float)Math.pow((double)(f + f1 + f2 + f3) * 0.25, 0.45454545454545453);
            return (int)((double)f4 * 255.0);
        }
    }

    public static class DynamicTexture
    extends DynamicImageTexture {
        @Nullable
        private int[] image;

        private DynamicTexture(@Nullable int[] image, int width, int height) {
            super(width, height);
            this.image = image;
        }

        @Override
        @Nonnull
        protected DynamicImageTexture loadDirect() {
            if (this.image != null) {
                int id = this.getId();
                TextureUtil.func_110991_a((int)id, (int)this.width, (int)this.height);
                TextureUtil.func_110988_a((int)id, (int[])this.image, (int)this.width, (int)this.height);
                this.image = null;
            }
            return this;
        }

        @Override
        public boolean hasMipmap() {
            return false;
        }

        @Override
        public void delete() {
            super.delete();
            if (this.image != null) {
                this.image = null;
            }
        }

        @Nonnull
        public static DynamicTexture createFromRawData(@Nullable int[] image, int width, int height) {
            return new DynamicTexture(image, width, height);
        }

        @Nonnull
        public static DynamicTexture createFromSizedImage(@Nonnull BufferedImage sizedImage) {
            int width = sizedImage.getWidth();
            int height = sizedImage.getHeight();
            return DynamicTexture.createFromRawData(sizedImage.getRGB(0, 0, width, height, null, 0, width), width, height);
        }

        @Nonnull
        public static DynamicTexture createFromImage(@Nonnull BufferedImage image, int width, int height) {
            if (width == image.getWidth() && height == image.getHeight()) {
                return DynamicTexture.createFromSizedImage(image);
            }
            BufferedImage s = new BufferedImage(width, height, image.getType());
            Graphics2D g = s.createGraphics();
            g.drawImage(image.getScaledInstance(width, height, Config.getConfig().imageResizeFast.get() != false ? 2 : 4), 0, 0, null);
            g.dispose();
            return DynamicTexture.createFromSizedImage(s);
        }
    }
}

