/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.image;

import com.kamesuta.mc.bnnwidget.position.Area;
import com.kamesuta.mc.bnnwidget.render.OpenGL;
import com.kamesuta.mc.bnnwidget.render.WGui;
import com.kamesuta.mc.bnnwidget.render.WRenderer;
import com.kamesuta.mc.signpic.Config;
import com.kamesuta.mc.signpic.ILoadCancelable;
import com.kamesuta.mc.signpic.attr.AttrReaders;
import com.kamesuta.mc.signpic.attr.prop.SizeData;
import com.kamesuta.mc.signpic.entry.IAsyncProcessable;
import com.kamesuta.mc.signpic.entry.ICollectable;
import com.kamesuta.mc.signpic.entry.IDivisionProcessable;
import com.kamesuta.mc.signpic.entry.IInitable;
import com.kamesuta.mc.signpic.entry.content.Content;
import com.kamesuta.mc.signpic.image.ImageTexture;
import com.kamesuta.mc.signpic.state.StateType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class Image
implements IInitable,
IAsyncProcessable,
IDivisionProcessable,
ICollectable,
ILoadCancelable {
    @Nonnull
    protected final Content content;

    public Image(@Nonnull Content content) {
        this.content = content;
    }

    @Nonnull
    public abstract ImageTexture getTexture() throws IllegalStateException;

    @Nonnull
    public abstract String getLocal();

    @Nonnull
    public SizeData getSize() {
        if (this.content.state.getType() == StateType.AVAILABLE) {
            return this.getTexture().getSize();
        }
        return SizeData.DefaultSize;
    }

    public void draw(@Nullable Area vertex, @Nullable Area trim, @Nullable Area texture, @Nullable WRenderer.BlendType b, @Nullable WRenderer.BlendType d, boolean r, boolean m, boolean l) {
        if (this.content.state.getType() == StateType.AVAILABLE) {
            WRenderer.startTexture(b, d);
            if (l) {
                OpenGL.glEnable(2896);
            }
            ImageTexture image = this.getTexture();
            image.bind();
            int wraps = OpenGL.glGetTexParameteri(3553, 10242);
            int wrapt = OpenGL.glGetTexParameteri(3553, 10243);
            int mag = OpenGL.glGetTexParameteri(3553, 10240);
            int min = OpenGL.glGetTexParameteri(3553, 10241);
            if (r) {
                OpenGL.glTexParameteri(3553, 10242, 10497);
                OpenGL.glTexParameteri(3553, 10243, 10497);
            } else {
                OpenGL.glTexParameteri(3553, 10242, 10496);
                OpenGL.glTexParameteri(3553, 10243, 10496);
            }
            if (image.hasMipmap()) {
                if (m && OpenGL.openGl30() && Config.getConfig().renderUseMipmap.get().booleanValue()) {
                    OpenGL.glTexParameteri(3553, 10240, Config.getConfig().renderMipmapTypeNearest.get() != false ? 9728 : 9729);
                    OpenGL.glTexParameteri(3553, 10241, Config.getConfig().renderMipmapTypeNearest.get() != false ? 9986 : 9987);
                } else {
                    OpenGL.glTexParameteri(3553, 10240, 9728);
                    OpenGL.glTexParameteri(3553, 10241, 9729);
                }
            }
            WGui.drawTexture(vertex, trim, texture);
            OpenGL.glTexParameteri(3553, 10242, wraps);
            OpenGL.glTexParameteri(3553, 10243, wrapt);
            if (image.hasMipmap()) {
                OpenGL.glTexParameteri(3553, 10240, mag);
                OpenGL.glTexParameteri(3553, 10241, min);
            }
            WRenderer.startTexture();
        }
    }

    public void draw(@Nonnull AttrReaders meta, @Nullable Area vertex, @Nullable Area trim) {
        this.draw(vertex, trim, Area.size(meta.u.getMovie().get().data, meta.v.getMovie().get().data, meta.w.getMovie().get().data / meta.c.getMovie().get().data, meta.h.getMovie().get().data / meta.s.getMovie().get().data), meta.b.getMovie().get().data, meta.d.getMovie().get().data, meta.r.getMovie().get().data, meta.m.getMovie().get().data, meta.l.getMovie().get().data);
    }

    public void draw(@Nonnull AttrReaders meta) {
        this.draw(meta, null, null);
    }
}

