/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.image;

import com.google.common.collect.Lists;
import com.kamesuta.mc.signpic.Config;
import com.kamesuta.mc.signpic.ILoadCancelable;
import com.kamesuta.mc.signpic.LoadCanceledException;
import com.kamesuta.mc.signpic.attr.prop.SizeData;
import com.kamesuta.mc.signpic.entry.content.Content;
import com.kamesuta.mc.signpic.entry.content.ContentLocation;
import com.kamesuta.mc.signpic.image.DynamicImageTexture;
import com.kamesuta.mc.signpic.image.InvaildImageException;
import com.kamesuta.mc.signpic.image.RemoteImageTexture;
import com.kamesuta.mc.signpic.lib.GifDecoder;
import com.kamesuta.mc.signpic.state.Progress;
import com.kamesuta.mc.signpic.state.StateType;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ImageIOLoader
implements ILoadCancelable {
    @Nonnull
    public static SizeData MAX_SIZE = ImageIOLoader.maxSize(Config.getConfig().imageWidthLimit.get(), Config.getConfig().imageHeightLimit.get());
    public static float DefaultDelay = 0.05f;
    @Nonnull
    protected Content content;
    @Nonnull
    protected InputFactory input;
    private boolean canceled;

    @Nonnull
    public static SizeData maxSize(int limitWidth, int limitHeight) {
        return SizeData.create(limitWidth > 0 ? (float)limitWidth : Float.NaN, limitHeight > 0 ? (float)limitHeight : Float.NaN);
    }

    public ImageIOLoader(@Nonnull Content content, @Nonnull InputFactory inputFactory) throws IOException {
        this.content = content;
        this.input = inputFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public RemoteImageTexture load() throws IOException {
        RemoteImageTexture remoteImageTexture;
        InputStream stream = null;
        try {
            stream = this.input.createInput();
            ImageInputStream imagestream = ImageIO.createImageInputStream(stream);
            Iterator<ImageReader> iter = ImageIO.getImageReaders(imagestream);
            if (!iter.hasNext()) {
                throw new InvaildImageException();
            }
            ImageReader reader = iter.next();
            this.content.state.setType(StateType.LOADING);
            this.content.state.setProgress(new Progress());
            RemoteImageTexture textures = Config.getConfig().imageAnimationGif.get() != false && reader.getFormatName() == "gif" ? this.loadGif() : this.loadImage(reader, imagestream);
            this.content.state.setType(StateType.LOADED);
            remoteImageTexture = textures;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
        return remoteImageTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private RemoteImageTexture loadGif() throws IOException {
        RemoteImageTexture remoteImageTexture;
        InputStream stream = null;
        try {
            stream = this.input.createInput();
            GifDecoder.GifImage gifImage = GifDecoder.read(stream);
            int width = gifImage.getWidth();
            int height = gifImage.getHeight();
            SizeData newsize = SizeData.ImageSizes.LIMIT.defineSize(width, (float)height, MAX_SIZE);
            ArrayList textures = Lists.newArrayList();
            int frameCount = gifImage.getFrameCount();
            this.content.state.getProgress().overall = frameCount;
            for (int i = 0; i < frameCount; ++i) {
                if (this.canceled) {
                    throw new LoadCanceledException();
                }
                BufferedImage image = gifImage.getFrame(i);
                int delay = gifImage.getDelay(i);
                textures.add(Pair.of((Object)Float.valueOf((float)delay / 100.0f), (Object)DynamicImageTexture.create(image, (int)newsize.getWidth(), (int)newsize.getHeight())));
                this.content.state.getProgress().done = i;
            }
            remoteImageTexture = new RemoteImageTexture(textures);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
        return remoteImageTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private RemoteImageTexture loadImage(@Nonnull ImageReader reader, @Nonnull ImageInputStream imagestream) throws IOException {
        BufferedImage canvas;
        ImageReadParam param = reader.getDefaultReadParam();
        reader.setInput(imagestream, true, true);
        try {
            canvas = reader.read(0, param);
        }
        finally {
            reader.dispose();
            imagestream.close();
        }
        SizeData newsize = SizeData.ImageSizes.LIMIT.defineSize(canvas.getWidth(), (float)canvas.getHeight(), MAX_SIZE);
        ArrayList textures = Lists.newArrayList();
        textures.add(Pair.of((Object)Float.valueOf(0.0f), (Object)DynamicImageTexture.create(canvas, (int)newsize.getWidth(), (int)newsize.getHeight())));
        return new RemoteImageTexture(textures);
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    public static interface InputFactory {
        @Nonnull
        public InputStream createInput() throws IOException;

        public static class ResourceInputFactory
        implements InputFactory {
            @Nonnull
            private IResourceManager manager;
            @Nonnull
            private ResourceLocation location;

            public ResourceInputFactory(@Nonnull IResourceManager manager, @Nonnull ResourceLocation location) {
                this.manager = manager;
                this.location = location;
            }

            @Override
            @Nonnull
            public InputStream createInput() throws IOException {
                return this.manager.func_110536_a(this.location).func_110527_b();
            }
        }

        public static class FileInputFactory
        implements InputFactory {
            @Nonnull
            private final File file;

            public FileInputFactory(@Nonnull File file) {
                this.file = file;
            }

            @Override
            @Nonnull
            public InputStream createInput() throws FileNotFoundException {
                return new FileInputStream(this.file);
            }

            @Nullable
            public static FileInputFactory createFromContent(@Nonnull Content content) {
                String id = content.meta.getCacheID();
                if (id != null) {
                    return new FileInputFactory(ContentLocation.cacheLocation(id));
                }
                return null;
            }
        }
    }
}

