/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.image;

import com.kamesuta.mc.signpic.image.DynamicImageTexture;
import com.kamesuta.mc.signpic.image.ImageTexture;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.Timer;

public class RemoteImageTexture {
    @Nonnull
    protected final Timer timer = new Timer();
    @Nonnull
    protected final List<Pair<Float, DynamicImageTexture>> textures;
    protected int currenttexture = 0;

    public RemoteImageTexture(@Nonnull List<Pair<Float, DynamicImageTexture>> textures) {
        this.textures = textures;
    }

    @Nonnull
    public ImageTexture get() {
        if (this.textures.size() == 1) {
            return ((DynamicImageTexture)this.textures.get(0).getRight()).load();
        }
        if (this.textures.size() > 1) {
            Pair<Float, DynamicImageTexture> texframe = this.textures.get(this.currenttexture);
            ((DynamicImageTexture)texframe.getRight()).load();
            if (this.timer.getTime() > ((Float)texframe.getLeft()).floatValue()) {
                this.timer.reset();
                this.currenttexture = this.currenttexture < this.textures.size() - 1 ? this.currenttexture + 1 : 0;
            }
            return (ImageTexture)this.textures.get(this.currenttexture).getRight();
        }
        return DynamicImageTexture.NULL;
    }

    @Nonnull
    public List<Pair<Float, DynamicImageTexture>> getAll() {
        return this.textures;
    }

    public void delete() {
        Iterator<Pair<Float, DynamicImageTexture>> itr = this.textures.iterator();
        while (itr.hasNext()) {
            Pair<Float, DynamicImageTexture> t = itr.next();
            ((DynamicImageTexture)t.getRight()).delete();
            itr.remove();
        }
    }
}

