/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.image;

import com.kamesuta.mc.signpic.entry.content.Content;
import com.kamesuta.mc.signpic.image.Image;
import com.kamesuta.mc.signpic.image.ImageTexture;
import com.kamesuta.mc.signpic.image.ResourceImageTexture;
import com.kamesuta.mc.signpic.state.StateType;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public class ResourceImage
extends Image {
    @Nonnull
    protected ResourceLocation resource;
    @Nonnull
    protected ResourceImageTexture texture;

    public ResourceImage(@Nonnull Content content) {
        super(content);
        this.resource = content.id.getResource();
        this.texture = new ResourceImageTexture(this.resource);
    }

    @Nonnull
    public String toString() {
        return String.format("ResourceImage[%s]", this.content.id);
    }

    @Override
    @Nonnull
    public String getLocal() {
        return "Resource:" + StringUtils.substring((String)this.content.id.getID(), (int)1);
    }

    @Override
    @Nonnull
    public ImageTexture getTexture() {
        return this.texture;
    }

    @Override
    public void onInit() {
        this.content.state.setType(StateType.AVAILABLE);
    }

    @Override
    public void onAsyncProcess() {
    }

    @Override
    public boolean onDivisionProcess() {
        return true;
    }

    @Override
    public void onCollect() {
    }

    @Override
    public void cancel() {
    }
}

