/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.information;

import com.kamesuta.mc.signpic.Client;
import com.kamesuta.mc.signpic.Config;
import com.kamesuta.mc.signpic.CoreEvent;
import com.kamesuta.mc.signpic.Log;
import com.kamesuta.mc.signpic.http.Communicator;
import com.kamesuta.mc.signpic.http.ICommunicateCallback;
import com.kamesuta.mc.signpic.http.ICommunicateResponse;
import com.kamesuta.mc.signpic.http.download.ModDownload;
import com.kamesuta.mc.signpic.information.Info;
import com.kamesuta.mc.signpic.information.InformationCheck;
import com.kamesuta.mc.signpic.util.ChatBuilder;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public final class Informations {
    @Nonnull
    public static final Informations instance = new Informations();
    @Nonnull
    public static final Version VersionClient = new Version("2.8.1");
    @Nullable
    private InfoSource source;
    @Nonnull
    private InfoState state = new InfoState();
    private long lastCheck = -1L;

    private Informations() {
    }

    public void setSource(@Nonnull InfoSource source) {
        if (!InfoSource.equalsVersion(this.source, source)) {
            this.state = new InfoState();
        }
        this.source = source;
    }

    @Nullable
    public InfoSource getSource() {
        return this.source;
    }

    @Nonnull
    public InfoState getState() {
        return this.state;
    }

    public void init() {
        this.onlineCheck(null);
    }

    public boolean shouldCheck(long l) {
        return System.currentTimeMillis() - this.lastCheck > l;
    }

    public long getLastCheck() {
        return this.lastCheck;
    }

    public void check() {
        this.getState().triedToWarnPlayer = false;
        if (!this.isUpdateRequired()) {
            Log.notice(I18n.func_135052_a((String)"signpic.versioning.noupdate", (Object[])new Object[0]));
        }
    }

    public void onlineCheck(final @Nullable Runnable after) {
        this.lastCheck = System.currentTimeMillis();
        final InformationCheck checker = new InformationCheck();
        checker.setCallback(new ICommunicateCallback(){

            @Override
            public void onDone(ICommunicateResponse res) {
                if (checker.result != null) {
                    Informations.this.setSource(checker.result);
                }
                if (res.getError() != null) {
                    Log.log.warn("Could not check version information", res.getError());
                }
                if (after != null) {
                    after.run();
                }
            }
        });
        Communicator.instance.communicate(checker);
    }

    public boolean isUpdateRequired() {
        InfoSource source = this.getSource();
        if (source != null) {
            return !StringUtils.equals((CharSequence)"2.8.1", (CharSequence)"${version}") && source.onlineVersion().compare(VersionClient);
        }
        return false;
    }

    @Nullable
    public String getUpdateMessage() {
        InfoSource source = this.getSource();
        if (source != null) {
            InfoVersion online = source.onlineVersion();
            if (online.version != null) {
                String lang = Client.mc.field_71474_y.field_74363_ab;
                Info.Version version = online.version;
                if (version != null) {
                    Map<String, String> local = version.message_local;
                    if (local != null && local.containsKey(lang)) {
                        return local.get(lang);
                    }
                    if (!StringUtils.isEmpty((CharSequence)version.message)) {
                        return version.message;
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    public String getUpdateImage() {
        InfoSource src = this.source;
        if (src != null) {
            String image;
            InfoVersion online = src.onlineVersion();
            Info.Version version = online.version;
            if (version != null && (image = version.image) != null && !StringUtils.isEmpty((CharSequence)image)) {
                return image;
            }
        }
        return null;
    }

    public void runUpdate() {
        Info.Version version;
        InfoState state = this.getState();
        InfoSource source = this.getSource();
        if (source != null && (version = source.onlineVersion().version) != null && !StringUtils.isEmpty((CharSequence)version.remote)) {
            if (state.isDownloaded()) {
                ChatBuilder.create("signpic.versioning.downloadedAlready").useTranslation().setStyle(new Style().func_150238_a(TextFormatting.RED)).chatClient();
                Log.notice(I18n.func_135052_a((String)"signpic.gui.notice.versioning.downloadedAlready", (Object[])new Object[0]));
                try {
                    Desktop.getDesktop().open(Client.getLocation().modDir.getCanonicalFile());
                }
                catch (IOException e) {
                    Log.log.error(e.getMessage(), (Throwable)e);
                }
            } else if (state.downloading) {
                ChatBuilder.create("signpic.versioning.downloadingAlready").useTranslation().setStyle(new Style().func_150238_a(TextFormatting.RED)).chatClient();
                Log.notice(I18n.func_135052_a((String)"signpic.gui.notice.versioning.downloadingAlready", (Object[])new Object[0]));
            } else {
                final ModDownload downloader = new ModDownload();
                downloader.getState().getMeta().put("gui.highlight", true);
                downloader.getState().getMeta().put("gui.showpanel", Float.valueOf(3.0f));
                downloader.setCallback(new ICommunicateCallback(){

                    @Override
                    public void onDone(ICommunicateResponse res) {
                        ModDownload.ModDLResult result = downloader.result;
                        if (result != null) {
                            new ChatBuilder().setChat(result.response).chatClient();
                        }
                    }
                });
                Communicator.instance.communicate(downloader);
            }
        }
    }

    @CoreEvent
    public void onTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.onTick(this.getSource(), this.getState());
        }
    }

    public void notice(@Nullable InfoSource source, @Nullable InfoState state, @Nullable EntityPlayer player) {
        if (player != null && source != null && state != null) {
            Info.PrivateMsg msg;
            Info.Version version;
            InfoVersion online;
            String lang = Client.mc.field_71474_y.field_74363_ab;
            if (source.info.versions != null && !StringUtils.equals((CharSequence)"2.8.1", (CharSequence)"${version}") && (online = source.onlineVersion()).compare(VersionClient) && (version = online.version) != null && version.version != null) {
                String ver = version.version;
                Map<String, String> local = version.message_local;
                if (local != null && local.containsKey(lang)) {
                    ChatBuilder.create("signpic.versioning.changelog").useTranslation().setParams(local.get(lang)).chatClient();
                } else if (!StringUtils.isEmpty((CharSequence)version.message)) {
                    ChatBuilder.create("signpic.versioning.changelog").useTranslation().setParams(version.message).chatClient();
                }
                String website = version.website != null ? version.website : (source.info.website != null ? source.info.website : "https://github.com/Team-Fruit/SignPicture/");
                String changelog = version.changelog != null ? version.changelog : (source.info.changelog != null ? source.info.changelog : "https://github.com/Team-Fruit/SignPicture/releases");
                ChatBuilder.create("signpic.versioning.updateMessage").useTranslation().useJson().replace("$old$", "2.8.1").replace("$new$", ver).replace("$download$", "{\"action\":\"run_command\",\"value\":\"/signpic version update\"}").replace("$website$", "{\"action\":\"open_url\",\"value\":\"" + website + "\"}").replace("$changelog$", "{\"action\":\"open_url\",\"value\":\"" + changelog + "\"}").chatClient();
            }
            if ((msg = source.privateMsg) != null) {
                ChatBuilder ctb = new ChatBuilder();
                Map<String, String> local = msg.message_local;
                if (local != null && local.containsKey(lang)) {
                    ctb.setText(local.get(lang));
                } else {
                    String m = msg.message;
                    if (m != null && !StringUtils.isEmpty((CharSequence)m)) {
                        ctb.setText(m);
                    }
                    if (msg.json) {
                        ctb.useJson();
                    }
                    ctb.chatClient();
                }
            }
            this.getState().triedToWarnPlayer = true;
        }
    }

    public void onTick(@Nullable InfoSource source, @Nonnull InfoState state) {
        EntityPlayerSP player = Client.mc.field_71439_g;
        if (Config.getConfig().informationNotice.get().booleanValue() && !state.triedToWarnPlayer) {
            this.notice(source, state, (EntityPlayer)player);
        }
    }

    public static class InfoVersion
    extends Version {
        @Nullable
        public final Info.Version version;

        public InfoVersion(int major, int minor, int micro, boolean beta, @Nullable Info.Version version) {
            super(major, minor, micro, beta);
            this.version = version;
        }

        public InfoVersion(@Nullable Info.Version version) {
            super(version != null ? version.version : "");
            this.version = version;
        }

        public InfoVersion() {
            this(0, 0, 0, false, null);
        }
    }

    public static class Version {
        public final int major;
        public final int minor;
        public final int micro;
        public final boolean beta;

        public Version(int major, int minor, int micro, boolean beta) {
            this.major = major;
            this.minor = minor;
            this.micro = micro;
            this.beta = beta;
        }

        public Version(@Nullable String string) {
            String[] v = StringUtils.split((String)string, (String)"\\.");
            this.major = v != null && v.length >= 1 ? NumberUtils.toInt((String)v[0], (int)0) : 0;
            this.minor = v != null && v.length >= 2 ? NumberUtils.toInt((String)v[1], (int)0) : 0;
            this.micro = v != null && v.length >= 3 ? NumberUtils.toInt((String)v[2], (int)0) : 0;
            this.beta = v != null && v.length >= 4 && StringUtils.equals((CharSequence)v[3], (CharSequence)"beta");
        }

        public Version() {
            this(0, 0, 0, false);
        }

        public boolean compare(@Nonnull Version version) {
            return this.major > version.major || this.major == version.major && this.minor > version.minor || this.major == version.major && this.minor == version.minor && this.micro > version.micro || this.major == version.major && this.minor == version.minor && this.micro == version.micro && this.beta && !version.beta;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.beta ? 1231 : 1237);
            result = 31 * result + this.major;
            result = 31 * result + this.micro;
            result = 31 * result + this.minor;
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Version)) {
                return false;
            }
            Version other = (Version)obj;
            if (this.beta != other.beta) {
                return false;
            }
            if (this.major != other.major) {
                return false;
            }
            if (this.micro != other.micro) {
                return false;
            }
            return this.minor == other.minor;
        }
    }

    public static class InfoState {
        public boolean triedToWarnPlayer = false;
        public boolean downloading = false;
        @Nullable
        public File downloadedFile;

        public boolean isDownloaded() {
            if (this.downloadedFile != null) {
                return this.downloadedFile.exists();
            }
            return false;
        }
    }

    public static class InfoSource {
        @Nonnull
        public Info info;
        @Nullable
        public Info.PrivateMsg privateMsg;

        public InfoSource(@Nonnull Info info) {
            this.info = info;
        }

        @Nonnull
        public InfoVersion stableVersion() {
            if (this.info.versions != null) {
                return new InfoVersion(this.info.versions.get(Client.mcversion));
            }
            return new InfoVersion();
        }

        @Nonnull
        public InfoVersion unstableVersion() {
            if (this.info.versions != null) {
                return new InfoVersion(this.info.versions.get(Client.mcversion + "-beta"));
            }
            return new InfoVersion();
        }

        @Nonnull
        public InfoVersion onlineVersion() {
            InfoVersion stable = this.stableVersion();
            InfoVersion unstable = this.unstableVersion();
            return Config.getConfig().informationJoinBeta.get() != false && unstable.compare(stable) ? unstable : stable;
        }

        public static boolean equalsVersion(@Nullable InfoSource a, @Nullable InfoSource b) {
            if (a == null || b == null) {
                return false;
            }
            InfoVersion stable = a.stableVersion();
            InfoVersion unstable = b.stableVersion();
            return stable.equals(b.stableVersion()) && unstable.equals(b.unstableVersion());
        }
    }
}

