/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.lib;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GifDecoder {
    static final int[] MASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};

    public static final GifImage read(byte[] in) throws IOException {
        GifDecoder dec = new GifDecoder();
        GifImage img = dec.new GifImage();
        List frames = img.frames;
        GifFrame frame = null;
        int pos = GifDecoder.readHeader(in, img);
        pos = GifDecoder.readLogicalScreenDescriptor(img, in, pos);
        if (img.hasGlobColTbl) {
            img.globalColTbl = new int[img.sizeOfGlobColTbl];
            pos = GifDecoder.readColTbl(in, img.globalColTbl, pos);
        }
        block11: while (pos < in.length) {
            int block = in[pos] & 0xFF;
            switch (block) {
                case 33: {
                    if (pos + 1 >= in.length) {
                        throw new IOException("Unexpected end of file.");
                    }
                    switch (in[pos + 1] & 0xFF) {
                        case 254: {
                            pos = GifDecoder.readTextExtension(in, pos);
                            continue block11;
                        }
                        case 255: {
                            pos = GifDecoder.readAppExt(img, in, pos);
                            continue block11;
                        }
                        case 1: {
                            frame = null;
                            pos = GifDecoder.readTextExtension(in, pos);
                            continue block11;
                        }
                        case 249: {
                            if (frame == null) {
                                frame = dec.new GifFrame();
                                frames.add(frame);
                            }
                            pos = GifDecoder.readGraphicControlExt(frame, in, pos);
                            continue block11;
                        }
                    }
                    throw new IOException("Unknown extension at " + pos);
                }
                case 44: {
                    if (frame == null) {
                        frame = dec.new GifFrame();
                        frames.add(frame);
                    }
                    pos = GifDecoder.readImgDescr(frame, in, pos);
                    if (frame.hasLocColTbl) {
                        GifFrame.access$1602(frame, new int[frame.sizeOfLocColTbl]);
                        pos = GifDecoder.readColTbl(in, frame.localColTbl, pos);
                    }
                    pos = GifDecoder.readImgData(frame, in, pos);
                    frame = null;
                    continue block11;
                }
                case 59: {
                    return img;
                }
            }
            double progress = 1.0 * (double)pos / (double)in.length;
            if (progress < 0.9) {
                throw new IOException("Unknown block at: " + pos);
            }
            pos = in.length;
        }
        return img;
    }

    public static final GifImage read(InputStream is) throws IOException {
        int numBytes = is.available();
        byte[] data = new byte[numBytes];
        is.read(data, 0, numBytes);
        return GifDecoder.read(data);
    }

    static final int readAppExt(GifImage img, byte[] in, int i) {
        img.appId = new String(in, i + 3, 8);
        img.appAuthCode = new String(in, i + 11, 3);
        int subBlockSize = in[i += 14] & 0xFF;
        if (subBlockSize == 3) {
            img.repetitions = in[i + 2] & 0xFF | in[i + 3] & 0xFF00;
            return i + 5;
        }
        while ((in[i] & 0xFF) != 0) {
            i += (in[i] & 0xFF) + 1;
        }
        return i + 1;
    }

    static final int readColTbl(byte[] in, int[] colors, int i) {
        int numColors = colors.length;
        for (int c = 0; c < numColors; ++c) {
            int a = 255;
            int r = in[i++] & 0xFF;
            int g = in[i++] & 0xFF;
            int b = in[i++] & 0xFF;
            colors[c] = ((0xFF00 | r) << 8 | g) << 8 | b;
        }
        return i;
    }

    static final int readGraphicControlExt(GifFrame fr, byte[] in, int i) {
        fr.disposalMethod = (in[i + 3] & 0x1C) >>> 2;
        fr.transpColFlag = (in[i + 3] & 1) == 1;
        fr.delay = in[i + 4] & 0xFF | (in[i + 5] & 0xFF) << 8;
        fr.transpColIndex = in[i + 6] & 0xFF;
        return i + 8;
    }

    static final int readHeader(byte[] in, GifImage img) throws IOException {
        if (in.length < 6) {
            throw new IOException("Image is truncated.");
        }
        img.header = new String(in, 0, 6);
        if (!img.header.equals("GIF87a") && !img.header.equals("GIF89a")) {
            throw new IOException("Invalid GIF header.");
        }
        return 6;
    }

    static final int readImgData(GifFrame fr, byte[] in, int i) {
        int fileSize = in.length;
        int minCodeSize = in[i++] & 0xFF;
        int clearCode = 1 << minCodeSize;
        fr.firstCodeSize = minCodeSize + 1;
        fr.clearCode = clearCode;
        fr.endOfInfoCode = clearCode + 1;
        int imgDataSize = GifDecoder.readImgDataSize(in, i);
        byte[] imgData = new byte[imgDataSize + 2];
        int imgDataPos = 0;
        int subBlockSize = in[i] & 0xFF;
        while (subBlockSize > 0) {
            try {
                int nextSubBlockSizePos = i + subBlockSize + 1;
                int nextSubBlockSize = in[nextSubBlockSizePos] & 0xFF;
                System.arraycopy(in, i + 1, imgData, imgDataPos, subBlockSize);
                imgDataPos += subBlockSize;
                i = nextSubBlockSizePos;
                subBlockSize = nextSubBlockSize;
            }
            catch (Exception e) {
                subBlockSize = fileSize - i - 1;
                System.arraycopy(in, i + 1, imgData, imgDataPos, subBlockSize);
                imgDataPos += subBlockSize;
                i += subBlockSize + 1;
                break;
            }
        }
        GifFrame.access$602(fr, imgData);
        return ++i;
    }

    static final int readImgDataSize(byte[] in, int i) {
        int fileSize = in.length;
        int imgDataPos = 0;
        int subBlockSize = in[i] & 0xFF;
        while (subBlockSize > 0) {
            try {
                int nextSubBlockSizePos = i + subBlockSize + 1;
                int nextSubBlockSize = in[nextSubBlockSizePos] & 0xFF;
                imgDataPos += subBlockSize;
                i = nextSubBlockSizePos;
                subBlockSize = nextSubBlockSize;
            }
            catch (Exception e) {
                subBlockSize = fileSize - i - 1;
                imgDataPos += subBlockSize;
                break;
            }
        }
        return imgDataPos;
    }

    static final int readImgDescr(GifFrame fr, byte[] in, int i) {
        fr.left = in[++i] & 0xFF | (in[++i] & 0xFF) << 8;
        fr.top = in[++i] & 0xFF | (in[++i] & 0xFF) << 8;
        fr.width = in[++i] & 0xFF | (in[++i] & 0xFF) << 8;
        fr.height = in[++i] & 0xFF | (in[++i] & 0xFF) << 8;
        byte b = in[++i];
        fr.hasLocColTbl = (b & 0x80) >>> 7 == 1;
        fr.interlaceFlag = (b & 0x40) >>> 6 == 1;
        fr.sortFlag = (b & 0x20) >>> 5 == 1;
        int colTblSizePower = (b & 7) + 1;
        fr.sizeOfLocColTbl = 1 << colTblSizePower;
        return ++i;
    }

    static final int readLogicalScreenDescriptor(GifImage img, byte[] in, int i) {
        img.width = in[i] & 0xFF | (in[i + 1] & 0xFF) << 8;
        img.height = in[i + 2] & 0xFF | (in[i + 3] & 0xFF) << 8;
        img.wh = img.width * img.height;
        img.pxBuffer = new int[img.wh];
        byte b = in[i + 4];
        img.hasGlobColTbl = (b & 0x80) >>> 7 == 1;
        int colResPower = ((b & 0x70) >>> 4) + 1;
        img.colorResolution = 1 << colResPower;
        img.sortFlag = (b & 8) >>> 3 == 1;
        int globColTblSizePower = (b & 7) + 1;
        img.sizeOfGlobColTbl = 1 << globColTblSizePower;
        img.bgColIndex = in[i + 5] & 0xFF;
        img.pxAspectRatio = in[i + 6] & 0xFF;
        return i + 7;
    }

    static final int readTextExtension(byte[] in, int pos) {
        int i = pos + 2;
        int subBlockSize = in[i++] & 0xFF;
        while (subBlockSize != 0 && i < in.length) {
            i += subBlockSize;
            subBlockSize = in[i++] & 0xFF;
        }
        return i;
    }

    public final class GifImage {
        public String header;
        private int width;
        private int height;
        private int wh;
        public boolean hasGlobColTbl;
        public int colorResolution;
        public boolean sortFlag;
        public int sizeOfGlobColTbl;
        public int bgColIndex;
        public int pxAspectRatio;
        public int[] globalColTbl;
        private final List<GifFrame> frames = new ArrayList<GifFrame>(48);
        public String appId = "";
        public String appAuthCode = "";
        public int repetitions = 0;
        private BufferedImage img = null;
        private BufferedImage prevImg = null;
        private int prevIndex;
        private int prevDisposal;
        private final BitReader in = new BitReader();
        private final CodeTable codes = new CodeTable();
        public int[] pxBuffer;

        private final int[] decode(GifFrame fr, int[] activeColTbl) {
            this.codes.init(fr, activeColTbl);
            this.in.init(fr.data);
            int clearCode = fr.clearCode;
            int endCode = fr.endOfInfoCode;
            int[] out = this.pxBuffer;
            int[][] tbl = this.codes.tbl;
            int pxPos = 0;
            int currCodeSize = this.codes.clear();
            this.in.read(currCodeSize);
            int code = this.in.read(currCodeSize);
            int[] pixels = tbl[code];
            System.arraycopy(pixels, 0, out, pxPos, pixels.length);
            pxPos += pixels.length;
            try {
                while (true) {
                    int prevCode = code;
                    code = this.in.read(currCodeSize);
                    if (code == clearCode) {
                        currCodeSize = this.codes.clear();
                        code = this.in.read(currCodeSize);
                        pixels = tbl[code];
                        System.arraycopy(pixels, 0, out, pxPos, pixels.length);
                        pxPos += pixels.length;
                        continue;
                    }
                    if (code != endCode) {
                        int[] prevVals = tbl[prevCode];
                        int[] prevValsAndK = new int[prevVals.length + 1];
                        System.arraycopy(prevVals, 0, prevValsAndK, 0, prevVals.length);
                        if (code < this.codes.nextCode) {
                            pixels = tbl[code];
                            System.arraycopy(pixels, 0, out, pxPos, pixels.length);
                            pxPos += pixels.length;
                            prevValsAndK[prevVals.length] = tbl[code][0];
                        } else {
                            prevValsAndK[prevVals.length] = prevVals[0];
                            System.arraycopy(prevValsAndK, 0, out, pxPos, prevValsAndK.length);
                            pxPos += prevValsAndK.length;
                        }
                        currCodeSize = this.codes.add(prevValsAndK);
                        continue;
                    }
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            return out;
        }

        private final int[] deinterlace(int[] pixels, GifFrame fr) {
            int destPos;
            int destY;
            int y;
            int w = fr.width;
            int h = fr.height;
            int[] dest = new int[pixels.length];
            int group2 = (h + 7) / 8;
            int group3 = group2 + (h + 3) / 8;
            int group4 = group3 + (h + 1) / 4;
            for (y = 0; y < group2; ++y) {
                int destPos2 = w * y * 8;
                System.arraycopy(pixels, w * y, dest, destPos2, w);
            }
            for (y = group2; y < group3; ++y) {
                destY = (y - group2) * 8 + 4;
                destPos = w * destY;
                System.arraycopy(pixels, w * y, dest, destPos, w);
            }
            for (y = group3; y < group4; ++y) {
                destY = (y - group3) * 4 + 2;
                destPos = w * destY;
                System.arraycopy(pixels, w * y, dest, destPos, w);
            }
            for (y = group4; y < h; ++y) {
                destY = (y - group4) * 2 + 1;
                destPos = w * destY;
                System.arraycopy(pixels, w * y, dest, destPos, w);
            }
            return dest;
        }

        private final void drawFrame(GifFrame fr) {
            int[] activeColTbl;
            int bgCol = 0;
            if (fr.hasLocColTbl) {
                activeColTbl = fr.localColTbl;
            } else {
                activeColTbl = this.globalColTbl;
                if (!fr.transpColFlag) {
                    bgCol = this.globalColTbl[this.bgColIndex];
                }
            }
            switch (this.prevDisposal) {
                case 2: {
                    BufferedImage bgImage = this.prevImg;
                    int[] px = this.getPixels(bgImage);
                    Arrays.fill(px, bgCol);
                    this.prevImg = this.img;
                    this.img = bgImage;
                    break;
                }
                case 3: {
                    System.arraycopy(this.getPixels(this.prevImg), 0, this.getPixels(this.img), 0, this.wh);
                    break;
                }
                default: {
                    System.arraycopy(this.getPixels(this.img), 0, this.getPixels(this.prevImg), 0, this.wh);
                }
            }
            int[] pixels = this.decode(fr, activeColTbl);
            if (fr.interlaceFlag) {
                pixels = this.deinterlace(pixels, fr);
            }
            int w = fr.width;
            int h = fr.height;
            int numPixels = w * h;
            BufferedImage frame = new BufferedImage(w, h, 2);
            System.arraycopy(pixels, 0, this.getPixels(frame), 0, numPixels);
            Graphics2D g = this.img.createGraphics();
            g.drawImage((Image)frame, fr.left, fr.top, null);
            g.dispose();
        }

        public final int getBackgroundColor() {
            GifFrame frame = this.frames.get(0);
            if (frame.hasLocColTbl) {
                return frame.localColTbl[this.bgColIndex];
            }
            if (this.hasGlobColTbl) {
                return this.globalColTbl[this.bgColIndex];
            }
            return 0;
        }

        public final int getDelay(int index) {
            return this.frames.get(index).delay;
        }

        public final BufferedImage getFrame(int index) {
            if (this.img == null || index < this.prevIndex) {
                this.img = new BufferedImage(this.width, this.height, 2);
                this.prevImg = new BufferedImage(this.width, this.height, 2);
                this.prevIndex = -1;
                this.prevDisposal = 2;
            }
            int i = this.prevIndex + 1;
            while (i <= index) {
                GifFrame fr = this.frames.get(i);
                this.drawFrame(fr);
                this.prevIndex = i++;
                this.prevDisposal = fr.disposalMethod;
            }
            return this.img;
        }

        public final int getFrameCount() {
            return this.frames.size();
        }

        public final int getHeight() {
            return this.height;
        }

        private final int[] getPixels(BufferedImage img) {
            return ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        }

        public final int getWidth() {
            return this.width;
        }
    }

    final class GifFrame {
        private int disposalMethod;
        private boolean transpColFlag;
        private int delay;
        private int transpColIndex;
        private int left;
        private int top;
        private int width;
        private int height;
        private boolean hasLocColTbl;
        private boolean interlaceFlag;
        private boolean sortFlag;
        private int sizeOfLocColTbl;
        private int[] localColTbl;
        private int firstCodeSize;
        private int clearCode;
        private int endOfInfoCode;
        private byte[] data;

        GifFrame() {
        }

        static /* synthetic */ int[] access$1602(GifFrame x0, int[] x1) {
            x0.localColTbl = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$602(GifFrame x0, byte[] x1) {
            x0.data = x1;
            return x1;
        }
    }

    final class CodeTable {
        private final int[][] tbl = new int[4096][1];
        private int initTableSize;
        private int initCodeSize;
        private int initCodeLimit;
        private int currCodeSize;
        private int nextCode;
        private int nextCodeLimit;

        private final int add(int[] indices) {
            if (this.nextCode < 4096) {
                if (this.nextCode == this.nextCodeLimit && this.currCodeSize < 12) {
                    ++this.currCodeSize;
                    this.nextCodeLimit = MASK[this.currCodeSize];
                }
                this.tbl[this.nextCode++] = indices;
            }
            return this.currCodeSize;
        }

        private final int clear() {
            this.currCodeSize = this.initCodeSize;
            this.nextCodeLimit = this.initCodeLimit;
            this.nextCode = this.initTableSize;
            return this.currCodeSize;
        }

        private final void init(GifFrame fr, int[] activeColTbl) {
            int numColors = activeColTbl.length;
            this.initCodeSize = fr.firstCodeSize;
            this.initCodeLimit = MASK[this.initCodeSize];
            this.nextCode = this.initTableSize = fr.endOfInfoCode + 1;
            for (int c = numColors - 1; c >= 0; --c) {
                this.tbl[c][0] = activeColTbl[c];
            }
            this.tbl[((GifFrame)fr).clearCode] = new int[]{fr.clearCode};
            this.tbl[((GifFrame)fr).endOfInfoCode] = new int[]{fr.endOfInfoCode};
            if (fr.transpColFlag && fr.transpColIndex < numColors) {
                this.tbl[((GifFrame)fr).transpColIndex][0] = 0;
            }
        }
    }

    final class BitReader {
        private int bitPos;
        private byte[] in;

        BitReader() {
        }

        private final void init(byte[] in) {
            this.in = in;
            this.bitPos = 0;
        }

        private final int read(int bits) {
            int i = this.bitPos >>> 3;
            int rBits = this.bitPos & 7;
            int b0 = this.in[i++] & 0xFF;
            int b1 = this.in[i++] & 0xFF;
            int b2 = this.in[i] & 0xFF;
            int buf = ((b2 << 8 | b1) << 8 | b0) >>> rBits;
            this.bitPos += bits;
            return buf & MASK[bits];
        }
    }
}

