/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.mode;

import com.kamesuta.mc.signpic.entry.EntryId;
import com.kamesuta.mc.signpic.util.Sign;
import java.util.EnumSet;
import javax.annotation.Nonnull;

public class CurrentMode {
    @Nonnull
    public static final CurrentMode instance = new CurrentMode();
    private boolean isShortening;
    @Nonnull
    private EntryId handSign = EntryId.from("#{}");
    @Nonnull
    private EntryId entryId = EntryId.from("#{}");
    @Nonnull
    private Mode mode = Mode.NONE;
    @Nonnull
    private final EnumSet<State> states = EnumSet.noneOf(State.class);

    private CurrentMode() {
    }

    public void setShortening(boolean isShortening) {
        this.isShortening = isShortening;
    }

    public boolean isShortening() {
        return this.isShortening;
    }

    public void setMode(@Nonnull Mode mode) {
        this.mode = mode;
    }

    public void setMode() {
        this.mode = Mode.NONE;
    }

    public boolean isMode() {
        return this.getMode() != Mode.NONE;
    }

    public boolean isMode(@Nonnull Mode mode) {
        return this.getMode() == mode;
    }

    @Nonnull
    public Mode getMode() {
        return this.mode;
    }

    public void setState(@Nonnull State state, boolean enable) {
        if (enable) {
            this.states.add(state);
        } else {
            this.states.remove((Object)state);
        }
    }

    public boolean isState() {
        return !this.states.isEmpty();
    }

    public boolean isState(@Nonnull State state) {
        return this.states.contains((Object)state);
    }

    public void toggleState(@Nonnull State state) {
        this.setState(state, !this.isState(state));
    }

    public void setEntryId(@Nonnull EntryId sign) {
        this.entryId = sign;
        Sign.updatePreview(sign);
    }

    @Nonnull
    public EntryId getEntryId() {
        return this.entryId;
    }

    public void setHandSign(@Nonnull EntryId sign) {
        this.handSign = sign;
    }

    @Nonnull
    public EntryId getHandSign() {
        return this.handSign;
    }

    public static enum State {
        CONTINUE,
        SEE,
        PREVIEW,
        HIDE;

    }

    public static enum Mode {
        PLACE("signpic.over.mode.place"),
        OPTION("signpic.over.mode.option"),
        SETPREVIEW("signpic.over.mode.setpreview"),
        NONE("signpic.over.mode.none");

        @Nonnull
        public final String message;

        private Mode(String message) {
            this.message = message;
        }
    }
}

