/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.reflect.lib;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nonnull;

public class ModifierMatcher {
    @Nonnull
    private final Set<Integer> require = Sets.newHashSet();
    @Nonnull
    private final Set<Integer> deny = Sets.newHashSet();

    @Nonnull
    public ModifierMatcher require(int modifier) {
        this.require.add(modifier);
        this.deny.remove(modifier);
        return this;
    }

    @Nonnull
    public ModifierMatcher deny(int modifier) {
        this.require.remove(modifier);
        this.deny.add(modifier);
        return this;
    }

    @Nonnull
    public ModifierMatcher ignore(int modifier) {
        this.require.remove(modifier);
        this.deny.remove(modifier);
        return this;
    }

    public boolean match(int modifiers) {
        for (int req : this.require) {
            if (this.isMatchModifier(modifiers, req)) continue;
            return false;
        }
        for (int den : this.deny) {
            if (!this.isMatchModifier(modifiers, den)) continue;
            return false;
        }
        return true;
    }

    private boolean isMatchModifier(int modifiers, int modifier) {
        return (modifiers & modifier) != 0;
    }
}

