/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.reflect.lib;

import com.kamesuta.mc.signpic.asm.lib.RefName;
import com.kamesuta.mc.signpic.reflect.lib.ModifierMatcher;
import com.kamesuta.mc.signpic.reflect.lib.ReflectClass;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReflectField<T, S> {
    @Nullable
    public final Field refField;

    @Nullable
    public Field getReflectField() {
        return this.refField;
    }

    private ReflectField(@Nullable Field refField) {
        this.refField = refField;
    }

    @Nullable
    public S get(@Nullable T instance) {
        Field field = this.getReflectField();
        if (field != null) {
            try {
                Object o = field.get(instance);
                return (S)o;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean set(@Nullable T instance, @Nullable S value) {
        Field field = this.getReflectField();
        if (field != null) {
            try {
                field.set(instance, value);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Nonnull
    public static <F, G> ReflectField<F, G> getFieldFromType(@Nonnull ReflectClass<F> refClass, @Nullable ModifierMatcher matcher, @Nonnull Class<G> type) {
        Class<F> refClazz = refClass.getReflectClass();
        Field refFielz = null;
        if (refClazz != null) {
            try {
                Field[] fields;
                for (Field field : fields = refClazz.getDeclaredFields()) {
                    if (!type.equals(field.getType()) || matcher != null && !matcher.match(field.getModifiers())) continue;
                    field.setAccessible(true);
                    refFielz = field;
                    break;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new ReflectField(refFielz);
    }

    @Nonnull
    public static <F, G> ReflectField<F, G> getFieldFromName(@Nonnull ReflectClass<F> refClass, @Nonnull RefName refName, @Nullable ModifierMatcher matcher, @Nonnull Class<G> type) {
        Class<F> refClazz = refClass.getReflectClass();
        Field refFielz = null;
        if (refClazz != null) {
            try {
                Field field = refClazz.getDeclaredField(refName.name());
                if (type.equals(field.getType()) && (matcher == null || matcher.match(field.getModifiers()))) {
                    field.setAccessible(true);
                    refFielz = field;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new ReflectField(refFielz);
    }
}

