/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.reflect.lib;

import com.kamesuta.mc.signpic.asm.lib.RefName;
import com.kamesuta.mc.signpic.reflect.lib.ModifierMatcher;
import com.kamesuta.mc.signpic.reflect.lib.ReflectClass;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReflectMethod<T, S> {
    @Nullable
    public final Method refMethod;

    @Nullable
    public Method getReflectMethod() {
        return this.refMethod;
    }

    private ReflectMethod(@Nullable Method refMethod) {
        this.refMethod = refMethod;
    }

    @Nullable
    public S invoke(@Nullable T instance, Object ... params) {
        Method method = this.getReflectMethod();
        if (method != null) {
            try {
                Object o = method.invoke(instance, params);
                return (S)o;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nonnull
    public static <F, G> ReflectMethod<F, G> getMethodFromType(@Nonnull ReflectClass<F> refClass, @Nullable ModifierMatcher matcher, @Nonnull Class<G> returnType, Class<?> ... paramsType) {
        Class<F> refClazz = refClass.getReflectClass();
        Method refMethoz = null;
        if (refClazz != null) {
            try {
                Method[] methods;
                for (Method method : methods = refClazz.getDeclaredMethods()) {
                    if (!returnType.equals(method.getReturnType()) || !Arrays.equals(paramsType, method.getParameterTypes()) || matcher != null && !matcher.match(method.getModifiers())) continue;
                    method.setAccessible(true);
                    refMethoz = method;
                    break;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new ReflectMethod(refMethoz);
    }

    @Nonnull
    public static <F, G> ReflectMethod<F, G> getMethodFromName(@Nonnull ReflectClass<F> refClass, @Nonnull RefName refName, @Nullable ModifierMatcher matcher, @Nonnull Class<G> returnType, Class<?> ... paramsType) {
        Class<F> refClazz = refClass.getReflectClass();
        Method refMethoz = null;
        if (refClazz != null) {
            try {
                Method method = refClazz.getDeclaredMethod(refName.name(), paramsType);
                if (returnType.equals(method.getReturnType()) && (matcher == null || matcher.match(method.getModifiers()))) {
                    method.setAccessible(true);
                    refMethoz = method;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new ReflectMethod(refMethoz);
    }
}

