/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.render;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kamesuta.mc.bnnwidget.position.Area;
import com.kamesuta.mc.bnnwidget.render.OpenGL;
import com.kamesuta.mc.bnnwidget.render.WGui;
import com.kamesuta.mc.bnnwidget.render.WRenderer;
import com.kamesuta.mc.signpic.Config;
import com.kamesuta.mc.signpic.attr.AttrReaders;
import com.kamesuta.mc.signpic.attr.prop.SizeData;
import com.kamesuta.mc.signpic.entry.Entry;
import com.kamesuta.mc.signpic.entry.EntryId;
import com.kamesuta.mc.signpic.entry.EntryIdBuilder;
import com.kamesuta.mc.signpic.entry.content.Content;
import com.kamesuta.mc.signpic.state.StateType;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class CustomChatRender {
    private static int getChatWidth(@Nonnull GuiNewChat chat) {
        return MathHelper.func_76141_d((float)((float)chat.func_146228_f() / chat.func_146244_h()));
    }

    public static int hookDrawStringWithShadow(@Nonnull FontRenderer font, @Nonnull String str, float x, float y, int color, @Nonnull GuiNewChat chat, @Nonnull ChatLine chatline, int j2, float opacity) {
        if (chatline instanceof PicChatLine) {
            PicChatLine cline = (PicChatLine)chatline;
            OpenGL.glPushMatrix();
            OpenGL.glTranslatef(0.0f, j2, 0.0f);
            OpenGL.glColor4f(1.0f, 1.0f, 1.0f, opacity);
            cline.draw(chat, font.field_78288_b);
            OpenGL.glPopMatrix();
            WRenderer.startTexture();
        } else {
            font.func_175063_a(str, x, y, color);
        }
        return 0;
    }

    public static class PicChatHook {
        @Nonnull
        private final List<ChatLine> chatLinesHook;
        @Nonnull
        private final List<ChatLine> chatList = Lists.newArrayList();
        @Nonnull
        private final Map<PicChatID, PicChatNode> id2node = Maps.newHashMap();

        public boolean isEnable() {
            if (!Config.getConfig().chatpicEnable.get().booleanValue()) {
                return false;
            }
            return Config.getConfig().chatpicLine.get() > 0;
        }

        public int getLineSplit() {
            return Config.getConfig().chatpicLine.get();
        }

        public PicChatHook(@Nonnull List<ChatLine> chatLinesHook) {
            this.chatLinesHook = chatLinesHook;
        }

        public void updateLines() {
            if (!this.isEnable()) {
                return;
            }
            List<ChatLine> clist = this.chatList;
            clist.clear();
            List<ChatLine> list = this.chatLinesHook;
            for (ChatLine line : list) {
                if (line instanceof PicChatLine) continue;
                clist.add(0, line);
            }
            list.clear();
            LinkedList lineunits = Lists.newLinkedList();
            LinkedList _lineunits = Lists.newLinkedList();
            int _lastlineunits = -1;
            for (ChatLine line : clist) {
                int stacktick;
                int id = line.func_74540_b();
                int diff = id - _lastlineunits;
                if (diff < -(stacktick = Config.getConfig().chatpicStackTick.get().intValue()) || stacktick < diff) {
                    lineunits.add(new PicChatID(_lastlineunits, _lineunits));
                    _lineunits = Lists.newLinkedList();
                }
                _lineunits.add(line);
                _lastlineunits = id;
            }
            if (_lineunits != null) {
                lineunits.add(new PicChatID(_lastlineunits, _lineunits));
            }
            for (PicChatID id : lineunits) {
                PicChatNode node = id.getNode(this.id2node, this.getLineSplit());
                for (ChatLine line : id.lines) {
                    list.add(0, line);
                }
                if (node.getEntries().isEmpty()) continue;
                for (int i = 0; i < node.getLineSplit(); ++i) {
                    list.add(0, new PicChatLine(node, i));
                }
            }
        }
    }

    public static class PicChatNode {
        @Nullable
        private List<ChatLine> linescache;
        @Nonnull
        private final List<EntryId> pendentryids = Lists.newLinkedList();
        @Nonnull
        private final List<Entry> entries = Lists.newLinkedList();
        private final int linesplit;
        public int updateCounterCreated;
        public int chatLineID;
        public float xpos;

        public PicChatNode(int linesplit) {
            this.linesplit = linesplit;
        }

        public void applyChatLines(@Nonnull List<ChatLine> lines) {
            if (!lines.equals(this.linescache)) {
                this.pendentryids.clear();
                int updateCounterCreated = -1;
                int chatLineID = -1;
                HashSet addedentries = Sets.newHashSet();
                for (ChatLine line : lines) {
                    updateCounterCreated = line.func_74540_b();
                    chatLineID = line.func_74539_c();
                    ITextComponent cc = line.func_151461_a();
                    List<ClickEvent> clinks = PicChatNode.getLinksFromChat(cc);
                    for (ClickEvent clink : clinks) {
                        EntryId entryid = new EntryIdBuilder().setURI(clink.func_150668_b()).build();
                        if (!addedentries.contains(entryid)) {
                            this.pendentryids.add(entryid);
                        }
                        addedentries.add(entryid);
                    }
                }
                this.updateCounterCreated = updateCounterCreated;
                this.chatLineID = chatLineID;
            }
            this.linescache = lines;
        }

        @Nonnull
        public List<Entry> getEntries() {
            this.entries.clear();
            for (EntryId pendentryid : this.pendentryids) {
                Entry pendentry = pendentryid.entry();
                Content content = pendentry.getContent();
                if (!pendentry.isValid() || content == null || content.state.getType() != StateType.AVAILABLE) continue;
                this.entries.add(pendentry);
            }
            return this.entries;
        }

        public String toString() {
            return String.format("PicChatNode [pendentryids=%s, updateCounterCreated=%s, chatLineID=%s]", this.pendentryids, this.updateCounterCreated, this.chatLineID);
        }

        @Nonnull
        public static List<ClickEvent> getLinksFromChat(@Nonnull ITextComponent chat) {
            LinkedList list = Lists.newLinkedList();
            PicChatNode.getLinksFromChat0(list, chat);
            return list;
        }

        private static void getLinksFromChat0(@Nonnull List<ClickEvent> list, @Nonnull ITextComponent pchat) {
            List chats = pchat.func_150253_a();
            for (Object o : chats) {
                ITextComponent chat = (ITextComponent)o;
                ClickEvent ev = chat.func_150256_b().func_150235_h();
                if (ev != null && ev.func_150669_a() == ClickEvent.Action.OPEN_URL) {
                    list.add(ev);
                }
                PicChatNode.getLinksFromChat0(list, chat);
            }
        }

        public int getLineSplit() {
            return this.linesplit;
        }
    }

    public static class PicChatID {
        public final int id;
        @Nonnull
        public final List<ChatLine> lines;

        public PicChatID(int id, @Nonnull List<ChatLine> lines) {
            this.id = id;
            this.lines = lines;
        }

        @Nonnull
        public PicChatNode getNode(@Nonnull Map<PicChatID, PicChatNode> id2node, int linesplit) {
            PicChatNode node = id2node.get(this);
            if (node == null) {
                node = new PicChatNode(linesplit);
                id2node.put(this, node);
            }
            node.applyChatLines(this.lines);
            return node;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PicChatID)) {
                return false;
            }
            PicChatID other = (PicChatID)obj;
            return this.id == other.id;
        }

        public String toString() {
            return String.format("PicChatID [id=%s]", this.id);
        }
    }

    public static class PicChatLine
    extends ChatLine {
        @Nonnull
        public static final ITextComponent dummytext = new TextComponentString("");
        @Nonnull
        private final PicChatNode node;
        public final int num;
        private final float space = 1.0f;
        private static final float offset = 4.0f;

        public PicChatLine(@Nonnull PicChatNode node, int num) {
            super(node.updateCounterCreated, dummytext, node.chatLineID);
            this.node = node;
            this.num = num;
        }

        @Nonnull
        private SizeData getContentWidth(@Nullable Content content, float widthlimit) {
            int fheight = WRenderer.font().field_78288_b;
            SizeData size1 = content != null ? content.image.getSize() : SizeData.DefaultSize;
            SizeData size2 = SizeData.ImageSizes.INNER.defineSize(size1, SizeData.create(widthlimit, fheight * this.node.getLineSplit()));
            return size2;
        }

        public void draw(@Nonnull GuiNewChat chat, float height) {
            int width = CustomChatRender.getChatWidth(chat);
            OpenGL.glPushMatrix();
            OpenGL.glTranslatef(0.0f, -9.0f, 0.0f);
            int linesplit = this.node.getLineSplit();
            float totalwidth = 4.0f;
            List<Entry> entries = this.node.getEntries();
            for (Entry entry : entries) {
                Content content = entry.getContent();
                totalwidth += this.getContentWidth(content, width).getWidth() + this.space;
            }
            float ix = 4.0f;
            if (totalwidth > (float)width) {
                ix -= (totalwidth - (float)width) * (this.node.xpos / (float)width);
            }
            Area trim = Area.size(0.0f, 0.0f, width, height);
            Area vert = WGui.defaultTextureArea.translate(0.0f, -height * (float)this.num);
            int color = OpenGL.glGetColorRGBA();
            Area lvert = vert.scaleSize(1.0f, height * (float)linesplit).translate(ix - 2.0f, 0.0f);
            WRenderer.startShape();
            OpenGL.glColor4f(0.5f, 0.5f, 0.5f, 0.5f);
            WGui.draw(lvert.trimArea(trim));
            OpenGL.glColorRGBA(color);
            WRenderer.startTexture();
            for (Entry entry : entries) {
                if (ix > (float)width) break;
                Content content = entry.getContent();
                SizeData size2 = this.getContentWidth(content, width);
                float w = size2.getWidth();
                float h = size2.getHeight();
                Area svert = vert.scaleSize(w, h).translate(ix, 0.0f);
                ix += w + this.space;
                if (content == null || content.state.getType() != StateType.AVAILABLE) continue;
                AttrReaders meta = entry.getMeta();
                content.image.draw(meta, svert, trim);
            }
            OpenGL.glPopMatrix();
        }

        @Nullable
        public ITextComponent onClicked(@Nonnull GuiNewChat chat, int x) {
            this.node.xpos = x;
            int width = CustomChatRender.getChatWidth(chat);
            float totalwidth = 4.0f;
            List<Entry> entries = this.node.getEntries();
            for (Entry entry : entries) {
                Content content = entry.getContent();
                totalwidth += this.getContentWidth(content, width).getWidth() + this.space;
            }
            float ix = 4.0f;
            if (totalwidth > (float)width) {
                ix -= (totalwidth - (float)width) * (this.node.xpos / (float)width);
            }
            for (Entry entry : this.node.getEntries()) {
                Content content = entry.getContent();
                if (!((float)x < (ix += this.getContentWidth(content, width).getWidth())) || content == null) continue;
                String url = content.id.getURI();
                return new TextComponentString("").func_150255_a(new Style().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(url))).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/signpic image open " + url)));
            }
            return null;
        }
    }
}

