/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.render;

import com.google.common.collect.ImmutableMap;
import com.kamesuta.mc.signpic.Log;
import com.kamesuta.mc.signpic.render.CustomItemSignRenderer;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.animation.IClip;

public class CustomItemSignModel
implements ICustomModelLoader {
    public static CustomItemSignModel INSTANCE = new CustomItemSignModel();
    @Nullable
    private ICustomModelLoader loader;

    private CustomItemSignModel() {
        try {
            this.loader = (ICustomModelLoader)this.getInstance();
        }
        catch (Exception e) {
            Log.log.warn("An error has occurred, ItemSignPicture won't work.", (Throwable)e);
        }
    }

    private <T extends Enum<T>> T getInstance() throws Exception {
        Class<?> $class = Class.forName("net.minecraftforge.client.model.ModelLoader$VanillaLoader");
        return (T)Enum.valueOf($class, "INSTANCE");
    }

    public void func_110549_a(@Nullable IResourceManager resourceManager) {
    }

    @Nullable
    public IModel loadModel(@Nullable ResourceLocation modelLocation) throws Exception {
        if (this.loader != null) {
            IModel model = this.loader.loadModel(modelLocation);
            return new ItemSignModel(model);
        }
        return ModelLoaderRegistry.getMissingModel();
    }

    public boolean accepts(@Nullable ResourceLocation modelLocation) {
        if (modelLocation != null && modelLocation.func_110624_b().equals("minecraft") && modelLocation.func_110623_a().equals("models/item/sign") && this.loader != null) {
            return this.loader.accepts(modelLocation);
        }
        return false;
    }

    public String toString() {
        return "CustomItemSignModel.INSTANCE";
    }

    public static class ItemSignModel
    implements IModel {
        private final IModel delegate;

        public ItemSignModel(IModel delegate) {
            this.delegate = delegate;
        }

        @Nullable
        public IBakedModel bake(@Nullable IModelState state, @Nullable VertexFormat format, @Nullable Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            IBakedModel bakedModel = this.delegate.bake(state, format, bakedTextureGetter);
            if (bakedModel != null) {
                CustomItemSignRenderer atlas6 = new CustomItemSignRenderer(bakedModel);
                return atlas6;
            }
            Log.log.error("Failed to register ItemSignPicture");
            return ModelLoaderRegistry.getMissingModel().bake(state, format, bakedTextureGetter);
        }

        public Collection<ResourceLocation> getDependencies() {
            return this.delegate.getDependencies();
        }

        public Collection<ResourceLocation> getTextures() {
            return this.delegate.getTextures();
        }

        public IModelState getDefaultState() {
            return this.delegate.getDefaultState();
        }

        public Optional<? extends IClip> getClip(@Nullable String name) {
            return this.delegate.getClip(name);
        }

        public IModel process(@Nullable ImmutableMap<String, String> customData) {
            return this.delegate.process(customData);
        }

        public IModel smoothLighting(boolean value) {
            return this.delegate.smoothLighting(value);
        }

        public IModel gui3d(boolean value) {
            return this.delegate.gui3d(value);
        }

        public IModel uvlock(boolean value) {
            return this.delegate.uvlock(value);
        }

        public IModel retexture(@Nullable ImmutableMap<String, String> textures) {
            return this.delegate.retexture(textures);
        }
    }
}

