/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.render;

import com.google.common.collect.ImmutableList;
import com.kamesuta.mc.bnnwidget.render.OpenGL;
import com.kamesuta.mc.bnnwidget.render.RenderOption;
import com.kamesuta.mc.signpic.attr.AttrReaders;
import com.kamesuta.mc.signpic.attr.prop.OffsetData;
import com.kamesuta.mc.signpic.attr.prop.RotationData;
import com.kamesuta.mc.signpic.attr.prop.SizeData;
import com.kamesuta.mc.signpic.entry.Entry;
import com.kamesuta.mc.signpic.entry.EntryId;
import com.kamesuta.mc.signpic.entry.content.Content;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.commons.lang3.tuple.Pair;

public class CustomItemSignRenderer
implements IBakedModel {
    @Deprecated
    @Nonnull
    public static final ModelResourceLocation modelResourceLocation = new ModelResourceLocation("minecraft:sign", "inventory");
    @Nonnull
    private final IBakedModel baseModel;
    @Nullable
    private ItemStack itemStack;
    private boolean isOverride;
    @Nonnull
    private final ItemOverrideList overrides = new ItemOverrideList((List)ImmutableList.of()){

        @Nullable
        public IBakedModel handleItemState(@Nullable IBakedModel originalModel, @Nullable ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            CustomItemSignRenderer.this.itemStack = stack;
            CustomItemSignRenderer.this.isOverride = stack != null && stack.func_77973_b() == Items.field_151155_ap && EntryId.fromItemStack(stack).entry().isValid();
            return CustomItemSignRenderer.this.baseModel.func_188617_f().handleItemState(originalModel, stack, world, entity);
        }
    };

    public CustomItemSignRenderer(@Nonnull IBakedModel model) {
        this.baseModel = model;
    }

    @Nullable
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nullable ItemCameraTransforms.TransformType cameraTransformType) {
        Pair pair = this.baseModel.handlePerspective(cameraTransformType);
        if (this.itemStack != null && cameraTransformType != null && this.isOverride) {
            OpenGL.glPushMatrix();
            if (pair.getRight() != null) {
                ForgeHooksClient.multiplyCurrentGlMatrix((Matrix4f)((Matrix4f)pair.getRight()));
            }
            OpenGL.glDisable(2884);
            this.renderItem(cameraTransformType, this.itemStack);
            OpenGL.glEnable(2896);
            OpenGL.glEnable(3042);
            OpenGL.glEnable(3553);
            OpenGL.glEnable(2884);
            OpenGL.glPopMatrix();
        }
        if (!this.isOverride) {
            return this.baseModel.handlePerspective(cameraTransformType);
        }
        return Pair.of((Object)this, null);
    }

    public void renderItem(@Nonnull ItemCameraTransforms.TransformType type, @Nullable ItemStack item) {
        OpenGL.glPushMatrix();
        OpenGL.glPushAttrib();
        OpenGL.glDisable(2884);
        Entry entry = EntryId.fromItemStack(item).entry();
        AttrReaders attr = entry.getMeta();
        Content content = entry.getContent();
        SizeData size01 = content != null ? content.image.getSize() : SizeData.DefaultSize;
        SizeData size = attr.sizes.getMovie().get().aspectSize(size01);
        OpenGL.glScalef(1.0f, -1.0f, 1.0f);
        if (type == ItemCameraTransforms.TransformType.GUI) {
            float slot = 1.0f;
            SizeData size2 = SizeData.ImageSizes.INNER.defineSize(size, 1.0f, 1.0f);
            OpenGL.glTranslatef((1.0f - size2.getWidth()) / 2.0f, (1.0f - size2.getHeight()) / 2.0f, 0.0f);
            OpenGL.glTranslatef(-0.5f, -0.5f, 0.0f);
            OpenGL.glScalef(1.0f, 1.0f, 1.0f);
            entry.getGui().drawScreen(0, 0, 0.0f, 1.0f, size2.getWidth() / 1.0f, size2.getHeight() / 1.0f, new RenderOption());
        } else {
            OpenGL.glScalef(2.0f, 2.0f, 1.0f);
            if (type == ItemCameraTransforms.TransformType.GROUND) {
                OpenGL.glTranslatef(-size.getWidth() / 2.0f, 0.25f, 0.0f);
            } else if (type == ItemCameraTransforms.TransformType.FIXED) {
                float f = 0.0078125f;
                OpenGL.glTranslatef(-size.getWidth() / 2.0f, 0.5f, 0.0078125f);
            } else if (type == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
                OpenGL.glScalef(-1.0f, 1.0f, 1.0f);
                OpenGL.glTranslatef(0.25f, 0.25f, 0.0f);
                OpenGL.glTranslatef(-size.getWidth(), 0.0f, 0.0f);
            } else if (type == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
                OpenGL.glTranslatef(-0.25f, 0.25f, 0.0f);
            } else if (type == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND) {
                OpenGL.glTranslatef(0.25f, 0.25f, 0.0f);
                OpenGL.glTranslatef(-size.getWidth(), 0.0f, 0.0f);
            } else if (type == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
                OpenGL.glTranslatef(-0.25f, 0.25f, 0.0f);
            } else if (type == ItemCameraTransforms.TransformType.HEAD) {
                OpenGL.glTranslatef(-size.getWidth() / 2.0f, 0.25f, 0.0f);
            }
            OpenGL.glTranslatef(0.0f, -size.getHeight(), 0.0f);
            OffsetData offset = attr.offsets.getMovie().get();
            OpenGL.glTranslatef(offset.x.offset, offset.y.offset, offset.z.offset);
            RotationData.RotationGL.glRotate(attr.rotations.getMovie().get().getRotate());
            entry.getGui().drawScreen(0, 0, 0.0f, 1.0f, size.getWidth(), size.getHeight(), new RenderOption());
        }
        OpenGL.glPopAttrib();
        OpenGL.glPopMatrix();
    }

    public boolean func_177556_c() {
        return this.baseModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.baseModel.func_188618_c();
    }

    @Nullable
    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    @Nullable
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public boolean func_177555_b() {
        return this.baseModel.func_177555_b();
    }

    @Nullable
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (this.isOverride) {
            return ImmutableList.of();
        }
        return this.baseModel.func_188616_a(state, side, rand);
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }
}

