/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.render;

import com.kamesuta.mc.bnnwidget.render.OpenGL;
import com.kamesuta.mc.bnnwidget.render.RenderOption;
import com.kamesuta.mc.bnnwidget.render.WRenderer;
import com.kamesuta.mc.signpic.Client;
import com.kamesuta.mc.signpic.Config;
import com.kamesuta.mc.signpic.attr.AttrReaders;
import com.kamesuta.mc.signpic.attr.prop.OffsetData;
import com.kamesuta.mc.signpic.attr.prop.RotationData;
import com.kamesuta.mc.signpic.attr.prop.SizeData;
import com.kamesuta.mc.signpic.entry.Entry;
import com.kamesuta.mc.signpic.entry.EntryId;
import com.kamesuta.mc.signpic.entry.content.Content;
import com.kamesuta.mc.signpic.mode.CurrentMode;
import com.kamesuta.mc.signpic.render.RenderHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySignRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.ResourceLocation;

public class CustomTileEntitySignRenderer
extends TileEntitySignRenderer {
    @Nonnull
    public static final ResourceLocation resError = new ResourceLocation("signpic", "textures/state/error.png");

    public void renderSignPicture(@Nonnull Entry entry, int destroy, float opacity) {
        Content content = entry.getContent();
        AttrReaders attr = entry.getMeta();
        SizeData size01 = content != null ? content.image.getSize() : SizeData.DefaultSize;
        SizeData size = attr.sizes.getMovie().get().aspectSize(size01);
        OpenGL.glPushMatrix();
        OffsetData offset = attr.offsets.getMovie().get();
        OpenGL.glTranslatef(offset.x.offset, offset.y.offset, offset.z.offset);
        RotationData.RotationGL.glRotate(attr.rotations.getMovie().get().getRotate());
        OpenGL.glTranslatef(-size.getWidth() / 2.0f, size.getHeight() + (size.getHeight() >= 0.0f ? 0.0f : -size.getHeight()) - 0.5f, 0.0f);
        OpenGL.glScalef(1.0f, -1.0f, 1.0f);
        entry.getGui().drawScreen(0, 0, 0.0f, opacity, size.getWidth(), size.getHeight(), new RenderOption());
        if (destroy >= 0) {
            OpenGL.glPushMatrix();
            OpenGL.glScalef(size.getWidth(), size.getHeight(), 1.0f);
            WRenderer.startTexture();
            this.func_147499_a(field_178460_a[destroy]);
            OpenGL.glTranslatef(0.0f, 0.0f, 0.01f);
            WRenderer.w.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.addRectVertex(0.0f, 0.0f, 1.0f, 1.0f);
            WRenderer.t.func_78381_a();
            OpenGL.glTranslatef(0.0f, 0.0f, -0.02f);
            WRenderer.w.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.addRectVertex(0.0f, 0.0f, 1.0f, 1.0f);
            WRenderer.t.func_78381_a();
            OpenGL.glPopMatrix();
        }
        OpenGL.glPopMatrix();
    }

    public void translateBase(@Nonnull TileEntitySign tile, double x, double y, double z) {
        Block block = tile.func_145838_q();
        float f1 = 0.6666667f;
        if (block == Blocks.field_150472_an) {
            OpenGL.glTranslatef((float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
            float f2 = (float)(tile.func_145832_p() * 360) / 16.0f;
            OpenGL.glRotatef(-f2, 0.0f, 1.0f, 0.0f);
        } else {
            int j = tile.func_145832_p();
            float f3 = 0.0f;
            if (j == 2) {
                f3 = 180.0f;
            }
            if (j == 4) {
                f3 = 90.0f;
            }
            if (j == 5) {
                f3 = -90.0f;
            }
            OpenGL.glTranslatef((float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
            OpenGL.glRotatef(-f3, 0.0f, 1.0f, 0.0f);
            OpenGL.glTranslatef(0.0f, 0.0f, -0.4375f);
        }
    }

    public void renderSignPictureBase(@Nonnull TileEntitySign tile, double x, double y, double z, float partialTicks, int destroy, float opacity) {
        Entry entry = EntryId.fromTile(tile).entry();
        if (entry.isValid()) {
            if (CurrentMode.instance.isState(CurrentMode.State.SEE)) {
                WRenderer.startTexture();
                OpenGL.glColor4f(1.0f, 1.0f, 1.0f, opacity * Config.getConfig().renderSeeOpacity.get().floatValue());
                super.func_192841_a(tile, x, y, z, partialTicks, destroy, 0.0f);
            }
            OpenGL.glPushMatrix();
            this.translateBase(tile, x, y, z);
            OpenGL.glDisable(2884);
            OpenGL.glDisable(2896);
            this.renderSignPicture(entry, destroy, opacity);
            OpenGL.glEnable(2896);
            OpenGL.glEnable(2884);
            OpenGL.glPopMatrix();
        } else {
            if (opacity < 1.0f) {
                WRenderer.startTexture();
                OpenGL.glColor4f(1.0f, 1.0f, 1.0f, opacity);
            }
            super.func_192841_a(tile, x, y, z, partialTicks, destroy, 0.0f);
        }
    }

    public void func_192841_a(@Nullable TileEntitySign tile, double x, double y, double z, float partialTicks, int destroy, float p_192841_10_) {
        if (tile != null) {
            Client.startSection("signpic-render");
            this.renderSignPictureBase(tile, x, y, z, partialTicks, destroy, 1.0f);
            Client.endSection();
        }
    }
}

